#include <stdio.h>
#include <time.h>

#include "logfile.hpp"

#define min(a,b) ((a < b) ? a : b)

FILE *fpLog = NULL;

bool logopen(char *name)
{
	if (NULL == (fpLog = fopen(name, "a")))
		return false;
	
	return true;
}

void logclose()
{
	fclose(fpLog);
}

int lprintf(const char *format, ...)
{
	time_t tNow = time(NULL);
	char szBuf[128];
	strcpy(szBuf, ctime(&tNow));
	szBuf[strlen(szBuf) - 1] = '\0';
	fprintf(fpLog, "%s: ", szBuf);
	int iResult = vfprintf(fpLog, format, (char *)(&format + 1));
	fflush(NULL);
	return iResult;
}

bool wildcard_compare(char *pszTarget, char *pszSource, int iSourceLength)
{
	bool fgTarget = true;
	bool fgInvert = true;
	if ('!' == *pszTarget) {
		pszTarget++;
		fgInvert = false;
	}
	if ('\0' == *pszTarget)
		pszTarget = "*";
	int i;
	for (i = 0; i < min(iSourceLength, (int)strlen(pszTarget)); i++) {
		if ('*' == pszTarget[i])
			break;
		if (('?' != pszTarget[i]) && (pszSource[i] != pszTarget[i]))
			fgTarget = false;
	}
	if ((iSourceLength != (int)strlen(pszTarget)) && ('*' != pszTarget[i]))
		fgTarget = false;
	
	return fgInvert == fgTarget;
}