#ifndef __OBN_HPP__
#define __OBN_HPP__

#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))
#define HIWORD(a)		((WORD)((a) >> 32))
#define LOWORD(a)		((WORD)(a))

#ifdef WIN32
	typedef unsigned __int32 WORD;
	typedef unsigned __int64 DWORD;
	#define BASE        0x100000000L
	#define BITSINWORD		  	  32
	#define MAXWORD		0xFFFFFFFFL
#else
	typedef unsigned int WORD;
	typedef unsigned long long DWORD;
	#define BASE        0x100000000LL
	#define BITSINWORD		  	  32
	#define MAXWORD		0xFFFFFFFFL
#endif

#define BLOCK					 128

#include <stdio.h>

class CBigNumber
{
	public:
		CBigNumber();
		CBigNumber(WORD);
		CBigNumber(char *);
		CBigNumber(const CBigNumber &);
		CBigNumber(void *, WORD);
		CBigNumber(WORD *);
		virtual ~CBigNumber();
	
	public:
		void SetWords(WORD);
		WORD GetWords() { return wWords; }
		void *GetData() { return pwBigNumber; }
	
		CBigNumber operator = (const CBigNumber &);
		CBigNumber operator + (const CBigNumber &) const;
		CBigNumber operator - (const CBigNumber &) const;
		CBigNumber operator * (const CBigNumber &) const;
		CBigNumber operator / (const CBigNumber &) const;
		CBigNumber operator % (const CBigNumber &) const;
		CBigNumber & operator += (const CBigNumber &);
		CBigNumber & operator -= (const CBigNumber &);
		CBigNumber operator / (WORD) const;
		WORD operator % (WORD) const;
		CBigNumber operator << (WORD) const;
		CBigNumber operator >> (WORD) const;
		CBigNumber & operator <<= (WORD);
		CBigNumber & operator >>= (WORD);
		CBigNumber & operator += (WORD);
		CBigNumber & operator -= (WORD);
		bool operator < (const CBigNumber &) const;
		bool operator <= (const CBigNumber &) const;
		bool operator > (const CBigNumber &) const;
		bool operator >= (const CBigNumber &) const;
		bool operator == (const CBigNumber &) const;
		bool operator != (const CBigNumber &) const;
		bool operator < (WORD);
		bool operator <= (WORD);
		bool operator > (WORD);
		bool operator >= (WORD);
		bool operator == (WORD);
		bool operator != (WORD);
	
		bool IsZero() const;
		bool IsNegative() { return fgSign; }
		bool IsPositive() { return !fgSign; }
	
		void Add(const CBigNumber &);
		void Sub(const CBigNumber &);
		void NormalSub(const CBigNumber &);	
		void Shr();
		void Shl();
	
		int Cmp(const CBigNumber &, const CBigNumber &) const;
	
		static CBigNumber Abs(const CBigNumber &);
		static CBigNumber ModExp(const CBigNumber &, const CBigNumber &, const CBigNumber &);
		static CBigNumber ModExpWord(const CBigNumber &, WORD, const CBigNumber &);
		static CBigNumber GCD(const CBigNumber &, const CBigNumber &);
		static CBigNumber ModInv(const CBigNumber &, const CBigNumber &);
	
		void Dump() const;
		int Rad64Print(FILE *, int) const;
		bool Rad64Read(FILE *);
	
	private:
		void StripLeadingZeroes();
	
	protected:
		WORD *pwBigNumber;
		WORD wWords;
		WORD wAllocated;
		bool fgSign;
};

#endif // __OBN_HPP__