#ifndef __HAVAL_HPP__
#define __HAVAL_HPP__

#define PASSES 5
#define FPTLEN 256
#define VERSION 1

#define f1(x6, x5, x4, x3, x2, x1, x0) ((x1) & ((x0) ^ (x4)) ^ (x2) & (x5) ^ (x3) & (x6) ^ (x0))
#define f2(x6, x5, x4, x3, x2, x1, x0) ((x2) & ((x1) & ~(x3) ^ (x4) & (x5) ^ (x6) ^ (x0)) ^ (x4) & ((x1) ^ (x5)) ^ (x3) & (x5) ^ (x0))
#define f3(x6, x5, x4, x3, x2, x1, x0) ((x3) & ((x1) & (x2) ^ (x6) ^ (x0)) ^ (x1) & (x4) ^ (x2) & (x5) ^ (x0))
#define f4(x6, x5, x4, x3, x2, x1, x0) ((x4) & ((x5) & ~(x2) ^ (x3) & ~(x6) ^ (x1) ^ (x6) ^ (x0)) ^ (x3) & ((x1) & (x2) ^ (x5) ^ (x6)) ^ (x2) & (x6) ^ (x0))
#define f5(x6, x5, x4, x3, x2, x1, x0) ((x0) & ((x1) & (x2) & (x3) ^ ~(x5)) ^ (x1) & (x4) ^ (x2) & (x5) ^ (x3) & (x6))

#if PASSES == 3
#define phi1(x6, x5, x4, x3, x2, x1, x0) f1(x1, x0, x3, x5, x6, x2, x4)
#define phi2(x6, x5, x4, x3, x2, x1, x0) f2(x4, x2, x1, x0, x5, x3, x6)
#define phi3(x6, x5, x4, x3, x2, x1, x0) f3(x6, x1, x2, x3, x4, x5, x0)
#endif

#if PASSES == 4
#define phi1(x6, x5, x4, x3, x2, x1, x0) f1(x2, x6, x1, x4, x5, x3, x0)
#define phi2(x6, x5, x4, x3, x2, x1, x0) f2(x3, x5, x2, x0, x1, x6, x4)
#define phi3(x6, x5, x4, x3, x2, x1, x0) f3(x1, x4, x3, x6, x0, x2, x5)
#define phi4(x6, x5, x4, x3, x2, x1, x0) f4(x6, x4, x0, x5, x2, x1, x3)
#endif

#if PASSES == 5
#define phi1(x6, x5, x4, x3, x2, x1, x0) f1(x3, x4, x1, x0, x5, x2, x6)
#define phi2(x6, x5, x4, x3, x2, x1, x0) f2(x6, x2, x1, x0, x3, x4, x5)
#define phi3(x6, x5, x4, x3, x2, x1, x0) f3(x2, x6, x0, x4, x3, x1, x5)
#define phi4(x6, x5, x4, x3, x2, x1, x0) f4(x1, x5, x3, x2, x0, x4, x6)
#define phi5(x6, x5, x4, x3, x2, x1, x0) f5(x2, x5, x0, x6, x4, x3, x1)
#endif

#define ror(x, n) (((x) >> (n)) | ((x) << (32 - (n))))

#define FF1(x7, x6, x5, x4, x3, x2, x1, x0, w) wTemp = phi1(x6, x5, x4, x3, x2, x1, x0); (x7) = ror(wTemp, 7) + ror((x7), 11) + (w);
#define FF2(x7, x6, x5, x4, x3, x2, x1, x0, w, c) wTemp = phi2(x6, x5, x4, x3, x2, x1, x0); (x7) = ror(wTemp, 7) + ror((x7), 11) + (w) + (c);
#define FF3(x7, x6, x5, x4, x3, x2, x1, x0, w, c) wTemp = phi3(x6, x5, x4, x3, x2, x1, x0); (x7) = ror(wTemp, 7) + ror((x7), 11) + (w) + (c);
#define FF4(x7, x6, x5, x4, x3, x2, x1, x0, w, c) wTemp = phi4(x6, x5, x4, x3, x2, x1, x0); (x7) = ror(wTemp, 7) + ror((x7), 11) + (w) + (c);
#define FF5(x7, x6, x5, x4, x3, x2, x1, x0, w, c) wTemp = phi5(x6, x5, x4, x3, x2, x1, x0); (x7) = ror(wTemp, 7) + ror((x7), 11) + (w) + (c);

#ifdef WIN32
	typedef unsigned char BYTE;
	typedef unsigned __int32 WORD;
	typedef unsigned __int64 DWORD;
#else
	typedef unsigned char BYTE;
	typedef unsigned int WORD;
	typedef unsigned long long DWORD;
#endif

class CHavalDigest
{
	public:
		CHavalDigest();
		CHavalDigest(void *, WORD);
		CHavalDigest(char *);
	
	public:
		BYTE *GetFingerPrint();
	
	protected:
		void HashBlock();
		void HashData(void *, WORD);
		void Initialize();
		void HavalFold();
	
	protected:
		WORD pwFingerPrint[8];
		WORD pwBlock[32];
	
	private:
		DWORD dwBits;
		WORD wTemp;
};

#endif // __HAVAL_HPP__