package util;

sub calc_time
{
	$_ = lc($_[0]);
	
	s/hrs/h/;
	s/hr/h/;
	s/mins/m/;
	s/min/m/;
	s/secs/s/;
	s/sec/s/;
	s/\s*//g;
	
	$check = $_;
	$check =~ s/[0123456789]//g;

	$check =~ s/^h//;
	$check =~ s/^m//;
	$check =~ s/^s//;	
	if ($check ne "") {
		return("");
	}
	
	$hours = $_;
	$hours =~ s/h(.*)//;
	if ($hours eq $_) {
		$hours = 0;
	}
	
	$mins = $_;
	$mins =~ s/m(.*)//;
	if ($mins eq $_) {
		$mins = 0;
	}
	$mins =~ s/(.*)h//;
	
	$secs = $_;
	$secs =~ s/s(.*)//;
	$secs =~ s/(.*)[hm]//;
	
	return ("0" . $hours) * 3600 + ("0" . $mins) * 60 + ("0" . $secs);
}

sub calc_traffic
{
	$_ = lc($_[0]);

	s/gb/g/g;
	s/mb/m/g;
	s/kb/k/g;
	s/bytes/b/g;
	s/\s*//g;
	
	$check = $_;
	$check =~ s/[0123456789]//g;

	$check =~ s/^g//;
	$check =~ s/^m//;
	$check =~ s/^k//;
	$check =~ s/^b//;
	if ($check ne "") {
		return("");
	}
	
	$giga = $_;
	$giga =~ s/g(.*)//;
	if ($giga eq $_) {
		$giga = 0;
	}
	
	$mega = $_;
	$mega =~ s/m(.*)//;
	if ($mega eq $_) {
		$mega = 0;
	}
	$mega =~ s/(.*)g//;
	
	$kilo = $_;
	$kilo =~ s/k(.*)//;
	if ($kilo eq $_) {
		$kilo = 0;
	}
	$kilo =~ s/(.*)[gm]//;
	
	$bytes = $_;
	$bytes =~ s/b(.*)//;
	$bytes =~ s/(.*)[gmk]//;
	
	return ("0" . $giga) * 1024 ** 3 + 
			 ("0" . $mega) * 1024 ** 2 +
			 ("0" . $kilo) * 1024 +
			 ("0" . $bytes);
}

sub get_time
{
	$_[0] = abs($_[0]);

	$hours = int($_[0] / 3600);
	$mins = int(($_[0] / 60) % 60);
	$secs = int($_[0] % 60);
	
	return sprintf("%02d:%02d:%02d", $hours, $mins, $secs);
}

sub get_traffic
{
	$_[0] = abs($_[0]);

	$gb = int($_[0] / 1024 ** 3);
	$mb = int($_[0] / 1024 ** 2) % 1024;
	$kb = int(($_[0] / 1024) % 1024);
	$bb = int($_[0] % 1024);

	$gbs = sprintf("%dGB ", $gb);
	$mbs = sprintf("%dMB ", $mb);
	$kbs = sprintf("%dKB ", $kb);
	$bbs = sprintf("%dB", $bb);
	
	return sprintf("%s%s%s%s",
	               ($gb == 0 ? "" : $gbs),
						($mb == 0 ? "" : $mbs),
						($kb == 0 ? "" : $kbs),
						$bbs);
}

1;