#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use crypto;
use util;
use sock;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "ma_results.html";
$results_file_error = $http_dir . "mf_results.html";

$login = param("login");
$password = param("password");
$target = param("target");

$port = 1098;
$server = "localhost";				# Default value

print header();

$error = "The login field is NOT optional.<BR>\n" if ($login eq "");

$error = "The password field is NOT optional.<BR>\n" if ($password eq "");

$error = "Invalid target.<BR>\n" if ($target eq "");

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (defined(param("time"))) {
	if (open(RESULTS, "< $results_file_error")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				if (util::calc_time(param("time_update")) eq "") {
					printf("Invalid \"time correction\" value.<BR>\n");
					goto quit_update;				
				}
				if (util::calc_traffic(param("traffic_update")) eq "") {
					printf("Invalid \"traffic correction\" value.<BR>\n");
					goto quit_update;				
				}
				
				if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
					printf("Requesting public key from ". $server . "<BR>\n");
					crypto::get_key($server, $port, $key_directory);
					crypto::RSALoadPublicKey($key_directory . "/" . $server);
				}

				$iaddr = inet_aton($server);
				$paddr = sockaddr_in($port, $iaddr);
				$proto = getprotobyname('tcp');

				unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
					printf("Invalid socket call: $!<BR>\n");
					goto quit_update;
				}
				unless (connect(SOCK, $paddr)) {
					printf("Invalid connect call: $!<BR>\n");
					close(SOCK);
					goto quit_update;
				}
				if ('+' ne sock::read_byte(\*SOCK)) {
					printf("Invalid response from server.<BR>\n");
					close(SOCK);
					goto quit_update;
				}
				sock::write_string(\*SOCK, $login);
				crypto::write_password(fileno(SOCK), $password);
				$go_ahead = sock::read_byte(\*SOCK);
				if ('!' eq $go_ahead) {
					sock::write_byte(\*SOCK, 's');
					sock::write_string(\*SOCK, $target);

					if (param("time_add") eq "add") {
						$time = param("time") + util::calc_time(param("time_update"));
					} else {
						$time = util::calc_time(param("time_update"));
					}
					if (param("traffic_add") eq "add") {
						$traffic = param("traffic") + util::calc_traffic(param("traffic_update"));
					} else {
						$traffic = util::calc_traffic(param("traffic_update"));
					}
					$disconnect = param("disconnect") eq "Yes";
					$delete = param("delete") eq "Yes";
					
					sock::write_integer(\*SOCK, $time);
					sock::write_integer(\*SOCK, $traffic);
					sock::write_integer(\*SOCK, $disconnect);
					sock::write_integer(\*SOCK, $delete);
		
					$result = sock::read_byte(\*SOCK);
					if ('+' eq $result) {
						printf("<TABLE BORDER=1 CELLPADDING=1>");
						printf("<TR><TD><B><I>Login:</I></B></TD><TD>%s</TD></TR>\n", $target);
						printf("<TR><TD><B><I>Remaining traffic:</I></B></TD><TD>%s%s%s</TR>\n",
								 $traffic < 0 ? '<FONT COLOR = "FF0000">' : "",
								 util::get_traffic($traffic),
								 $traffic < 0 ? '</FONT>' : "");
						printf("<TR><TD><B><I>Remaining time:</I></B></TD><TD>%s%s%s</TD></TR>\n",
								 $time < 0 ? '<FONT COLOR = "FF0000">' : "",
								 util::get_time($time),
								 $time < 0 ? '</FONT>' : "");
						printf("<TR><TD><B><I>Disable flag:</I></B></TD><TD>%s</TD></TR>\n", $disconnect ? "Yes" : "No");
						printf("<TR><TD><B><I>Delete flag:</I></B></TD><TD>%s</TD></TR>\n", $delete ? "Yes" : "No");
						printf("</TABLE>");
						printf("<I>Negative values are in red.</I><BR>");
					} elsif ('-' eq $result) {
						printf("There is no such user on this host.<BR>\n");
					} elsif ('*' eq $result) {
						printf("Error fetching data for user.<BR>\n");
					} elsif ('~' eq $result) {
						printf("Access denied.<BR>");
					} else {
						printf("Invalid response from server.<BR>\n");
					}
				} elsif ('^' eq $go_ahead) {
					printf("Invalid login.<BR>\n");
				} else {
					printf("Invalid response from server.<BR>\n");
				}
				close(SOCK);
quit_update:
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}
	exit;
}

if (!defined($error)) {
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		$error = "Invalid socket call: $!<BR>\n";
		goto quit;
	}
	unless (connect(SOCK, $paddr)) {
		$error = "Invalid connect call: $!<BR>\n";
		close(SOCK);
		goto quit;
	}
	if ('+' ne sock::read_byte(\*SOCK)) {
		$error = "Invalid response from server.<BR>\n";
		close(SOCK);
		goto quit;
	}
	sock::write_string(\*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(\*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(\*SOCK, 'g');
		sock::write_string(\*SOCK, $target);
		
		$result = sock::read_byte(\*SOCK);
		if ('+' eq $result) {
			$time = sock::read_integer(\*SOCK);
			$traffic = sock::read_integer(\*SOCK);
			$flags = sock::read_integer(\*SOCK);
			$current_time = sock::read_integer(\*SOCK);
			$current_traffic = sock::read_integer(\*SOCK);
		} elsif ('-' eq $result) {
			$error = "There is no such user on this host.<BR>\n";
		} elsif ('*' eq $result) {
			$error = "Error fetching data for user.<BR>\n";
		} elsif ('~' eq $result) {
			$error = "Access denied.<BR>";
		} else {
			$error = "Invalid response from server.<BR>\n";
		}
	} elsif ('^' eq $go_ahead) {
		$error = "Invalid login.<BR>\n";
	} else {
		$error = "Invalid response from server.<BR>\n";
	}
	close(SOCK);
quit:
}

if (defined($error)) {
	if (open(RESULTS, "< $results_file_error")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				printf($error);
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}
} else {
	if (open(RESULTS, "< $results_file")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				display_result();
			} elsif (/<!-- Insert login here -->/) {
				printf("%s\n", $target);
			} elsif (/<!-- Insert traffic here -->/) {
				printf("%s%s%s",
			          $traffic < 0 ? '<FONT COLOR = "FF0000">' : "",
						 util::get_traffic($traffic),
						 $traffic < 0 ? '</FONT>' : "");
			} elsif (/<!-- Insert time here -->/) {
				printf("%s%s%s",
			          $time < 0 ? '<FONT COLOR = "FF0000">' : "",
						 util::get_time($time),
						 $time < 0 ? '</FONT>' : "");
			} elsif (/<!-- Insert disconnect here -->/) {
				if ($flags & 1) {
					printf("<OPTION VALUE = \"Yes\"> Yes\n");
					printf("<OPTION VALUE = \"No\"> No\n");					
				} else {
					printf("<OPTION VALUE = \"No\"> No\n");
					printf("<OPTION VALUE = \"Yes\"> Yes\n");					
				}
			} elsif (/<!-- Insert delete here -->/) {
				if ($flags & 2) {
					printf("<OPTION VALUE = \"Yes\"> Yes\n");
					printf("<OPTION VALUE = \"No\"> No\n");					
				} else {
					printf("<OPTION VALUE = \"No\"> No\n");
					printf("<OPTION VALUE = \"Yes\"> Yes\n");					
				}
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}
}

sub display_result
{
	printf("<INPUT TYPE=hidden NAME=login VALUE=\"%s\">\n", $login);
	printf("<INPUT TYPE=hidden NAME=password VALUE=\"%s\">\n", $password);
	printf("<INPUT TYPE=hidden NAME=target VALUE=\"%s\">\n", $target);
	printf("<INPUT TYPE=hidden NAME=time VALUE=\"%d\">\n", $time);
	printf("<INPUT TYPE=hidden NAME=traffic VALUE=\"%d\">\n", $traffic);
	printf("<INPUT TYPE=hidden NAME=drop VALUE=\"%d\">\n", $flags & 1);
	printf("<INPUT TYPE=hidden NAME=delete VALUE=\"%d\">\n", ($flags & 2) >> 1);	
}
