#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use crypto;
use util;
use sock;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "lu_results.html";

$login = param("login");
$password = param("password");

$port = 1098;
$server = "localhost";				# Default value

if (!defined(param("page"))) {
	$page = 1;
} else {
	$page = param("page");
}

if (!defined(param("target"))) {
	$target = "*";
} else {
	$target = param("target");
}

print header();

$error = "The login field is NOT optional.<BR>\n" if ($login eq "");
$error = "The password field is NOT optional.<BR>\n" if ($password eq "");

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (open(RESULTS, "< $results_file")) {
	while (<RESULTS>) {
		if (/<!-- Insert result here -->/) {
			if (defined($error)) {
				printf($error);
			} else {
				display_results();
			}
		} else {
			printf($_);
		}
	}
	close(RESULTS);
}	

sub display_results() 
{
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		printf("Receiving users from: %s\n", $server);
		printf("Invalid socket call: $!\n");
		return;
	}
	unless (connect(SOCK, $paddr)) {
		printf("Receiving users from: %s\n", $server);
		printf("Invalid connect call: $!\n");
		close(SOCK);
		return;
	}
	if ('+' ne sock::read_byte(*SOCK)) {
		printf("Receiving users from: %s\n", $server);
		printf("Invalid response from server.\n");
		close(SOCK);
		return;
	}
	sock::write_string(*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(*SOCK, 'u');	
		sock::write_string(*SOCK, $target);
		$pages = sock::read_integer(*SOCK);
		
		printf('<TABLE BORDER="1" CELLPADDING="1">');
		printf("\n<TR>");
		printf("<TD ALIGN=CENTER><B><I>Login</B></I></TD>");
		printf("<TD ALIGN=CENTER><B><I>Remaining<BR>time</B></I></TD>");
		printf("<TD ALIGN=CENTER><B><I>Remaining<BR>traffic</B></I></TD>");
		printf("<TD ALIGN=CENTER><B><I>Disable<BR>flag</B></I></TD>");
		printf("<TD ALIGN=CENTER><B><I>Delete<BR>flag</B></I></TD>");		
		printf("</TR>\n");
		
		if (0 != $pages) {
			sock::write_integer(*SOCK, $page);
			$user = sock::read_string(*SOCK);
			while ($user ne "") {
				$time = sock::read_integer(*SOCK);
				$traffic = sock::read_integer(*SOCK);
				$flags = sock::read_integer(*SOCK);
			
				printf("<TR>");
				if ($user eq "\@total\@") {
					printf("<TD ALIGN=RIGHT><B><I>Total:</I></B></TD>");
				} else {
					printf("<TD>$user</TD>");
				}
				printf("<TD>%s%s%s</TD>",
			          $time < 0 ? '<FONT COLOR = "FF0000">' : "",
						 util::get_time($time),
						 $time < 0 ? '</FONT>' : "");				 
				printf("<TD ALIGN=RIGHT>%s%s%s</TD>",
			          $traffic < 0 ? '<FONT COLOR = "FF0000">' : "",
				       util::get_traffic($traffic),
						 $traffic < 0 ? '</FONT>' : "");
				if ($user ne "\@total\@") {
					if ($flags & 1) {
						printf("<TD ALIGN=CENTER>Yes</TD>");
					} else {
						printf("<TD ALIGN=CENTER>No</TD>");
					}
					if ($flags & 2) {
						printf("<TD ALIGN=CENTER>Yes</TD>");
					} else {
						printf("<TD ALIGN=CENTER>No</TD>");
					}
				}
				printf("</TR>\n");

				sock::write_byte(*SOCK, '>');
				$user = sock::read_string(*SOCK);
			}
		}
		
		printf("<TR><TD COLSPAN=5>*** NO DATA ***</TD></TR>\n") if (0 == $pages);
		
		printf("</TABLE>\n");
		printf("<I>Negative values are in red.</I><BR>\n");
		
		printf("<BR>\n");
		printf("Result pages: ");
		printf("<A HREF=%s?page=%d&login=%s&password=%s&target=%s><< Prev</A>", $ENV{"SCRIPT_NAME"}, $page - 1, $login, $password, $target) if (1 != $page);
		printf(" 1 ") if (0 == $pages);
		for ($i = 1; $i <= $pages; $i++) {
			if ($i == $page) {
				printf(" %d ", $i);
			} else {
				printf(" <A HREF=%s?page=%d&login=%s&password=%s&target=%s>%d</A> ", $ENV{"SCRIPT_NAME"}, $i, $login, $password, $target, $i);
			}
		}
		printf("<A HREF=%s?page=%d&login=%s&password=%s&target=%s>Next >></A>", $ENV{"SCRIPT_NAME"}, $page + 1, $login, $password, $target) if ($pages != $page && $pages != 0);
		printf("<BR>\n");
	} elsif ('^' eq $go_ahead) {
		printf("Invalid login.\n");
	} else {
		printf("Invalid response from server.\n");
	}
	close(SOCK);
}
