#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use crypto;
use util;
use sock;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "lh_results.html";

$login = param("login");
$password = param("password");
$start_date = param("start_date");
$final_date = param("final_date");

$port = 1098;
$server = "localhost";				# Default value

if (!defined(param("page"))) {
	$page = 1;
} else {
	$page = param("page");
}

if (!defined(param("target"))) {
	$target = "*";
} else {
	$target = param("target");
}

print header();

$error = "The login field is NOT optional.<BR>\n" if ($login eq "");

$error = "The password field is NOT optional.<BR>\n" if ($password eq "");

$target = $login if ($target eq "\@login\@");

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (open(RESULTS, "< $results_file")) {
	while (<RESULTS>) {
		if (/<!-- Insert result here -->/) {
			if (defined($error)) {
				printf($error);
			} else {
				display_results();
			}
		} else {
			printf($_);
		}
	}
	close(RESULTS);
}	

sub display_results() 
{
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		printf("Receiving hrono from: %s\n", $server);
		printf("Invalid socket call: $!\n");
		return;
	}
	unless (connect(SOCK, $paddr)) {
		printf("Receiving hrono from: %s\n", $server);
		printf("Invalid connect call: $!\n");
		close(SOCK);
		return;
	}
	if ('+' ne sock::read_byte(*SOCK)) {
		printf("Receiving hrono from: %s\n", $server);
		printf("Invalid response from server.\n");
		close(SOCK);
		return;
	}
	
	@start_date = gmtime($start_date);
	@final_date = gmtime($final_date);
	printf("<H3>%02d:%02d %02d/%02d/%02d - %02d:%02d %02d/%02d/%02d</H3>",
			 $start_date[2],
			 $start_date[1],
 			 $start_date[3],
			 $start_date[4] + 1,
			 $start_date[5],
			 $final_date[2],
			 $final_date[1],
 			 $final_date[3],
			 $final_date[4] + 1,
			 $final_date[5]);

	sock::write_string(*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(*SOCK, 'h');
		sock::write_string(*SOCK, $target);
		sock::write_integer(*SOCK, $start_date);
		sock::write_integer(*SOCK, $final_date);
		$pages = sock::read_integer(*SOCK);
		
		printf('<TABLE BORDER="1" CELLPADDING="1">');
		printf("\n<TR>");
		printf("<TD><B><I>Login</B></I></TD>");
		printf("<TD><B><I>Line</B></I></TD>");
		printf("<TD><B><I>Host</B></I></TD>");	
		printf("<TD><B><I>Login time</B></I></TD>");
		printf("<TD><B><I>Session time</B></I></TD>");
		printf("<TD><B><I>Received bytes</B></I></TD>");
		printf("<TD><B><I>Sent bytes</B></I></TD>");
		printf("<TD><B><I>Total traffic</B></I></TD>");
		printf("</TR>\n");
		
		if (0 != $pages) {
			sock::write_integer(*SOCK, $page);
			$user = sock::read_string(*SOCK);
			while ($user ne "") {
				$device = sock::read_string(*SOCK);
				$host = sock::read_string(*SOCK);
				$start_time = sock::read_integer(*SOCK);
				$final_time = sock::read_integer(*SOCK);
				$login_time = sock::read_integer(*SOCK);
				$input_traffic = sock::read_integer(*SOCK);
				$output_traffic = sock::read_integer(*SOCK);
				$total_traffic = sock::read_integer(*SOCK);
			
				printf("<TR>");
				if ($user eq "\@total\@") {
					printf("<TD COLSPAN=4 ALIGN=RIGHT><B><I>Total:</I></B></TD>");
				} else {
					printf("<TD>$user</TD>");
					printf("<TD>$device</TD>");
					printf("<TD>$host</TD>");
					@login_time = localtime($start_time);
					printf("<TD>%02d:%02d:%02d %02d/%02d</TD>",
							 $login_time[2],
							 $login_time[1],
							 $login_time[0],
							 $login_time[3],
							 $login_time[4] + 1);
				}
				printf("<TD>%s</TD>", util::get_time($login_time));
				printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($input_traffic));
				printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($output_traffic));
				printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($total_traffic));
				printf("</TR>\n");

				sock::write_byte(*SOCK, '>');
				$user = sock::read_string(*SOCK);
			}
		}
		
		if (0 == $pages) {
			printf("<TR><TD COLSPAN=8>*** NO DATA ***</TD></TR>\n");
		}
		
		printf("</TABLE>\n");
		printf("<I>NOTE: Traffic flow direction is considered from the viewpoint of the accounting server.</I><BR>\n");
		
		printf("<BR>\n");
		printf("Result pages: ");
		printf("<A HREF=%s?page=%d&login=%s&password=%s&target=%s&start_date=%s&final_date=%s><< Prev</A>", $ENV{"SCRIPT_NAME"}, $page - 1, $login, $password, $target, $start_date, $final_date) if (1 != $page);
		printf(" 1 ") if (0 == $pages);
		for ($i = 1; $i <= $pages; $i++) {
			if ($i == $page) {
				printf(" %d ", $i);
			} else {
				printf(" <A HREF=%s?page=%d&login=%s&password=%s&target=%s&start_date=%s&final_date=%s>%d</A> ", $ENV{"SCRIPT_NAME"}, $i, $login, $password, $target, $start_date, $final_date, $i);
			}
		}
		printf("<A HREF=%s?page=%d&login=%s&password=%s&target=%s&start_date=%s&final_date=%s>Next >></A>", $ENV{"SCRIPT_NAME"}, $page + 1, $login, $password, $target, $start_date, $final_date) if ($pages != $page && $pages != 0);
		printf("<BR>\n");
	} elsif ('^' eq $go_ahead) {
		printf("Invalid login.\n");
	} else {
		printf("Invalid response from server.\n");
	}
	close(SOCK);
}
