#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use sock;
use util;
use crypto;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "lc_results.html";

$login = param("login");
$password = param("password");

$port = 1098;
$server = "localhost";				# Default value

print header();

if ($login eq "") {
	$error = "The login field is NOT optional.<BR>\n";
}

if ($password eq "") {
	$error = "The password field is NOT optional.<BR>\n";
}

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (open(RESULTS, "< $results_file")) {
	while (<RESULTS>) {
		if (/<!-- Insert result here -->/) {
			if (defined($error)) {
				printf($error);
			} else {
				display_results();
			}
		} else {
			printf($_);
		}
	}
	close(RESULTS);
}

sub display_results() 
{
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		printf("Requesting public key from ". $server . "<BR>\n");
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		printf("Receiving current users from: %s\n", $server);
		printf("Invalid socket call: $!\n");
		return;
	}
	unless (connect(SOCK, $paddr)) {
		printf("Receiving current users from: %s\n", $server);
		printf("Invalid connect call: $!\n");
		close(SOCK);
		return;
	}
	if ('+' ne sock::read_byte(\*SOCK)) {
		printf("Receiving current users from: %s\n", $server);
		printf("Invalid response from server.\n");
		close(SOCK);
		return;
	}

	$now = localtime;
	printf("<H3>%s</H3>", $now);

	sock::write_string(\*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(\*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(\*SOCK, 'c');
		
		printf('<TABLE BORDER="1" CELLPADDING="1">');
		printf("\n<TR>");
		printf("<TD><B><I>Login</B></I></TD>");
		printf("<TD><B><I>Line</B></I></TD>");
		printf("<TD><B><I>Host</B></I></TD>");
		printf("<TD><B><I>Gateway</B></I></TD>");
		printf("<TD><B><I>Login time</B></I></TD>");
		printf("<TD><B><I>Last update time</B></I></TD>");
		printf("<TD><B><I>Session<BR>time</B></I></TD>");
		printf("<TD><B><I>Received<BR>bytes</B></I></TD>");
		printf("<TD><B><I>Sent<BR>bytes</B></I></TD>");
		printf("<TD><B><I>Total<BR>traffic</B></I></TD>");
		printf("</TR>\n");
		
		$records = 0;
		$total_time = 0;
		$total_input_traffic = 0;
		$total_output_traffic = 0;
		
		$user = sock::read_string(\*SOCK);
		while ($user ne "") {
			$device = sock::read_string(\*SOCK);
			$host = sock::read_string(\*SOCK);
			$gateway = sock::read_string(\*SOCK);
			$start_time = sock::read_integer(\*SOCK);
			$final_time = sock::read_integer(\*SOCK);
			$input_traffic = sock::read_integer(\*SOCK);
			$output_traffic = sock::read_integer(\*SOCK);
			$total_traffic = $input_traffic + $output_traffic;			
			
			printf("<TR>");
			printf("<TD>$user</TD>");
			printf("<TD>$device</TD>");
			printf("<TD>$host</TD>");
			printf("<TD>$gateway</TD>");
			@login_time = localtime($start_time);
			printf("<TD>%02d:%02d:%02d %02d/%02d</TD>",
					 $login_time[2],
					 $login_time[1],
					 $login_time[0],
					 $login_time[3],
					 $login_time[4] + 1);
			@update_time = localtime($final_time);
			printf("<TD>%02d:%02d:%02d %02d/%02d</TD>",
					 $update_time[2],
					 $update_time[1],
					 $update_time[0],
					 $update_time[3],
					 $update_time[4] + 1);
			printf("<TD>%s</TD>", util::get_time($final_time - $start_time));
			printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($input_traffic));
			printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($output_traffic));
			printf("<TD ALIGN=RIGHT>%s</TD>", util::get_traffic($total_traffic));
			printf("</TR>\n");
					 
			sock::write_byte(\*SOCK, '>');
			$user = sock::read_string(\*SOCK);
			
			$records += 1;
			$total_time += ($final_time - $start_time);
			$total_input_traffic += $input_traffic;
			$total_output_traffic += $output_traffic;
		}
		
		if (0 == $records) {
			printf("<TR><TD COLSPAN=8>*** NO DATA ***</TD></TR>\n");
		} else {
			printf("<TR>\n");
			printf("<TD COLSPAN=5 ALIGN=RIGHT><B><I>Total (%d Record%s):</B></I></TD>\n", $records, $records == 1 ? "" : "s");
			printf("<TD>%s</TD>\n", util::get_time($total_time));
			printf("<TD ALIGN=RIGHT>%s</TD>\n", util::get_traffic($total_input_traffic));
			printf("<TD ALIGN=RIGHT>%s</TD>\n", util::get_traffic($total_output_traffic));
			printf("<TD ALIGN=RIGHT>%s</TD>\n", util::get_traffic($total_input_traffic + $total_output_traffic));
			printf("</TR>\n");
		}
		
		printf("</TABLE>\n");
		printf("<I>NOTE: Traffic flow direction is considered from the viewpoint of the accounting server.</I><BR>\n");
	} elsif ('^' eq $go_ahead) {
		printf("Invalid login.\n");
	} else {
		printf("Invalid response from server.\n");
	}
	close(SOCK);
}
