#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use crypto;
use sock;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "da_results.html";

$login = param("login");
$target = param("target");
$password = param("password");

$port = 1098;
$server = "localhost";				# Default value

$final_string = "";

print header();

if ($login eq "") {
	$final_string = "The login field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($password eq "") {
	$final_string = "The password field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($target eq "") {
	$final_string = "The target field is NOT optional.\n";
	display_result($final_string);
	exit;
}

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
	$final_string = $final_string . "Requesting public key from ". $server . "\n";
	crypto::get_key($server, $port, $key_directory);
	crypto::RSALoadPublicKey($key_directory . "/" . $server);
}

$iaddr = inet_aton($server);
$paddr = sockaddr_in($port, $iaddr);
$proto = getprotobyname('tcp');

unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
	$final_string = $final_string . "Invalid socket call: $!\n";
	goto quit;
}
unless (connect(SOCK, $paddr)) {
	$final_string = $final_string . "Invalid connect call: $!\n";
	close(SOCK);
	goto quit;
}
if ('+' ne sock::read_byte(\*SOCK)) {
	$final_string = $final_string . "Invalid response from server.\n";
	close(SOCK);
	goto quit;
}
sock::write_string(\*SOCK, $login);
crypto::write_password(fileno(SOCK), $password);
$go_ahead = sock::read_byte(\*SOCK);
if ('!' eq $go_ahead) {
	sock::write_byte(\*SOCK, 'd');	
	sock::write_string(\*SOCK, $target);
	$result = sock::read_byte(\*SOCK);
	if ('+' eq $result) {
		$final_string = $final_string . "User successfully deleted.\n";
	} elsif ('-' eq $result) {
		$final_string = $final_string . "There is no such user on this host.\n";
	} elsif ('*' eq $result) {
		$final_string = $final_string . "User is not deleted. Server returned error.\n";
	} elsif ('~' eq $result) {
		$final_string = $final_string . "Access denied.\n";
	} else {
		$final_string = $final_string . "Invalid response from server.\n";
	}
} elsif ('^' eq $go_ahead) {
	$final_string = $final_string . "Invalid login.\n";
} else {
	$final_string = $final_string . "Invalid response from server.\n";
}

close(SOCK);

quit:

display_result($final_string);

sub display_result
{
	if (open(RESULTS, "< $results_file")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				$_[0] =~ s/\n/<BR>\n/g;
				printf($_[0]);
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}	
}