#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use sock;
use crypto;
use util;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "aab_results.html";

$login = param("login");
$password = param("password");
$gecos = ',,,,';
$traffic = util::calc_traffic(param("traffic"));
$time = util::calc_time(param("time"));
$accounts = param("accounts");

$port = 1098;
$passwdd_port = 1099;
$server = "localhost";				# Default value

$final_string = "<HR>";

print header();

if ($login eq "") {
	$final_string = "The login field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($password eq "") {
	$final_string = "The password field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($accounts eq "") {
	$final_string = "The target field is NOT optional.\n";
	display_result($final_string);
	exit;
}

if ($time eq "") {
   $final_string = "Error in the time box.\n";
   display_result($final_string);
   exit;
}
			
if ($traffic eq "") {
   $final_string = "Error in the traffic box.\n";
   display_result($final_string);
   exit;
}

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$passwdd_port = int($entry[1]) if ((lc($section) eq "[passwdd]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
		@targets = split('\s*[,;]\s*', $entry[1]) if ((lc($section) eq "[passwdd]") && (lc($entry[0]) eq "hosts"));
	}
	close(CONF);
}

unless (open(DICT, "< /usr/dict/words")) {
	$final_string = "Error opening dictionary file (/usr/dict/words)...\n";
	display_result($final_string);
	exit;
}

for ($i = 0; $i < $accounts; $i++) {
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		$final_string = $final_string . "Requesting public key from ". $server . "\n";
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$target = get_random_login();
	$new_password = get_password();
	
	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	$final_string = $final_string . "Adding " . $target . " on ". $server . "\n";
	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		$final_string = $final_string . "Invalid socket call: $!\n";
		next;
	}
	unless (connect(SOCK, $paddr)) {
		$final_string = $final_string . "Invalid connect call: $!\n";
		close(SOCK);
		next;
	}
	if ('+' ne sock::read_byte(\*SOCK)) {
		$final_string = $final_string . "Invalid response from server.\n";
		close(SOCK);
		next;
	}
	sock::write_string(*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(\*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(*SOCK, 'a');	
		sock::write_string(*SOCK, $target);
		sock::write_string(*SOCK, $gecos);
		sock::write_integer(*SOCK, $time);
		sock::write_integer(*SOCK, $traffic);
		sock::write_integer(*SOCK, 1);
		sock::write_integer(*SOCK, 1);
		$result = sock::read_byte(\*SOCK);
		
		$fgAdded = 0;
		if ('+' eq $result) {
			$final_string = $final_string . "User successfully added.\n";
			$fgAdded = 1;
		} elsif ('-' eq $result) {
			$final_string = $final_string . "There is already such user on this host.\n";
		} elsif ('*' eq $result) {
			$final_string = $final_string . "User is not added. Server returned error.\n";
		} elsif ('~' eq $result) {
			$final_string = $final_string . "Access denied.\n";
		} else {
			$final_string = $final_string . "Invalid response from server.\n";
		}
		close(SOCK);
	} elsif ('^' eq $go_ahead) {
		$final_string = $final_string . "Invalid login.\n";
		close(SOCK);
		$final_string = $final_string . "<HR>";			
		next;
	} else {
		$final_string = $final_string . "Invalid response from server.\n";
		close(SOCK);
	}

	if (1 == $fgAdded) {
		foreach $remote (@targets) {
			if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $remote)) {
				$final_string = $final_string . "Requesting public key from ". $remote . "\n";
				crypto::get_key($remote, $passwdd_port, $key_directory);
				crypto::RSALoadPublicKey($key_directory . "/" . $remote);
			}
	
			$iaddr = inet_aton($remote);
			$paddr = sockaddr_in($passwdd_port, $iaddr);
			$proto = getprotobyname('tcp');

			$final_string = $final_string . "Changing password of " . $target . " on ". $remote . "\n";
			$final_string = $final_string . "New password: " . $new_password . "\n";
			unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
				$final_string = $final_string . "Invalid socket call: $!\n";
				next;
			}
			unless (connect(SOCK, $paddr)) {
				$final_string = $final_string . "Invalid connect call: $!\n";
				close(SOCK);
				next;
			}
			if ('+' ne sock::read_byte(\*SOCK)) {
				$final_string = $final_string . "Invalid response from server.\n";
				close(SOCK);
				next;
			}
			sock::write_string(*SOCK, $login);
			crypto::write_password(fileno(SOCK), $password);
			$go_ahead = sock::read_byte(\*SOCK);
			if ('!' eq $go_ahead) {
				sock::write_byte(*SOCK, 'c');	
				sock::write_string(*SOCK, $target);
				crypto::write_password(fileno(SOCK), $new_password);
				sock::write_integer(*SOCK, 0);
				sock::write_integer(*SOCK, 99999);
				sock::write_integer(*SOCK, -1);
				sock::write_integer(*SOCK, -1);
				$result = sock::read_byte(\*SOCK);
				if ('+' eq $result) {
					$final_string = $final_string . "Password successfully changed.\n";
					sock::write_string(*SOCK, "");
				} elsif ('-' eq $result) {
					$final_string = $final_string . "Invalid target specified.\n";
				} elsif ('$' eq $result) {
					$final_string = $final_string . "Weak password: %s" . read_string(SOCK) . "\n";
				} elsif ('*' eq $result) {
					$final_string = $final_string . "Password still unchanged. Server returned error.\n";
				} elsif ('~' eq $result) {
					$final_string = $final_string . "Access denied.\n";
				} else {
					$final_string = $final_string . "Invalid response from server.\n";
				}
				close(SOCK);
				next;
			}
			if ('^' eq $go_ahead) {
				$final_string = $final_string . "Invalid login.\n";
				$final_string = $final_string . "<HR>";
				close(SOCK);
				next;
			} 
			$final_string = $final_string . "Invalid response from server.\n";
			close(SOCK);
		}
	}
	$final_string = $final_string . "<HR>";
}

close(DICT);

display_result($final_string);

sub get_password
{
	$result = "" . chr(rand(26) + 65);
	for ($p = 0; $p < 4; $p++) {
		$result = $result . chr(rand(26) + 97);
	}
	$result = $result . chr(rand(26) + 65);
	$result = $result . chr(rand(10) + 48);
	$result = $result . chr(rand(10) + 48);
	return $result;
}

sub display_result
{
	if (open(RESULTS, "< $results_file")) {
		while (<RESULTS>) {
			if (/<!-- Insert result here -->/) {
				$_[0] =~ s/\n/<BR>\n/g;
				printf($_[0]);
			} else {
				printf($_);
			}
		}
		close(RESULTS);
	}	
}

sub get_random_login
{
	seek(DICT, 0, 2);
	$filesize = tell(DICT);
	seek(DICT, 0, 0);
	seek(DICT, rand($filesize - 1), 0);
	while (0 != tell(DICT)) {
		read(DICT, $c, 1);
		if ("\n" eq $c) {
			last;		
		}
	   seek(DICT, -2, 0);
	}
	$result = "error";
	if (!eof(DICT)) {
		$result = lc(<DICT>);
		chomp($result);
	}
	while (length($result) < 3) {
		$result = $result . '_' . $result;
	}
	$result = substr($result, 0, 8);	
	return $result;
}