#!/usr/bin/perl -w
require 5.002;
use Socket;
use CGI qw(:standard);
use crypto;
use util;
use sock;

$config_dir = "/etc/"; 
$http_dir = "/var/lib/apache/htdocs/crocodiles/"; 

$config_file = $config_dir . "alligator-client.conf";
$results_file = $http_dir . "ai_results.html";

$login = param("login");
$password = param("password");
$target = $login;

$port = 1098;
$server = "localhost";				# Default value

print header();

$error = "The login field is NOT optional.<BR>\n" if ($login eq "");

$error = "The password field is NOT optional.<BR>\n" if ($password eq "");

# Parse config file.
$section = "";
if (open(CONF, "< $config_file")) {
	while (<CONF>) {
		chomp;
		s/^\s*|\s*$//g;					# Remove leading and trailing spaces
												# and tabs.
		next if ($_ eq "");				# Skip empty lines.
		next if (/^[\#\%]/);				# Skip comments
		if (/^\[(.*)\]$/) {				# This is a section name because the
												# first character is '[' and the last
												# is ']'.
			$section = $_;
			next;
		}
		@entry = split(/\s*=\s*/); 
# Skip keys only or keys with more than one values.
		next if (defined($entry[2]) || !defined($entry[1]));
# Here begins program specific section.
		$port = int($entry[1]) if ((lc($section) eq "[global]") && (lc($entry[0]) eq "port"));
		$server = $entry[1] if ((lc($section) eq "[global]") && (lc($entry[0]) eq "target"));
		$key_directory = $entry[1] if ((lc($section) eq "[security]") && (lc($entry[0]) eq "key_directory"));
	}
	close(CONF);
}

if (!defined($error)) {
	if (0 == crypto::RSALoadPublicKey($key_directory . "/" . $server)) {
		crypto::get_key($server, $port, $key_directory);
		crypto::RSALoadPublicKey($key_directory . "/" . $server);
	}

	$iaddr = inet_aton($server);
	$paddr = sockaddr_in($port, $iaddr);
	$proto = getprotobyname('tcp');

	unless (socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		$error = "Invalid socket call: $!<BR>\n";
		goto quit;
	}
	unless (connect(SOCK, $paddr)) {
		$error = "Invalid connect call: $!<BR>\n";
		close(SOCK);
		goto quit;
	}
	if ('+' ne sock::read_byte(\*SOCK)) {
		$error = "Invalid response from server.<BR>\n";
		close(SOCK);
		goto quit;
	}
	sock::write_string(\*SOCK, $login);
	crypto::write_password(fileno(SOCK), $password);
	$go_ahead = sock::read_byte(\*SOCK);
	if ('!' eq $go_ahead) {
		sock::write_byte(\*SOCK, 'g');
		sock::write_string(\*SOCK, $target);
		
		$result = sock::read_byte(\*SOCK);
		if ('+' eq $result) {
			$time = sock::read_integer(\*SOCK);
			$traffic = sock::read_integer(\*SOCK);
			$flags = sock::read_integer(\*SOCK);
			$current_time = sock::read_integer(\*SOCK);
			$current_traffic = sock::read_integer(\*SOCK);
		} elsif ('-' eq $result) {
			$error = "There is no such user on this host.<BR>\n";
		} elsif ('*' eq $result) {
			$error = "Error fetching data for user.<BR>\n";
		} elsif ('~' eq $result) {
			$error = "Access denied.<BR>";
		} else {
			$error = "Invalid response from server.<BR>\n";
		}
	} elsif ('^' eq $go_ahead) {
		$error = "Invalid login.<BR>\n";
	} else {
		$error = "Invalid response from server.<BR>\n";
	}
	close(SOCK);
quit:
}

if (open(RESULTS, "< $results_file")) {
	while (<RESULTS>) {
		if (/<!-- Insert result here -->/) {
			if (defined($error)) {
				printf($error);
			} else {
				display_result();
			}
		} else {
			printf($_);
		}
	}
	close(RESULTS);
}

sub display_result
{
	printf("<H3>Account summary.</H3>\n");		
	printf("<TABLE BORDER=1 CELLPADDING=1>\n");
	printf("<TR><TD><B><I>Login:</I></B></TD><TD>%s</TD></TR>\n", $login);
	printf("<TR><TD><B><I>Remaining traffic:</I></B></TD><TD ALIGN=RIGHT>%s%s%s</TD></TR>\n",
          $traffic < 0 ? '<FONT COLOR = "FF0000">' : "",
	       util::get_traffic($traffic),
			 $traffic < 0 ? '</FONT>' : "");
	printf("<TR><TD><B><I>Remaining time:</I></B></TD><TD>%s%s%s</TD></TR>\n",
			 $time < 0 ? '<FONT COLOR = "FF0000">' : "",
			 util::get_time($time),
			 $time < 0 ? '</FONT>' : "");				 
	printf("<TR><TD><B><I>Disable flag:</I></B></TD><TD>%s</TD></TR>\n", $flags & 1 ? "Yes" : "No");
	printf("<TR><TD><B><I>Delete flag:</I></B></TD><TD>%s</TD></TR>\n", $flags & 2 ? "Yes" : "No");	
	printf("</TABLE>\n");
	printf("<I>Negative values are in red.</I><BR>\n");
	printf("<H3>This session summary.</H3>\n");		
	printf("<TABLE BORDER=1 CELLPADDING=1>\n");
	printf("<TR><TD><B><I>Current traffic:</I></B></TD><TD ALIGN=RIGHT>%s%s%s</TD></TR>\n",
          $traffic < 0 ? '<FONT COLOR = "FF0000">' : "",
	       util::get_traffic($current_traffic),
			 $traffic < 0 ? '</FONT>' : "");
	printf("<TR><TD><B><I>Current time:</I></B></TD><TD>%s%s%s</TD></TR>\n",
			 $time < 0 ? '<FONT COLOR = "FF0000">' : "",
			 util::get_time($current_time),
			 $time < 0 ? '</FONT>' : "");				 
	printf("</TABLE>\n");
	printf("<I>Negative values are in red.</I><BR>\n");
}
