#include <stdio.h>
#include <string.h>

#include "users_box.hpp"
#include "util.hpp"

CUsersBox::CUsersBox()
{
	char *ppszRow[] = { "login",
		  					  "time",
							  "traffic",
		  					  "flags" };
	
	pUsersWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	pClose = gtk_button_new_with_label("Close");
	pUsersList = gtk_clist_new_with_titles(4, ppszRow);
	
	pScrolledWindow = gtk_scrolled_window_new(NULL, NULL);
	
	gtk_signal_connect(GTK_OBJECT(pClose), "clicked", GTK_SIGNAL_FUNC(OnMessageClose), this);
	
	gtk_widget_set_usize(pClose, 50, -1);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	
	gtk_container_add(GTK_CONTAINER(pUsersWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pScrolledWindow, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pClose, TRUE, FALSE, 5);
	
	gtk_window_set_title(GTK_WINDOW(pUsersWindow), "Users Summary");
	
	gtk_clist_set_shadow_type(GTK_CLIST(pUsersList), GTK_SHADOW_IN);
	
	gtk_container_add(GTK_CONTAINER(pScrolledWindow), pUsersList);
}

gint CUsersBox::OnMessageClose(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CUsersBox *)pData)->pUsersWindow);
	
	delete (CUsersBox *)pData;
	
	return TRUE;
}

void CUsersBox::AddRecord(char *pszLogin,
								  time_t tTime,
								  int iTraffic,
								  int iFlags)
{
	char szTime[128];
	char szTraffic[32];
	char szFlags[32];
	
	snprintf(szTraffic, sizeof(szTraffic), "%s", GetTraffic(iTraffic));
	snprintf(szTime, sizeof(szTime), "%s", GetTime(tTime));	
	snprintf(szFlags, sizeof(szFlags), "%d", iFlags);
	
	char *ppszRow[] = { pszLogin,
							  GetTime(tTime),
							  szTraffic,
		  					  szFlags };
	char *ppszAll[] = { "Total:",
							  szTime,
							  szTraffic,
		  					  "" };
	if (0 == strcmp(pszLogin, "@total@"))
		gtk_clist_append(GTK_CLIST(pUsersList), ppszAll);
	else
		gtk_clist_append(GTK_CLIST(pUsersList), ppszRow);
}

void CUsersBox::ShowBox()
{
	for (int j = 0; j < 4; j++)	
		gtk_clist_set_column_auto_resize(GTK_CLIST(pUsersList), j, TRUE);
	
	gtk_widget_show(pUsersWindow);
	gtk_widget_show(pScrolledWindow);
	gtk_widget_show(pUsersList); 
	
	gtk_widget_set_usize(pScrolledWindow, 220, 200);
	
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pClose);
}