#include <string.h>
#include <stdlib.h>

#include "time_box.hpp"
#include "message_box.hpp"
#include "client.hpp"

CTimeBox::CTimeBox(int socket, char *pszUser, bool fgSystem)
{
	fgSelf = !fgSystem;
	
	sockfd = socket;
	
	pszLogin = pszUser;

	pTimeWindow = gtk_window_new(GTK_WINDOW_DIALOG);

	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	
	GtkWidget *pHelp = gtk_hbox_new(FALSE, FALSE);

	if (fgSystem) {
		pTargetLabel = gtk_label_new("Target login:");
		pTarget = gtk_entry_new_with_max_length(8);
	}
	
	pLeftFrame = gtk_frame_new("From");
	pRightFrame = gtk_frame_new("To");
	
	pLeftVertBox = gtk_vbox_new(FALSE, FALSE);
	pLeftRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pLeftRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	pRightVertBox = gtk_vbox_new(FALSE, FALSE);
	pRightRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRightRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_container_add(GTK_CONTAINER(pTimeWindow), pVertBox);
	gtk_container_add(GTK_CONTAINER(pLeftFrame), pLeftVertBox);
	gtk_container_add(GTK_CONTAINER(pRightFrame), pRightVertBox);	
	
	pStartCalendar = gtk_calendar_new();
	pFinalCalendar = gtk_calendar_new();
	pOK = gtk_button_new_with_label("OK");
	pCancel = gtk_button_new_with_label("Cancel");
	
	pLeftHours = gtk_entry_new_with_max_length(2);
	pLeftMins = gtk_entry_new_with_max_length(2);
	pRightHours = gtk_entry_new_with_max_length(2);
	pRightMins = gtk_entry_new_with_max_length(2);
	pLabelLeft = gtk_label_new(":");
	pLabelRight = gtk_label_new(":");
	
	gtk_signal_connect(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnMessageCancel), this);
	gtk_signal_connect(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), this);
	
	gtk_widget_set_usize(pOK, 50, -1);
	gtk_widget_set_usize(pCancel, 50, -1);
	
	gtk_entry_set_text(GTK_ENTRY(pLeftHours), "00");
	gtk_entry_set_text(GTK_ENTRY(pLeftMins), "00");
	gtk_entry_set_text(GTK_ENTRY(pRightHours), "24");
	gtk_entry_set_text(GTK_ENTRY(pRightMins), "00");
	
// One or more of these will work :)
	gtk_calendar_select_day(GTK_CALENDAR(pFinalCalendar), 28);
	gtk_calendar_select_day(GTK_CALENDAR(pFinalCalendar), 29);
	gtk_calendar_select_day(GTK_CALENDAR(pFinalCalendar), 30);
	gtk_calendar_select_day(GTK_CALENDAR(pFinalCalendar), 31);
// Last day of month is selected...

	gtk_window_set_title(GTK_WINDOW(pTimeWindow), "Time Dialog");

	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, FALSE, 5);
	
	gtk_box_pack_start(GTK_BOX(pLeftVertBox), pLeftRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pLeftVertBox), pLeftRowBox2, FALSE, TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRightVertBox), pRightRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pRightVertBox), pRightRowBox2, FALSE, TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLeftFrame, TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox1), pRightFrame, TRUE, TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(pHelp), pOK, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pCancel, TRUE, FALSE, 5);
	if (fgSystem) {
		gtk_box_pack_start(GTK_BOX(pRowBox2), pTargetLabel, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pRowBox2), pTarget, FALSE, FALSE, 5);
	}
	gtk_box_pack_start(GTK_BOX(pRowBox3), pHelp, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pLeftRowBox1), pStartCalendar, TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pRightRowBox1), pFinalCalendar, TRUE, TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(pLeftRowBox2), pLeftHours, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pLeftRowBox2), pLabelLeft, FALSE, TRUE, 0);	
	gtk_box_pack_start(GTK_BOX(pLeftRowBox2), pLeftMins, FALSE, TRUE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRightRowBox2), pRightHours, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pRightRowBox2), pLabelRight, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(pRightRowBox2), pRightMins, FALSE, TRUE, 5);
	
	gtk_widget_set_usize(pLeftHours, 25, -1);
	gtk_widget_set_usize(pLeftMins, 25, -1);
	gtk_widget_set_usize(pRightHours, 25, -1);
	gtk_widget_set_usize(pRightMins, 25, -1);

	if (fgSystem) {
		gtk_widget_set_usize(pTarget, 90, -1);
		
		gtk_widget_show(pTarget);
		gtk_widget_show(pTargetLabel);
	}
	gtk_widget_show(pHelp);
	gtk_widget_show(pLabelLeft);
	gtk_widget_show(pLabelRight);
	gtk_widget_show(pLeftHours);
	gtk_widget_show(pLeftMins);
	gtk_widget_show(pRightHours);
	gtk_widget_show(pRightMins);
	gtk_widget_show(pStartCalendar);
	gtk_widget_show(pFinalCalendar);
	gtk_widget_show(pLeftFrame);
	gtk_widget_show(pRightFrame);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pLeftVertBox);
	gtk_widget_show(pLeftRowBox1);
	gtk_widget_show(pLeftRowBox2);
	gtk_widget_show(pRightVertBox);
	gtk_widget_show(pRightRowBox1);
	gtk_widget_show(pRightRowBox2);
	gtk_widget_show(pOK);
	gtk_widget_show(pCancel);
	gtk_widget_show(pTimeWindow);
}

gint CTimeBox::OnMessageCancel(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CTimeBox *)pData)->pTimeWindow);

	delete ((CTimeBox *)pData);
	
	return TRUE;
}

gint CTimeBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	struct tm strStartTime;
	struct tm strFinalTime;
	
	memset(&strStartTime, 0, sizeof(struct tm));
	memset(&strFinalTime, 0, sizeof(struct tm));
	
	strStartTime.tm_min = atoi(gtk_entry_get_text(GTK_ENTRY(((CTimeBox *)pData)->pLeftMins)));
	strStartTime.tm_hour = atoi(gtk_entry_get_text(GTK_ENTRY(((CTimeBox *)pData)->pLeftHours)));
	gtk_calendar_get_date(GTK_CALENDAR(((CTimeBox *)pData)->pStartCalendar),
								 (guint *)&strStartTime.tm_year,
								 (guint *)&strStartTime.tm_mon,
								 (guint *)&strStartTime.tm_mday);
	strStartTime.tm_year -= 1900;
	strFinalTime.tm_min = atoi(gtk_entry_get_text(GTK_ENTRY(((CTimeBox *)pData)->pRightMins)));
	strFinalTime.tm_hour = atoi(gtk_entry_get_text(GTK_ENTRY(((CTimeBox *)pData)->pRightHours)));
	gtk_calendar_get_date(GTK_CALENDAR(((CTimeBox *)pData)->pFinalCalendar),
								 (guint *)&strFinalTime.tm_year,
								 (guint *)&strFinalTime.tm_mon,
								 (guint *)&strFinalTime.tm_mday);
	strFinalTime.tm_year -= 1900;
	
	time_t tStartTime = mktime(&strStartTime);
	time_t tFinalTime = mktime(&strFinalTime);
	
	static char szLogin[32];
	
	if (!((CTimeBox *)pData)->fgSelf)
		strncpy(szLogin, gtk_entry_get_text(GTK_ENTRY(((CTimeBox *)pData)->pTarget)), sizeof(szLogin));
	
	gtk_widget_destroy(((CTimeBox *)pData)->pTimeWindow);
	
	if (((CTimeBox *)pData)->fgSelf)
		GetHrono(((CTimeBox *)pData)->sockfd, ((CTimeBox *)pData)->pszLogin, 0, tStartTime, tFinalTime);
	else
		GetHrono(((CTimeBox *)pData)->sockfd, szLogin, 0, tStartTime, tFinalTime);
	
	delete ((CTimeBox *)pData);	
	
	return TRUE;
}