#include <string.h>

#include "message_box.hpp"
#include "set_account_box.hpp"
#include "client.hpp"
#include "util.hpp"

CSetAccountBox::CSetAccountBox(char *pszLogin, char *pszPassword, char *pszTarget, time_t tTime, int iTraffic, int iFlags)
{
	CSetAccountBox::pszLogin = pszLogin;
	CSetAccountBox::pszPassword = pszPassword;
	CSetAccountBox::pszTarget = pszTarget;
	
	CSetAccountBox::tTime = tTime;
	CSetAccountBox::iTraffic = iTraffic;
	
	pSetAccountWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	pRowBox4 = gtk_hbox_new(FALSE, FALSE);
	pRowBox5 = gtk_hbox_new(FALSE, FALSE);
	pRowBox6 = gtk_hbox_new(FALSE, FALSE);
	pRowBox7 = gtk_hbox_new(FALSE, FALSE);
	pRowBox8 = gtk_hbox_new(FALSE, FALSE);
	
	pLine1 = gtk_hseparator_new();
	
	gtk_window_set_title(GTK_WINDOW(pSetAccountWindow), "Modify Account Box");
	
	pOK = gtk_button_new_with_label("OK");
	pCancel = gtk_button_new_with_label("Cancel");
	
	gtk_widget_set_usize(pOK, 50, -1);
	gtk_widget_set_usize(pCancel, 50, -1);
	
	gtk_signal_connect(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), this);
	gtk_signal_connect(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnMessageCancel), this);
	
	gtk_container_add(GTK_CONTAINER(pSetAccountWindow), pVertBox);

	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);	  
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pLine1, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox4, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox5, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox6, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox7, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox8, FALSE, TRUE, 5);
	
	GtkWidget *pHelp = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pRowBox8), pHelp, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pOK, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pCancel, TRUE, FALSE, 5);

	pLabelLogin = gtk_label_new("Login:");
	pLabelTime = gtk_label_new("Time now:");
	pLabelTraffic = gtk_label_new("Traffic now:");
	
	pLabelNewTime = gtk_label_new("Time correction:");
	pLabelNewTraffic = gtk_label_new("Traffic correction:");
	pLabelDisconnectFlag = gtk_label_new("Disconnect flag:");
	pLabelDeleteFlag = gtk_label_new("Delete flag:");
	
	pLogin = gtk_entry_new_with_max_length(8);
	pTime = gtk_entry_new_with_max_length(16);
	pTraffic = gtk_entry_new_with_max_length(16);
	pNewTime = gtk_entry_new_with_max_length(16);
	pNewTraffic = gtk_entry_new_with_max_length(16);

	gtk_entry_set_text(GTK_ENTRY(pTime), GetTime(tTime));
	gtk_entry_set_text(GTK_ENTRY(pTraffic), GetTraffic(iTraffic));
	gtk_entry_set_text(GTK_ENTRY(pNewTime), "0");
	gtk_entry_set_text(GTK_ENTRY(pNewTraffic), "0");
	
	pDisconnectFlag = gtk_combo_new();
	pDeleteFlag = gtk_combo_new();
	
	pAddTime = gtk_toggle_button_new_with_label("Add");
	pAddTraffic = gtk_toggle_button_new_with_label("Add");
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pAddTime), TRUE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pAddTraffic), TRUE);
	
	GList *pList = NULL;
	pList = g_list_append(pList, "Yes");
	pList = g_list_append(pList, "No");
	
	gtk_combo_set_popdown_strings(GTK_COMBO(pDisconnectFlag), pList);
	gtk_combo_set_popdown_strings(GTK_COMBO(pDeleteFlag), pList);
	
	if (!(iFlags & 1))
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(pDisconnectFlag)->entry), "No");
	if (!(iFlags & 2))
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(pDeleteFlag)->entry), "No");
	
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(pDisconnectFlag)->entry), FALSE);
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(pDeleteFlag)->entry), FALSE); 
	
	gtk_widget_set_usize(pLogin, 90, -1);
	gtk_widget_set_usize(pTime, 90, -1);
	gtk_widget_set_usize(pTraffic, 90, -1);
	gtk_widget_set_usize(pNewTime, 90, -1);
	gtk_widget_set_usize(pNewTraffic, 90, -1);
	gtk_widget_set_usize(pDisconnectFlag, 60, -1);
	gtk_widget_set_usize(pDeleteFlag, 60, -1);
	
	gtk_entry_set_text(GTK_ENTRY(pLogin), pszTarget);
	
	gtk_entry_set_editable(GTK_ENTRY(pLogin), FALSE);
	gtk_entry_set_editable(GTK_ENTRY(pTime), FALSE);
	gtk_entry_set_editable(GTK_ENTRY(pTraffic), FALSE);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLabelLogin, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox1), pLogin, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox2), pLabelTime, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pTime, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox3), pLabelTraffic, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox3), pTraffic, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox4), pLabelNewTime, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox4), pNewTime, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox4), pAddTime, FALSE, FALSE, 5);	
	gtk_box_pack_start(GTK_BOX(pRowBox5), pLabelNewTraffic, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox5), pNewTraffic, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox5), pAddTraffic, FALSE, FALSE, 5);		
	gtk_box_pack_start(GTK_BOX(pRowBox6), pLabelDisconnectFlag, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox6), pDisconnectFlag, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox7), pLabelDeleteFlag, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox7), pDeleteFlag, FALSE, FALSE, 5);
	
	gtk_widget_show(pAddTime);
	gtk_widget_show(pAddTraffic);
	gtk_widget_show(pDisconnectFlag);
	gtk_widget_show(pDeleteFlag);
	gtk_widget_show(pLabelNewTime);
	gtk_widget_show(pLabelNewTraffic);
	gtk_widget_show(pLabelDisconnectFlag);
	gtk_widget_show(pLabelDeleteFlag);
	gtk_widget_show(pLogin);
	gtk_widget_show(pTime);
	gtk_widget_show(pTraffic);
	gtk_widget_show(pNewTime);
	gtk_widget_show(pNewTraffic);
	gtk_widget_show(pLabelLogin);
	gtk_widget_show(pLabelTime);
	gtk_widget_show(pLabelTraffic);
	gtk_widget_show(pHelp);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pRowBox4);
	gtk_widget_show(pRowBox5);
	gtk_widget_show(pRowBox6);
	gtk_widget_show(pRowBox7);
	gtk_widget_show(pRowBox8);
	gtk_widget_show(pLine1);
	gtk_widget_show(pOK);
	gtk_widget_show(pCancel);
	gtk_widget_show(pSetAccountWindow);
}

gint CSetAccountBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	static char szTime[32];
	static char szTraffic[32];
	
	strncpy(szTime, gtk_entry_get_text(GTK_ENTRY(((CSetAccountBox *)pData)->pNewTime)), sizeof(szTime));
	strncpy(szTraffic, gtk_entry_get_text(GTK_ENTRY(((CSetAccountBox *)pData)->pNewTraffic)), sizeof(szTraffic));
	
	time_t tTime = CalcTime(szTime);
	int iTraffic = CalcTraffic(szTraffic);
	
	if (-1 == tTime) {
		CMessageBox("Invalid time entered...", "Modify Account Box", MB_ICONSTOP);
		return FALSE;
	}
	
	if (-1 == iTraffic) {
		CMessageBox("Invalid traffic entered...", "Modify Account Box", MB_ICONSTOP);
		return FALSE;
	}
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(((CSetAccountBox *)pData)->pAddTime)))
		tTime += ((CSetAccountBox *)pData)->tTime;
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(((CSetAccountBox *)pData)->pAddTraffic)))
		iTraffic += ((CSetAccountBox *)pData)->iTraffic;
	
	int iDisconnect = 0;
	int iDelete = 0;
	
	if (0 == strcmp("Yes", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(((CSetAccountBox *)pData)->pDisconnectFlag)->entry))))
		iDisconnect = 1;
	if (0 == strcmp("Yes", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(((CSetAccountBox *)pData)->pDeleteFlag)->entry))))
		iDelete = 1;

	UserSet(((CSetAccountBox *)pData)->pszLogin,
			  ((CSetAccountBox *)pData)->pszPassword,
			  ((CSetAccountBox *)pData)->pszTarget,
			  tTime,
			  iTraffic,
			  iDisconnect,
			  iDelete);

	gtk_widget_destroy(((CSetAccountBox *)pData)->pSetAccountWindow);
	
	delete (CSetAccountBox *)pData;
	
	return TRUE;
}

gint CSetAccountBox::OnMessageCancel(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CSetAccountBox *)pData)->pSetAccountWindow);
	
	delete (CSetAccountBox *)pData;
	
	return TRUE;
}