#include <string.h>

#include "password_box.hpp"
#include "client.hpp"

CPasswordBox::CPasswordBox(char *pszOldLogin, char *pszOldPassword, bool fgSelf)
{
	pszLogin = pszOldLogin;
	pszPassword = pszOldPassword;
	
	fgSystem = !fgSelf;
	
	pPasswordWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	
	if (false == fgSelf) {
		pLabelTarget = gtk_label_new("Target:");
		pTarget = gtk_entry_new_with_max_length(8);
		
		gtk_widget_set_usize(pTarget, 90, -1);
	}
	pLabelNewPassword = gtk_label_new("New password:");
	pLabelConfirmPassword = gtk_label_new("Verify password:");
	pNewPassword = gtk_entry_new_with_max_length(8);
	pConfirmPassword = gtk_entry_new_with_max_length(8);
	pOK = gtk_button_new_with_label("OK");
	pCancel = gtk_button_new_with_label("Cancel");
	
	gtk_widget_set_usize(pNewPassword, 90, -1);
	gtk_widget_set_usize(pConfirmPassword, 90, -1);
	gtk_widget_set_usize(pOK, 50, -1);
	gtk_widget_set_usize(pCancel, 50, -1);
	
	gtk_entry_set_visibility(GTK_ENTRY(pNewPassword), FALSE);
	gtk_entry_set_visibility(GTK_ENTRY(pConfirmPassword), FALSE);

	gtk_window_set_title(GTK_WINDOW(pPasswordWindow), "Set Password Box");
	
	gtk_signal_connect(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), this);
	gtk_signal_connect(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnMessageCancel), this);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	if (false == fgSelf)	{
		pRowBox1 = gtk_hbox_new(FALSE, FALSE);
		pLine1 = gtk_hseparator_new();
	}
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	pRowBox4 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_container_add(GTK_CONTAINER(pPasswordWindow), pVertBox);
	
	if (false == fgSelf) {
		gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);	  
		gtk_box_pack_start(GTK_BOX(pVertBox), pLine1, FALSE, TRUE, 0);
	}
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox4, FALSE, TRUE, 5);
	
	if (false == fgSelf)	{
		gtk_box_pack_start(GTK_BOX(pRowBox1), pLabelTarget, FALSE, FALSE, 5);
		gtk_box_pack_end(GTK_BOX(pRowBox1), pTarget, FALSE, FALSE, 5);
	}
	gtk_box_pack_start(GTK_BOX(pRowBox2), pLabelNewPassword, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pNewPassword, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox3), pLabelConfirmPassword, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox3), pConfirmPassword, FALSE, FALSE, 5);
	
	GtkWidget *pHelp = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pRowBox4), pHelp, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pOK, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pCancel, TRUE, FALSE, 5);
	
	gtk_widget_show(pVertBox);
	if (false == fgSelf)	{
		gtk_widget_show(pLine1);
		gtk_widget_show(pRowBox1);
		gtk_widget_show(pLabelTarget);
		gtk_widget_show(pTarget);
	}
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pRowBox4);
	gtk_widget_show(pHelp);
	gtk_widget_show(pLabelNewPassword);
	gtk_widget_show(pLabelConfirmPassword);
	gtk_widget_show(pNewPassword);
	gtk_widget_show(pConfirmPassword);
	gtk_widget_show(pOK);
	gtk_widget_show(pCancel);
	gtk_widget_show(pPasswordWindow);
}

gint CPasswordBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	static char szTarget[9];
	static char szNewPassword[9];
	static char szConfirmPassword[9];
	
	if (!((CPasswordBox *)pData)->fgSystem)
		strncpy(szTarget, ((CPasswordBox *)pData)->pszLogin, sizeof(szTarget));
	else
		strncpy(szTarget, gtk_entry_get_text(GTK_ENTRY(((CPasswordBox *)pData)->pTarget)), sizeof(szTarget));
	
	strncpy(szNewPassword, gtk_entry_get_text(GTK_ENTRY(((CPasswordBox *)pData)->pNewPassword)), sizeof(szNewPassword));
	strncpy(szConfirmPassword, gtk_entry_get_text(GTK_ENTRY(((CPasswordBox *)pData)->pConfirmPassword)), sizeof(szConfirmPassword));	
	
	ChangePassword(((CPasswordBox *)pData)->pszLogin,
						((CPasswordBox *)pData)->pszPassword,
						szTarget,
						szNewPassword,
						szConfirmPassword);
	
	gtk_widget_destroy(((CPasswordBox *)pData)->pPasswordWindow);
	
	delete (CPasswordBox *)pData;
	
	return TRUE;
}

gint CPasswordBox::OnMessageCancel(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CPasswordBox *)pData)->pPasswordWindow);
	
	delete (CPasswordBox *)pData;
	
	return TRUE;
}