#include <string.h>

#include "message_box.hpp"

extern char szBaseDir[];

CMessageBox::CMessageBox(char *pszMessage, char *pszCaption, int iIcon)
{
	strcpy(szInfoIcon, szBaseDir);
	strcpy(szStopIcon, szBaseDir);
	strcat(szInfoIcon, "info.xpm");
	strcat(szStopIcon, "stop.xpm");

	if (NULL == pszMessage)
		pszMessage = "No message.";
	if (NULL == pszCaption)
		pszCaption = "Caiman - Crocodiles 0.02";
	
	GtkWidget *pMessageWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	GtkWidget *pLabel = gtk_label_new(pszMessage);
	GtkWidget *pOK = gtk_button_new_with_label("Close");
	GtkWidget *pInfoIcon;
	GdkPixmap *pPixmap;
	GdkBitmap *pMask;
	GtkStyle *pStyle;
	
	gtk_signal_connect_object(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), GTK_OBJECT(pMessageWindow));
	
	gtk_widget_set_usize(pOK, 50, -1);
	
	gtk_label_set_justify(GTK_LABEL(pLabel), GTK_JUSTIFY_LEFT);
	
	GtkWidget *pVertBox = gtk_vbox_new(FALSE, FALSE);
	GtkWidget *pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	
	gtk_container_add(GTK_CONTAINER(pMessageWindow), pVertBox);
	
	pStyle = gtk_widget_get_default_style();
	pPixmap = gdk_pixmap_create_from_xpm(pMessageWindow->window,
													 &pMask,
													 &pStyle->bg[GTK_STATE_NORMAL],
													 iIcon == 0 ? szInfoIcon : szStopIcon);
	
	if (NULL != pPixmap && NULL != pStyle) {
		pInfoIcon = gtk_pixmap_new(pPixmap, pMask);
		gtk_box_pack_start(GTK_BOX(pRowBox1), pInfoIcon, FALSE, FALSE, 5);
		gtk_widget_show(pInfoIcon);
	}
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLabel, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox2), pOK, TRUE, FALSE, 5);
	
	gtk_window_set_title(GTK_WINDOW(pMessageWindow), pszCaption);

	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pOK);
	gtk_widget_show(pLabel);
	gtk_widget_show(pMessageWindow);
}

gint CMessageBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(pWidget);
	
	return TRUE;
}