#include <unistd.h>
#include <string.h>

#include "get_target_box.hpp"
#include "client.hpp"

CGetTargetBox::CGetTargetBox(int iSock, int iType, char *pszLogin, char *pszPassword)
{
	CGetTargetBox::pszLogin = pszLogin;
	CGetTargetBox::pszPassword = pszPassword;
	
	sockfd = iSock;
	after = iType;
	
	pTargetWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	pLabel = gtk_label_new("Target:");
	pTarget = gtk_entry_new_with_max_length(8);
	pOK = gtk_button_new_with_label("OK");
	pCancel = gtk_button_new_with_label("Cancel");
	
	gtk_signal_connect(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), this);
	gtk_signal_connect(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnMessageCancel), this);
	
	gtk_widget_set_usize(pOK, 50, -1);
	gtk_widget_set_usize(pCancel, 50, -1);
	gtk_widget_set_usize(pTarget, 90, -1);
	
	GtkWidget *pVertBox = gtk_vbox_new(FALSE, FALSE);
	GtkWidget *pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox2), pRowBox3, TRUE, FALSE, 5);	
	
	gtk_container_add(GTK_CONTAINER(pTargetWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLabel, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox1), pTarget, FALSE, FALSE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRowBox3), pOK, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox3), pCancel, TRUE, FALSE, 5);	
	
	gtk_window_set_title(GTK_WINDOW(pTargetWindow), "Get Target Box");

	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pOK);
	gtk_widget_show(pCancel);
	gtk_widget_show(pLabel);
	gtk_widget_show(pTarget);
	gtk_widget_show(pTargetWindow);
}

gint CGetTargetBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	static char szLogin[32];
	
	strncpy(szLogin, gtk_entry_get_text(GTK_ENTRY(((CGetTargetBox *)pData)->pTarget)), sizeof(szLogin));
	
	gtk_widget_destroy(((CGetTargetBox *)pData)->pTargetWindow);
	
	switch (((CGetTargetBox *)pData)->after) {
		case 0:
			GetUsers(((CGetTargetBox *)pData)->sockfd, szLogin, 0);
		break;
		case 1:
			UserDelete(((CGetTargetBox *)pData)->sockfd, szLogin);
		break;
		case 2:
			UserGet(((CGetTargetBox *)pData)->sockfd,
					  szLogin,
					  ((CGetTargetBox *)pData)->pszLogin,
					  ((CGetTargetBox *)pData)->pszPassword);
		break;
	}
	
	delete (CGetTargetBox *)pData;
	
	return TRUE;
}

gint CGetTargetBox::OnMessageCancel(GtkWidget *pWidget, gpointer pData)
{
	close(((CGetTargetBox *)pData)->sockfd);
	
	gtk_widget_destroy(((CGetTargetBox *)pData)->pTargetWindow);
	
	delete (CGetTargetBox *)pData;
	
	return TRUE;
}