#include <stdio.h>
#include <string.h>

#include "current_box.hpp"
#include "util.hpp"

CCurrentBox::CCurrentBox()
{
	char *ppszRow[] = { "login",
		  					  "device",
							  "host",
							  "gateway",
							  "logged",
		  					  "update",
		  					  "time",
							  "input",
							  "output",
		  					  "traffic" };
	
	pCurrentWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	pClose = gtk_button_new_with_label("Close");
	pCurrentList = gtk_clist_new_with_titles(10, ppszRow);
	
	pScrolledWindow = gtk_scrolled_window_new(NULL, NULL);
	
	gtk_signal_connect(GTK_OBJECT(pClose), "clicked", GTK_SIGNAL_FUNC(OnMessageClose), this);
	
	gtk_widget_set_usize(pClose, 50, -1);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	
	gtk_container_add(GTK_CONTAINER(pCurrentWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pScrolledWindow, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pClose, TRUE, FALSE, 5);
	
	gtk_window_set_title(GTK_WINDOW(pCurrentWindow), "Logged Users");
	
	gtk_clist_set_shadow_type(GTK_CLIST(pCurrentList), GTK_SHADOW_IN);
	
	gtk_container_add(GTK_CONTAINER(pScrolledWindow), pCurrentList);
}

gint CCurrentBox::OnMessageClose(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CCurrentBox *)pData)->pCurrentWindow);
	
	delete (CCurrentBox *)pData;
	
	return TRUE;
}

void CCurrentBox::AddRecord(char *pszLogin,
									 char *pszDevice,
									 char *pszHost,
									 char *pszGateway,
									 time_t tStartTime,
									 time_t tFinalTime,
									 time_t tLoginTime,
									 int iInputTraffic,
									 int iOutputTraffic,
									 int iTotalTraffic)
{
	char szStartTime[128];
	char szUpdateTime[128];
	char szInputTraffic[32];
	char szOutputTraffic[32];
	char szTotalTraffic[32];
	
	struct tm *pstrStartTime = localtime(&tStartTime);
	struct tm *pstrUpdateTime = localtime(&tFinalTime);
	
	strftime(szStartTime, sizeof(szStartTime), "%T %d %b %Y", pstrStartTime);
	strftime(szUpdateTime, sizeof(szUpdateTime), "%T %d %b %Y", pstrUpdateTime);	
	snprintf(szInputTraffic, sizeof(szInputTraffic), "%d", iInputTraffic);
	snprintf(szOutputTraffic, sizeof(szOutputTraffic), "%d", iOutputTraffic);
	snprintf(szTotalTraffic, sizeof(szTotalTraffic), "%d", iTotalTraffic);
	
	char *ppszRow[] = { pszLogin,
							  pszDevice,
							  pszHost,
							  pszGateway,
							  szStartTime,
		  					  szUpdateTime,
							  GetTime(tLoginTime),
							  szInputTraffic,
							  szOutputTraffic,
		  					  szTotalTraffic };
	gtk_clist_append(GTK_CLIST(pCurrentList), ppszRow);
}

void CCurrentBox::ShowBox()
{
	for (int j = 0; j < 9; j++)	
		gtk_clist_set_column_auto_resize(GTK_CLIST(pCurrentList), j, TRUE);
	
	gtk_widget_show(pCurrentWindow);
	gtk_widget_show(pScrolledWindow);
	gtk_widget_show(pCurrentList); 
	
	gtk_widget_set_usize(pScrolledWindow, 700, 200);
	
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pClose);
}