#ifndef __CLIENT_HPP__
#define __CLIENT_HPP__

#define WELCOME						'+'
#define GO_AHEAD						'!'
#define LOGIN_FAILED					'^'
#define ACTION_ADDUSER				'a'
#define ACTION_DELETEUSER			'd'
#define ACTION_GETUSER				'g'
#define ACTION_SETUSER				's'
#define ACTION_LOGIN		 			'i'
#define ACTION_LOGOUT				'o'
#define ACTION_TRUSTEDLOGIN		'}'
#define ACTION_TRUSTEDLOGOUT		'{'
#define ACTION_DUMPUSERS			'u'
#define ACTION_DUMPCURRENT			'c'
#define ACTION_DUMPHRONO			'h'
#define ACTION_NOTHING				'n'
#define GOOD_BYE						'#'
#define INVALID_ACTION				'?'
#define OK								'+'
#define INVALID_USER					'-'
#define ERROR							'*'
#define NO_RIGHTS						'~'
#define TIMEOUT						'&'
#define NEXT_RECORD					'>'
#define ALREADY_LOGGED				'.'
#define ACTION_CHANGEPASSWORD		'c'
#define WEAK_PASSWORD				'$'

#include <time.h>

extern int ServerConnect();
extern bool ServerLogin(int, char *, char *);

extern void ServerOn(int);
extern void ServerOff(int);
extern void AccountInfo(int, char *);

extern void ChangePassword(char *, char *, char *, char *, char *);

// Administrator services
extern void GetHrono(int, char *, int, time_t, time_t);
extern void GetCurrent(int);
extern void GetUsers(int, char *, int);

extern void UserDelete(int, char *);
extern void UserAdd(int, char *, char *, char *, char *, char *, char *, time_t, int);
extern void UserGet(int, char *, char *, char *);
extern void UserSet(char *, char *, char *, time_t, int, int, int);

#endif // __CLIENT_HPP__