#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>

#include "set_account_box.hpp"
#include "message_box.hpp"
#include "account_info_box.hpp"
#include "account_history_box.hpp"
#include "current_box.hpp"
#include "users_box.hpp"
#include "tokenized_string.hpp"
#include "client.hpp"
#include "conf.hpp"
#include "sockio.hpp"
#include "logfile.hpp"
#include "trim.hpp"
#include "resolv.hpp"
#include "util.hpp"
#include "rsa.hpp"
#include "key.hpp"

extern CConfigurationFile *pConfig;

extern bool fgValidPassword;

extern char szLogin[];
extern char szPassword[];

char szBuf[256];
char szTmp[256];
char szServer[256];
char szFileName[256];

int ServerConnect()
{
	char *pszServerName = pConfig->GetString("Global", "target", "localhost");
	int iServerPort = pConfig->GetInteger("Global", "port", 1098);
	pszServerName = TrimBoth(pszServerName, " \t\x0a\x0d");
	
	strncpy(szServer, pszServerName, sizeof(szServer));

	char *pszKeyDirectory = pConfig->GetString("Security", "key_directory", "/var/spool/passwdc");

	strncpy(szFileName, pszKeyDirectory, sizeof(szFileName));
	strncat(szFileName, "/", sizeof(szFileName));
	strncat(szFileName, szServer, sizeof(szFileName));
	
	char *pszResult;
	if (false == RSALoadPublicKey(szFileName)) {
		if ((pszResult = get_key(szServer, iServerPort, pszKeyDirectory))) {
			CMessageBox(pszResult, NULL, MB_ICONSTOP);
			return -1;
		}
		if (false == RSALoadPublicKey(szFileName)) {
			CMessageBox("Error loading a public key...", NULL, MB_ICONSTOP);
			return -1;
		}
	}

	int sockfd;
	if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
		snprintf(szBuf, sizeof(szBuf), "Socket error attempting to connect with server %s.\n%s.", pszServerName, strerror(errno));
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return -1;
	}

	struct hostent *host = gethostbyname(pszServerName);
	if (NULL == host) {
		snprintf(szBuf, sizeof(szBuf), "Resolving error attempting to connect with server %s.\n", pszServerName);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		close(sockfd);
		return -1;
	}
	
	struct sockaddr_in client;

	memset(&client, 0, sizeof(client));
	client.sin_family = AF_INET;
	client.sin_addr.s_addr = *((unsigned long int *)(host->h_addr));
	client.sin_port = htons(iServerPort);
	
	if (connect(sockfd, (struct sockaddr *)&client, sizeof(client)) < 0) {
		snprintf(szBuf, sizeof(szBuf), "Connect error attempting to connect with server %s.\n%s.", pszServerName, strerror(errno));
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		close(sockfd);
		return -1;
	}
	
	return sockfd;
}

bool ServerLogin(int sockfd, char *pszLogin, char *pszPassword)
{
	fgValidPassword = false;
	
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	if (WELCOME != c) {
		snprintf(szBuf, sizeof(szBuf), "Invalid response from server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return false;
	}
	if (((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin)) ||
	    (true != write_password(sockfd, pszPassword))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return false;
	}
	read_byte(sockfd, &c);
	if (c == LOGIN_FAILED) {
		snprintf(szBuf, sizeof(szBuf), "Incorrect login or password for %s on %s.", pszLogin, szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return false;
	}
	if (c != GO_AHEAD) {
		snprintf(szBuf, sizeof(szBuf), "Invalid response from server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return false;
	}
	
	fgValidPassword = true;

	return true;
}

void ServerOn(int sockfd)
{
	char szHostName[256];
	char szHostAddress[256];
	
	gethostname(szHostName, sizeof(szHostName));
	
	struct hostent *pstrHost = gethostbyname(szHostName);
	if (NULL == pstrHost) {
		CMessageBox("Error getting hostname for this machine.", NULL, MB_ICONSTOP);
		return;
	}
	snprintf(szHostAddress,
				sizeof(szHostAddress),
				"%d.%d.%d.%d",
				pstrHost->h_addr[0],
				pstrHost->h_addr[1],
				pstrHost->h_addr[2],
				pstrHost->h_addr[3]);
	
	if (!write_byte(sockfd, ACTION_LOGIN) ||
	    ((int)strlen("-") + 1 != write_string(sockfd, "-")) ||
		 ((int)strlen(szHostAddress) + 1 != write_string(sockfd, szHostAddress)) ||
		 ((int)strlen("-") + 1 != write_string(sockfd, "-"))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			CMessageBox("User logged on.", NULL, MB_ICONINFO);
		break;
		case INVALID_USER:
			CMessageBox("There is no account for this user.", NULL, MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("User is not logged on due to error.", NULL, MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Account is expired. User is not logged on.", NULL, MB_ICONSTOP);
		break;
		case ALREADY_LOGGED:
			CMessageBox("This user is already logged on from the same host.", NULL, MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);		
	}
}

void ServerOff(int sockfd)
{
	char szHostName[256];
	char szHostAddress[256];
	
	gethostname(szHostName, sizeof(szHostName));
	
	struct hostent *pstrHost = gethostbyname(szHostName);
	if (NULL == pstrHost) {
		CMessageBox("Error getting hostname for this machine.", NULL, MB_ICONSTOP);
		return;
	}
	snprintf(szHostAddress,
				sizeof(szHostAddress),
				"%d.%d.%d.%d",
				pstrHost->h_addr[0],
				pstrHost->h_addr[1],
				pstrHost->h_addr[2],
				pstrHost->h_addr[3]);
	
	if (!write_byte(sockfd, ACTION_LOGOUT) ||
	    ((int)strlen("-") + 1 != write_string(sockfd, "-")) ||
		 ((int)strlen(szHostAddress) + 1 != write_string(sockfd, szHostAddress)) ||
		 ((int)strlen("-") + 1 != write_string(sockfd, "-"))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			CMessageBox("User logged off.", NULL, MB_ICONINFO);
		break;
		case INVALID_USER:
			CMessageBox("There is no user with your login, logged from this host.", NULL, MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("User is not logged off due to error.", NULL, MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);		
	}
}

void AccountInfo(int sockfd, char *pszLogin)
{
	if (!write_byte(sockfd, ACTION_GETUSER) ||
		 ((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			int iTime;
			int iTraffic;
			int iFlags;
			int iCurrentTime;
			int iCurrentTraffic;
			if ((false == read_integer(sockfd, &iTime)) ||
				 (false == read_integer(sockfd, &iTraffic)) ||
				 (false == read_integer(sockfd, &iFlags)) ||
				 (false == read_integer(sockfd, &iCurrentTime)) ||
				 (false == read_integer(sockfd, &iCurrentTraffic)))
				CMessageBox("Error fetching data from the alligator server.", NULL, MB_ICONSTOP);
			else
				CAccountInfoBox(pszLogin, iTime, iTraffic, iFlags, iCurrentTime, iCurrentTraffic);
		break;
		case INVALID_USER:
			CMessageBox("There is no user with such login.", NULL, MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("Error fetching data from the alligator server.", NULL, MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Access denied.", NULL, MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);		
	}
}

CAccountHistoryBox *pAccountHistoryBox;
CCurrentBox *pCurrentBox;
CUsersBox *pUsersBox;

void GetHrono(int sockfd,
				  char *pszLogin,
				  int iCurrentPage,
				  time_t tStart,
				  time_t tFinal)
{
	if (0 == iCurrentPage)
		pAccountHistoryBox = new CAccountHistoryBox(pszLogin);
	
	if (!write_byte(sockfd, ACTION_DUMPHRONO) ||
		 ((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin)) ||
		 !write_integer(sockfd, (int)tStart) ||
		 !write_integer(sockfd, (int)tFinal)) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		close(sockfd);
		return;
	}
	
	char szUser[32];
	char szDevice[48];
	char szHost[48];
	time_t tStartTime;
	time_t tFinalTime;
	time_t tLoginTime;
	int iInputTraffic;
	int iOutputTraffic;
	int iTotalTraffic;
	
	int iPages = 0;
	read_integer(sockfd, &iPages);
	if (0 == iPages) {
		CMessageBox("No records.", NULL, MB_ICONSTOP);
	} else {
		write_integer(sockfd, iCurrentPage + 1);
		read_string(sockfd, szUser, sizeof(szUser));
		while ('\0' != szUser[0]) {
			read_string(sockfd, szDevice, sizeof(szDevice));
			read_string(sockfd, szHost, sizeof(szHost));
			read_integer(sockfd, (int *)&tStartTime);
			read_integer(sockfd, (int *)&tFinalTime);
			read_integer(sockfd, (int *)&tLoginTime);
			read_integer(sockfd, &iInputTraffic);
			read_integer(sockfd, &iOutputTraffic);
			read_integer(sockfd, &iTotalTraffic); 

			pAccountHistoryBox->AddRecord(szUser, szDevice, szHost, tStartTime, tFinalTime, tLoginTime, iInputTraffic, iOutputTraffic, iTotalTraffic);
			
			write_byte(sockfd, NEXT_RECORD);
			read_string(sockfd, szUser, sizeof(szUser));			
		}
		close(sockfd);
		if (iCurrentPage != iPages - 1) {
			if (-1 != (sockfd = ServerConnect()))
				if (true == ServerLogin(sockfd, szLogin, szPassword))
					GetHrono(sockfd, pszLogin, iCurrentPage + 1, tStart, tFinal);
		} else {
			pAccountHistoryBox->ShowBox();
		}
	}
}

void GetCurrent(int sockfd)
{
	pCurrentBox = new CCurrentBox();
	
	if (!write_byte(sockfd, ACTION_DUMPCURRENT)) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		close(sockfd);
		return;
	}
	
	char szUser[32];
	char szDevice[48];
	char szHost[48];
	char szGateway[48];
	time_t tStartTime;
	time_t tFinalTime;
	int iInputTraffic;
	int iOutputTraffic;
	
	read_string(sockfd, szUser, sizeof(szUser));
	while ('\0' != szUser[0]) {
		read_string(sockfd, szDevice, sizeof(szDevice));
		read_string(sockfd, szHost, sizeof(szHost));
		read_string(sockfd, szGateway, sizeof(szGateway));
		read_integer(sockfd, (int *)&tStartTime);
		read_integer(sockfd, (int *)&tFinalTime);
		read_integer(sockfd, &iInputTraffic);
		read_integer(sockfd, &iOutputTraffic);

		pCurrentBox->AddRecord(szUser,
									  szDevice,
									  szHost,
									  szGateway,
									  tStartTime,
									  tFinalTime,
									  tFinalTime - tStartTime,
									  iInputTraffic,
									  iOutputTraffic,
									  iInputTraffic + iOutputTraffic);
			
		write_byte(sockfd, NEXT_RECORD);
		read_string(sockfd, szUser, sizeof(szUser));			
	}
	close(sockfd);
	pCurrentBox->ShowBox();
}

void GetUsers(int sockfd, char *pszLogin, int iCurrentPage)
{
	if (0 == iCurrentPage)
		pUsersBox = new CUsersBox();
	
	if (!write_byte(sockfd, ACTION_DUMPUSERS) ||
		 ((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		close(sockfd);
		return;
	}
	
	char szUser[32];
	time_t tTime;
	int iTraffic;
	int iFlags;
	
	int iPages = 0;
	read_integer(sockfd, &iPages);
	if (0 == iPages) {
		CMessageBox("No records.", NULL, MB_ICONSTOP);
	} else {
		write_integer(sockfd, iCurrentPage + 1);
		read_string(sockfd, szUser, sizeof(szUser));
		while ('\0' != szUser[0]) {
			read_integer(sockfd, (int *)&tTime);
			read_integer(sockfd, &iTraffic);
			read_integer(sockfd, &iFlags);

			pUsersBox->AddRecord(szUser, tTime, iTraffic, iFlags);
			
			write_byte(sockfd, NEXT_RECORD);
			read_string(sockfd, szUser, sizeof(szUser));			
		}
		close(sockfd);
		if (iCurrentPage != iPages - 1) {
			if (-1 != (sockfd = ServerConnect()))
				if (true == ServerLogin(sockfd, szLogin, szPassword))
					GetUsers(sockfd, pszLogin, iCurrentPage + 1);
		} else {
			pUsersBox->ShowBox();
		}
	}
}

void UserDelete(int sockfd, char *pszLogin)
{
	if (!write_byte(sockfd, ACTION_DELETEUSER) ||
		 ((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			CMessageBox("Account successfully deleted.", NULL, MB_ICONINFO);
		break;
		case INVALID_USER:
			CMessageBox("There is no account for this user.", NULL, MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("Account is not deleted due to error.", NULL, MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Access denied.", NULL, MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);		
	}
	close(sockfd);
}

void ChangePassword(char *pszLogin,
						  char *pszPassword,
						  char *pszTarget,
						  char *pszNewPassword,
						  char *pszConfirmPassword)
{
	int sockfd;
	
	struct sockaddr_in client;
	
	int iServerPort = pConfig->GetInteger("Passwdd", "port", 1099);
	
	if (0 != strcmp(pszNewPassword, pszConfirmPassword)) {
		CMessageBox("New password and verification don't match. Try again.", "Change Password", MB_ICONSTOP);
		return;
	}

	CTokenizedString cServers(pConfig->GetString("Passwdd", "hosts", "localhost"), ";,");
	
	char *pszServer;
	if ((pszServer = cServers.GetFirstString()))
		do {
			pszServer = TrimBoth(pszServer, " \t\x0a\x0d");
			
			char *pszKeyDirectory = pConfig->GetString("Security", "key_directory", "/var/spool/passwdc");

			strncpy(szFileName, pszKeyDirectory, sizeof(szFileName));
			strncat(szFileName, "/", sizeof(szFileName));
			strncat(szFileName, pszServer, sizeof(szFileName));

			char *pszResult;
			if (false == RSALoadPublicKey(szFileName)) {
				if ((pszResult = get_key(pszServer, iServerPort, pszKeyDirectory))) {
					CMessageBox(pszResult, NULL, MB_ICONSTOP);
					return;
				}
				if (false == RSALoadPublicKey(szFileName)) {
					CMessageBox("Error loading a public key...", NULL, MB_ICONSTOP);
					return;
				}
			}

			if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
				snprintf(szBuf, sizeof(szBuf), "Socket error: %s\n", strerror(errno));
				CMessageBox(szBuf, pszServer, MB_ICONSTOP);
				continue;
			}

			struct hostent *pHost = gethostbyname(pszServer);
			if (NULL == pHost) {
				snprintf(szBuf, sizeof(szBuf), "Resolving error: %s\n", pszServer);
				CMessageBox(szBuf, pszServer, MB_ICONSTOP);
				close(sockfd);
				continue;
			}
			memset(&client, 0, sizeof(client));
			client.sin_family = AF_INET;
			client.sin_addr.s_addr = *((unsigned long int *)(pHost->h_addr));
			client.sin_port = htons(iServerPort);
			if (connect(sockfd, (struct sockaddr *)&client, sizeof(client)) < 0) {
				snprintf(szBuf, sizeof(szBuf), "Connect error: %s", strerror(errno));
				CMessageBox(szBuf, pszServer, MB_ICONSTOP);
				close(sockfd);
				continue;
			}

			unsigned char c = '\0';
			read_byte(sockfd, &c);
			if (WELCOME != c) {
				CMessageBox("Invalid response from server.", pszServer, MB_ICONSTOP);
				close(sockfd);
				continue;
			} 
			if (((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin)) ||
				 (true != write_password(sockfd, pszPassword))) {
				CMessageBox("Write error.", pszServer, MB_ICONSTOP);
				close(sockfd);
				continue;
			} 
			read_byte(sockfd, &c);			
			switch (c) {
				case GO_AHEAD:
					write_byte(sockfd, ACTION_CHANGEPASSWORD);
					if (((int)strlen(pszTarget) + 1 != write_string(sockfd, pszTarget)) ||
						 (true != write_password(sockfd, pszNewPassword)))
						CMessageBox("Write error.", pszServer, MB_ICONSTOP);
					if ((false == write_integer(sockfd, 0)) ||
						 (false == write_integer(sockfd, 99999)) ||
						 (false == write_integer(sockfd, -1)) ||
						 (false == write_integer(sockfd, -1)))
						CMessageBox("Write error.", pszServer, MB_ICONSTOP);
					read_byte(sockfd, &c);
					switch (c) {
						case OK:
							write_string(sockfd, "");
						break;
						case INVALID_USER:
							CMessageBox("Invalid target specified.", pszServer, MB_ICONSTOP);
						break;
						case ERROR:
							CMessageBox("Password still unchanged. Server returned error.", pszServer, MB_ICONSTOP);
						break;
						case NO_RIGHTS:
							CMessageBox("Access denied.", pszServer, MB_ICONSTOP);
						break;
						case WEAK_PASSWORD:
							read_string(sockfd, szBuf, sizeof(szBuf));
							snprintf(szTmp, sizeof(szTmp), "Weak password: %s.", szBuf);
							CMessageBox(szTmp, pszServer, MB_ICONSTOP);
						break;
						default:
							CMessageBox("Invalid response from server.", pszServer, MB_ICONSTOP);
					}
				break;
				case LOGIN_FAILED:
					snprintf(szBuf, sizeof(szBuf), "Incorrect login or password for %s on %s.\n", pszLogin, pszServer);
					CMessageBox(szBuf, pszServer, MB_ICONSTOP);
				break;
				default:
					CMessageBox("Invalid response from server.", pszServer, MB_ICONSTOP);
			}
			close(sockfd);
		} while ((pszServer = cServers.GetNextString()));
	CMessageBox("Operation completed.", "Change Passwprd", MB_ICONINFO);
}

void UserGet(int sockfd, char *pszTarget, char *pszLogin, char *pszPassword)
{
	if (!write_byte(sockfd, ACTION_GETUSER) ||
		 ((int)strlen(pszTarget) + 1 != write_string(sockfd, pszTarget))) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, NULL, MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			time_t tTime;
			int iTraffic;
			int iFlags;
			time_t tCurrentTime;
			int iCurrentTraffic;
			if (!read_integer(sockfd, (int *)&tTime) ||
				 !read_integer(sockfd, &iTraffic) ||
				 !read_integer(sockfd, &iFlags) ||
				 !read_integer(sockfd, (int *)&tCurrentTime) ||
				 !read_integer(sockfd, &iCurrentTraffic))
				CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);
			else
		  		new CSetAccountBox(pszLogin, pszPassword, pszTarget, tTime, iTraffic, iFlags);
		break;
		case INVALID_USER:
			CMessageBox("There is no account for this user.", NULL, MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("Account is not deleted due to error.", NULL, MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Access denied.", NULL, MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", NULL, MB_ICONSTOP);
	}
	close(sockfd);
}

void UserSet(char *pszLogin,
				 char *pszPassword,
				 char *pszTarget,
				 time_t tTime,
				 int iTraffic,
				 int iDisconnect,
				 int iDelete)
{
	int sockfd = ServerConnect();
	if (-1 == sockfd)
		return;
	if (false == ServerLogin(sockfd, pszLogin, pszPassword)) {
		close(sockfd);
		CMessageBox("Invalud login.", "Modify Accont Box", MB_ICONSTOP);
		return;
	}
	if (!write_byte(sockfd, ACTION_SETUSER) ||
		 ((int)strlen(pszTarget) + 1 != write_string(sockfd, pszTarget)) ||
		 !write_integer(sockfd, (int)tTime) ||
		 !write_integer(sockfd, iTraffic) ||
		 !write_integer(sockfd, iDisconnect) ||
		 !write_integer(sockfd, iDelete)) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, "Modify Accont Box", MB_ICONSTOP);
		close(sockfd);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			snprintf(szBuf,
						sizeof(szBuf),
						"Account for user %s\n"
						"   Time: %s\n" 
						"   Traffic: %s\n",
						pszLogin,
						GetTime(tTime),
						GetTraffic(iTraffic));
			CMessageBox(szBuf, "Modify Accont Box", MB_ICONINFO);
		break;
		case INVALID_USER:
			CMessageBox("There is no account for this user.", "Modify Accont Box", MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("Account is not set due to error.", "Modify Accont Box", MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Access denied.", "Modify Accont Box", MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", "Modify Accont Box", MB_ICONSTOP);
	}
	close(sockfd);
}

void UserAdd(int sockfd,
				 char *pszLogin,
				 char *pszFullName,
				 char *pszRoomNumber,
				 char *pszWorkPhone,
				 char *pszHomePhone,
				 char *pszOther,
				 time_t tTime,
				 int iTraffic)
{
	char szGecos[256];
	strcpy(szGecos, pszFullName);
	strcat(szGecos, ",");
	strcat(szGecos, pszRoomNumber);
	strcat(szGecos, ",");
	strcat(szGecos, pszWorkPhone);
	strcat(szGecos, ",");
	strcat(szGecos, pszHomePhone);
	if ('\0' != *pszOther) {
		strcat(szGecos, ",");
		strcat(szGecos, pszOther);
	}
	if (!write_byte(sockfd, ACTION_ADDUSER) ||
		 ((int)strlen(pszLogin) + 1 != write_string(sockfd, pszLogin)) ||
		 ((int)strlen(szGecos) + 1 != write_string(sockfd, szGecos)) ||
		 !write_integer(sockfd, (int)tTime) ||
		 !write_integer(sockfd, iTraffic) ||
		 !write_integer(sockfd, 1) ||
		 !write_integer(sockfd, 0)) {
		snprintf(szBuf, sizeof(szBuf), "Write error with server %s.", szServer);
		CMessageBox(szBuf, "Add Accont Box", MB_ICONSTOP);
		return;
	}
	unsigned char c = '\0';
	read_byte(sockfd, &c);
	switch (c) {
		case OK:
			CMessageBox("Account successfully added.", "Add Accont Box", MB_ICONINFO);
		break;
		case INVALID_USER:
			CMessageBox("There already such account for this user.", "Add Accont Box", MB_ICONSTOP);
		break;
		case ERROR:
			CMessageBox("Account is not addes due to error.", "Add Accont Box", MB_ICONSTOP);
		break;
		case NO_RIGHTS:
			CMessageBox("Access denied.", "Add Accont Box", MB_ICONSTOP);
		break;
		default:
			CMessageBox("Invalid response from server.", "Modify Accont Box", MB_ICONSTOP);
	}
	close(sockfd);
}