#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>

#include "add_user_box.hpp"
#include "message_box.hpp"
#include "time_box.hpp"
#include "get_target_box.hpp"
#include "password_box.hpp"
#include "logfile.hpp"
#include "conf.hpp"
#include "client.hpp"

typedef void(*Callback)(...);
typedef void(*Function)();

// Function prototypes
void CloseApplication(GtkWidget *, GdkEvent *, gpointer);
void GetMainMenu(GtkWidget *, GtkWidget **);

bool LoginDialog(GtkWidget *, gpointer);
bool AboutDialog(GtkWidget *, gpointer);
bool KeepPassword(GtkWidget *, gpointer);

void LogIn();
void LogOut();
void UserInfo();
void UserHistory();
void UserSetPassword();

void AddUser();
void DeleteUser();
void SetPassword();
void ModifyAccount();

void DumpHrono();
void DumpCurrent();
void DumpUsers();

gint OnLoginCancel(GtkWidget *, gpointer);
gint OnLoginOK(GtkWidget *, gpointer);
gint OnAboutClose(GtkWidget *, gpointer);

char szBaseDir[256] = "/usr/local/crocodiles/images";
char szBackground[256];

char szLogin[256];
char szPassword[256];

bool fgValidPassword = false;
bool fgKeepPassword = false;

Function pfnOnSuccess;

#define CONF_FILE					"/etc/caiman.conf"
#define LOG_FILE					"alligator.log"

CConfigurationFile *pConfig = NULL;

int main(int argc, char **argv)
{
	char *pszLogFile = new char[strlen(argv[0]) + 32];
	if (NULL == pszLogFile) {
		fprintf(stderr, "Error allocating memory...\n");
		return 1;
	}
	strcpy(pszLogFile, argv[0]);
	strcat(pszLogFile, ".log");
	
	if (false == logopen(pszLogFile)) {
		delete pszLogFile;
		return 2;
	}
	delete pszLogFile;
	
	char *pszMessage;
	
	pConfig = new CConfigurationFile(CONF_FILE, &pszMessage);
	if (NULL == pConfig) {
		lprintf("Error allocating memory...\n");
		return 1;
	}
	if (NULL != pszMessage) {
		lprintf("%s\n", pszMessage);
		return 1;
	}

	if (NULL != strrchr(argv[0], '/')) {
		strcpy(szBaseDir, argv[0]);
		*strrchr(szBaseDir, '/') = '\0';
		strcat(szBaseDir, "/images/");
	}
	strcpy(szBackground, szBaseDir);
	strcat(szBackground, "caiman.xpm");

	GtkWidget *pMainVbox;
	GtkWidget *pMenuBar;
	GtkWidget *pWindow;
	GtkWidget *pBackground;
	GdkPixmap *pPixmap;
	GdkBitmap *pMask;
	GtkStyle *pStyle;

	gtk_init(&argc, &argv);
	
	pWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(pWindow), "delete_event", GTK_SIGNAL_FUNC(CloseApplication), NULL);
	gtk_widget_set_usize(GTK_WIDGET(pWindow), 300, 200);
	gtk_window_set_title(GTK_WINDOW(pWindow), "Caiman - Crocodiles 0.022");
	
	pMainVbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(pMainVbox), 1);
	gtk_container_add(GTK_CONTAINER(pWindow), pMainVbox);
	gtk_widget_show(pMainVbox);
	
	GetMainMenu(pWindow, &pMenuBar);
	
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(gtk_item_factory_from_widget(pMenuBar), "/Options/Keep password")), TRUE);
	
	gtk_box_pack_start(GTK_BOX(pMainVbox), pMenuBar, FALSE, TRUE, 0);
	gtk_widget_show(pMenuBar);
	
	gtk_widget_show(pWindow);	
	
	pStyle = gtk_widget_get_default_style();
	pPixmap = gdk_pixmap_create_from_xpm(pWindow->window,
													 &pMask,
													 &pStyle->bg[GTK_STATE_NORMAL],
													 szBackground);
	if (NULL != pPixmap && NULL != pStyle) {
		pBackground = gtk_pixmap_new(pPixmap, pMask);
		gtk_box_pack_start(GTK_BOX(pMainVbox), pBackground, TRUE, TRUE, 0);
		gtk_widget_show(pBackground);
	}
	gtk_main();
	
	return 0;
}

void CloseApplication(GtkWidget *pWidget, GdkEvent *pEvent, gpointer pData)
{
	gtk_main_quit();
}

static GtkItemFactoryEntry pMenuItems[] =
{
	{ "/_File",								NULL,				NULL,									0,								"<Branch>"		},
	{ "/File/Quit",						"<control>Q",	(Callback)CloseApplication,	0,								NULL				},
	{ "/_User",								NULL,				NULL,									0,								"<Branch>"		},
	{ "/User/Log in...",					"<control>I",	(Callback)LoginDialog,			(int)LogIn,					NULL				},
	{ "/User/Log out...",				"<control>O",	(Callback)LoginDialog,			(int)LogOut,				NULL				},
	{ "/User/Account info...",			NULL,				(Callback)LoginDialog,			(int)UserInfo,				NULL				},
	{ "/User/Account history...",		NULL,				(Callback)LoginDialog,			(int)UserHistory,			NULL				},
	{ "/User/Password...",				NULL,				(Callback)LoginDialog,			(int)UserSetPassword,	NULL				},
	{ "/_Info",								NULL,				NULL,									0,								"<Branch>"		},
	{ "/Info/Users...",					NULL,				(Callback)LoginDialog,			(int)DumpUsers,			NULL				},
	{ "/Info/Logged now...",			NULL,				(Callback)LoginDialog,			(int)DumpCurrent,			NULL				},
	{ "/Info/System log...",			NULL,				(Callback)LoginDialog,			(int)DumpHrono,			NULL				},
	{ "/_System",							NULL,				NULL,									0,								"<Branch>"		},
	{ "/System/Add user...",			"<control>N",	(Callback)LoginDialog,			(int)AddUser,				NULL				},
	{ "/System/Delete user...",		"<control>D",	(Callback)LoginDialog,			(int)DeleteUser,			NULL				},
	{ "/System/Set password...",		NULL,				(Callback)LoginDialog,			(int)SetPassword,			NULL				},
	{ "/System/",							NULL,				NULL,									0,								"<Separator>"	},
	{ "/System/Modify account...",	NULL,				(Callback)LoginDialog,			(int)ModifyAccount,		NULL				},
	{ "/_Options",							NULL,				NULL,									0,								"<Branch>"		},
	{ "/Options/Keep password",		NULL,				(Callback)KeepPassword,			0,								"<ToggleItem>" },
	{ "/_Help",								NULL,				NULL,									0,								"<LastBranch>"	},
	{ "/Help/About...",					NULL,				(Callback)AboutDialog,			0,								NULL				},
};

bool KeepPassword(GtkWidget *, gpointer)
{
	fgKeepPassword = !fgKeepPassword;
	
	return TRUE;
}

bool AboutDialog(GtkWidget *, gpointer)
{
	GtkWidget *pAboutWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	GtkWidget *pClose = gtk_button_new_with_label("Close");
	GtkWidget *pVertBox = gtk_vbox_new(FALSE, FALSE);
	GtkWidget *pLabel = gtk_label_new("Crocodiles version 0.02.\n"
												 "Caiman version 0.01.\n"
												 "This software package is SHAREWARE.\n"
												 "(c) Copyright 1999 - 2000.\n\n"
												 "Written by: Alexander Feldman <alex@varna.net>.\n"
												 "For more information see: http://www.varna.net/~alex/crocodiles\n");
	
	GtkWidget *pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox2 = gtk_hbox_new(FALSE, FALSE);

	gtk_label_set_justify(GTK_LABEL(pLabel), GTK_JUSTIFY_LEFT);
	gtk_widget_set_usize(pClose, 50, -1);	
	gtk_window_set_title(GTK_WINDOW(pAboutWindow), "About The Crocodiles");
	
	gtk_signal_connect_object(GTK_OBJECT(pClose), "clicked", GTK_SIGNAL_FUNC(OnAboutClose), GTK_OBJECT(pAboutWindow));
	
	gtk_container_add(GTK_CONTAINER(pAboutWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, FALSE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLabel, FALSE, FALSE, 5);	
	gtk_box_pack_start(GTK_BOX(pRowBox2), pClose, TRUE, FALSE, 5);
	
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pLabel);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pClose);
	gtk_widget_show(pAboutWindow);
	
	return TRUE;
}

gint OnAboutClose(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(pWidget);
	
	return TRUE;
}

void GetMainMenu(GtkWidget *pWindow, GtkWidget **ppMenuBar)
{
	GtkItemFactory *pItemFactory;
	GtkAccelGroup *pAccelGroup;
	gint iMenuItems = sizeof(pMenuItems) / sizeof(pMenuItems[0]);
	
	pAccelGroup = gtk_accel_group_new();
	pItemFactory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", pAccelGroup);
	gtk_item_factory_create_items(pItemFactory, iMenuItems, pMenuItems, NULL);
	gtk_accel_group_attach(pAccelGroup, GTK_OBJECT(pWindow));
	if (ppMenuBar)
		*ppMenuBar = gtk_item_factory_get_widget(pItemFactory, "<main>");
}

GtkWidget *pLogin;
GtkWidget *pPassword;

gint OnLoginCancel(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(pWidget);
	
	return TRUE;
}

gint OnLoginOK(GtkWidget *pWidget, gpointer pData)
{
	strncpy(szLogin, gtk_entry_get_text(GTK_ENTRY(pLogin)), sizeof(szLogin));
	strncpy(szPassword, gtk_entry_get_text(GTK_ENTRY(pPassword)), sizeof(szPassword));
	gtk_widget_destroy(pWidget);
	
	(*pfnOnSuccess)();
	
	return TRUE;
}

bool LoginDialog(GtkWidget *, gpointer pfnSuccess)
{
	pfnOnSuccess = (Function)pfnSuccess;
	if (!fgValidPassword || !fgKeepPassword) {
		GtkWidget *pLoginWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	
		GtkWidget *pLoginLabel = gtk_label_new("Login:");
		GtkWidget *pPasswordLabel = gtk_label_new("Password:");
		GtkWidget *pOK = gtk_button_new_with_label("OK");
		GtkWidget *pCancel = gtk_button_new_with_label("Cancel");
		
		pLogin = gtk_entry_new_with_max_length(8);
		pPassword = gtk_entry_new_with_max_length(8);
	
		gtk_signal_connect_object(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnLoginCancel), GTK_OBJECT(pLoginWindow));
		gtk_signal_connect_object(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnLoginOK), GTK_OBJECT(pLoginWindow));
	
		gtk_entry_set_visibility(GTK_ENTRY(pPassword), FALSE);
	
		gtk_widget_set_usize(pLogin, 90, -1);
		gtk_widget_set_usize(pPassword, 90, -1);
		gtk_widget_set_usize(pOK, 50, -1);
		gtk_widget_set_usize(pCancel, 50, -1);

		gtk_window_set_title(GTK_WINDOW(pLoginWindow), "Login Dialog");
	
		GtkWidget *pVertBox = gtk_vbox_new(FALSE, FALSE);
		GtkWidget *pRowBox1 = gtk_hbox_new(FALSE, FALSE);
		GtkWidget *pRowBox2 = gtk_hbox_new(FALSE, FALSE);
		GtkWidget *pRowBox3 = gtk_hbox_new(FALSE, FALSE);
		GtkWidget *pHelp = gtk_hbox_new(FALSE, FALSE);
	
		gtk_container_add(GTK_CONTAINER(pLoginWindow), pVertBox);
	
		gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
		gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
		gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, TRUE, 5);
	
		gtk_box_pack_start(GTK_BOX(pRowBox1), pLoginLabel, FALSE, FALSE, 5);
		gtk_box_pack_end(GTK_BOX(pRowBox1), pLogin, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pRowBox2), pPasswordLabel, FALSE, FALSE, 5);
		gtk_box_pack_end(GTK_BOX(pRowBox2), pPassword, FALSE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pHelp), pOK, TRUE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pHelp), pCancel, TRUE, FALSE, 5);
		gtk_box_pack_start(GTK_BOX(pRowBox3), pHelp, TRUE, FALSE, 5);

		gtk_widget_show(pHelp);
		gtk_widget_show(pVertBox);
		gtk_widget_show(pRowBox1);
		gtk_widget_show(pRowBox2);
		gtk_widget_show(pRowBox3);
		gtk_widget_show(pLoginLabel);
		gtk_widget_show(pPasswordLabel);
		gtk_widget_show(pLogin);
		gtk_widget_show(pPassword);
		gtk_widget_show(pOK);
		gtk_widget_show(pCancel);
		gtk_widget_show(pLoginWindow);
	} else {
		(*pfnOnSuccess)();
	}
	
	return TRUE;
}

void LogIn()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd) {
		if (ServerLogin(sockfd, szLogin, szPassword))
			ServerOn(sockfd);
		close(sockfd);
	}
}

void LogOut()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd) {
		if (ServerLogin(sockfd, szLogin, szPassword))
			ServerOff(sockfd);
		close(sockfd);
	}
}

void UserInfo()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd) {
		if (ServerLogin(sockfd, szLogin, szPassword))
			AccountInfo(sockfd, szLogin);
		close(sockfd);
	}
}

void UserHistory()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CTimeBox(sockfd, szLogin, false);
		else
	  		close(sockfd);
}

void DumpHrono()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CTimeBox(sockfd, szLogin, true);
		else
	  		close(sockfd);
}

void DumpCurrent()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			GetCurrent(sockfd);
		else
	  		close(sockfd);
}

void DumpUsers()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CGetTargetBox(sockfd, 0, szLogin, szPassword);
		else
	  		close(sockfd);
}

void DeleteUser()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CGetTargetBox(sockfd, 1, szLogin, szPassword);
		else
	  		close(sockfd);
}

void AddUser()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CAddUserBox(sockfd);
		else
	  		close(sockfd);
}

void SetPassword()
{
	new CPasswordBox(szLogin, szPassword, false);
}

void UserSetPassword()
{
	new CPasswordBox(szLogin, szPassword, true);
}

void ModifyAccount()
{
	int sockfd = ServerConnect();
	
	if (-1 != sockfd)
		if (ServerLogin(sockfd, szLogin, szPassword))
			new CGetTargetBox(sockfd, 2, szLogin, szPassword);
		else
	  		close(sockfd);
}