#include <unistd.h>
#include <string.h>
#include <time.h>

#include "message_box.hpp"
#include "add_user_box.hpp"
#include "client.hpp"
#include "util.hpp"

CAddUserBox::CAddUserBox(int iSock)
{
	sockfd = iSock;
	
	pLoginWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	
	pLabelLogin = gtk_label_new("Login:");
	pLabelFullName = gtk_label_new("Full name:");
	pLabelRoomNumber = gtk_label_new("Room number:");
	pLabelWorkPhone = gtk_label_new("Work phone:");
	pLabelHomePhone = gtk_label_new("Home phone:");
	pLabelOther = gtk_label_new("Other:");
	pLabelTraffic = gtk_label_new("Traffic:");
	pLabelTime = gtk_label_new("Time:");
	pLogin = gtk_entry_new_with_max_length(8);
	pFullName = gtk_entry_new_with_max_length(12);
	pRoomNumber = gtk_entry_new_with_max_length(8);
	pWorkPhone = gtk_entry_new_with_max_length(8);
	pHomePhone = gtk_entry_new_with_max_length(8);
	pOther = gtk_entry_new_with_max_length(16);
	pTraffic = gtk_entry_new_with_max_length(9);
	pTime = gtk_entry_new_with_max_length(9);
	pOK = gtk_button_new_with_label("OK");
	pCancel = gtk_button_new_with_label("Cancel");
	
	gtk_widget_set_usize(pLogin, 90, -1);
	gtk_widget_set_usize(pFullName, 90, -1);
	gtk_widget_set_usize(pRoomNumber, 90, -1);
	gtk_widget_set_usize(pWorkPhone, 90, -1);
	gtk_widget_set_usize(pHomePhone, 90, -1);
	gtk_widget_set_usize(pOther, 90, -1);	
	gtk_widget_set_usize(pTime, 90, -1);
	gtk_widget_set_usize(pTraffic, 90, -1);	
	gtk_widget_set_usize(pOK, 50, -1);
	gtk_widget_set_usize(pCancel, 50, -1);

	gtk_window_set_title(GTK_WINDOW(pLoginWindow), "Add User Box");
	
	gtk_signal_connect(GTK_OBJECT(pOK), "clicked", GTK_SIGNAL_FUNC(OnMessageOK), this);
	gtk_signal_connect(GTK_OBJECT(pCancel), "clicked", GTK_SIGNAL_FUNC(OnMessageCancel), this);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	pRowBox4 = gtk_hbox_new(FALSE, FALSE);
	pRowBox5 = gtk_hbox_new(FALSE, FALSE);
	pRowBox6 = gtk_hbox_new(FALSE, FALSE);
	pRowBox7 = gtk_hbox_new(FALSE, FALSE);
	pRowBox8 = gtk_hbox_new(FALSE, FALSE);
	pRowBox9 = gtk_hbox_new(FALSE, FALSE);
	
	pLine1 = gtk_hseparator_new();
	pLine2 = gtk_hseparator_new();
	pLine3 = gtk_hseparator_new();
	
	gtk_container_add(GTK_CONTAINER(pLoginWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pLine1, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox4, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox5, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox6, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pLine2, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox7, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox8, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pLine3, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox9, FALSE, FALSE, 5);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pLabelLogin, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox1), pLogin, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox2), pLabelFullName, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pFullName, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox3), pLabelRoomNumber, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox3), pRoomNumber, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox4), pLabelWorkPhone, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox4), pWorkPhone, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox5), pLabelHomePhone, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox5), pHomePhone, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox6), pLabelOther, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox6), pOther, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox7), pLabelTime, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox7), pTime, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox8), pLabelTraffic, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox8), pTraffic, FALSE, FALSE, 5);
	
	GtkWidget *pHelp = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pRowBox9), pHelp, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pOK, TRUE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pHelp), pCancel, TRUE, FALSE, 5);
	
	gtk_entry_set_text(GTK_ENTRY(pTime), "0");
	gtk_entry_set_text(GTK_ENTRY(pTraffic), "0");
	
	gtk_widget_show(pVertBox);
	gtk_widget_show(pLine1);
	gtk_widget_show(pLine2);
	gtk_widget_show(pLine3);
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pRowBox4);
	gtk_widget_show(pRowBox5);
	gtk_widget_show(pRowBox6);
	gtk_widget_show(pRowBox7);
	gtk_widget_show(pRowBox8);
	gtk_widget_show(pRowBox9);
	gtk_widget_show(pHelp);
	gtk_widget_show(pLabelLogin);
	gtk_widget_show(pLabelFullName);
	gtk_widget_show(pLabelRoomNumber);
	gtk_widget_show(pLabelWorkPhone);
	gtk_widget_show(pLabelHomePhone);
	gtk_widget_show(pLabelOther);
	gtk_widget_show(pLabelTraffic);
	gtk_widget_show(pLabelTime);
	gtk_widget_show(pLogin);
	gtk_widget_show(pFullName);
	gtk_widget_show(pRoomNumber);
	gtk_widget_show(pWorkPhone);
	gtk_widget_show(pHomePhone);
	gtk_widget_show(pOther);
	gtk_widget_show(pTraffic);
	gtk_widget_show(pTime);
	gtk_widget_show(pOK);
	gtk_widget_show(pCancel);
	gtk_widget_show(pLoginWindow);
}

gint CAddUserBox::OnMessageOK(GtkWidget *pWidget, gpointer pData)
{
	static char szLogin[32];
	static char szFullName[32];
	static char szRoomNumber[32];
	static char szWorkPhone[32];
	static char szHomePhone[32];
	static char szOther[32];
	static char szTime[32];
	static char szTraffic[32];
	
	strncpy(szLogin, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pLogin)), sizeof(szLogin));
	strncpy(szFullName, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pFullName)), sizeof(szFullName));
	strncpy(szRoomNumber, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pRoomNumber)), sizeof(szRoomNumber));
	strncpy(szWorkPhone, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pWorkPhone)), sizeof(szWorkPhone));
	strncpy(szHomePhone, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pHomePhone)), sizeof(szHomePhone));
	strncpy(szOther, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pOther)), sizeof(szOther));
	strncpy(szTime, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pTime)), sizeof(szTime));
	strncpy(szTraffic, gtk_entry_get_text(GTK_ENTRY(((CAddUserBox *)pData)->pTraffic)), sizeof(szTraffic));
	
	time_t tTime = CalcTime(szTime);
	int iTraffic = CalcTraffic(szTraffic);
	
	if (-1 == tTime) {
		CMessageBox("Invalid time entered...", "Add Account Box", MB_ICONSTOP);
		return FALSE;
	}
	
	if (-1 == iTraffic) {
		CMessageBox("Invalid traffic entered...", "Add Account Box", MB_ICONSTOP);
		return FALSE;
	}
	
	UserAdd(((CAddUserBox *)pData)->sockfd,
			  szLogin,
			  szFullName,
			  szRoomNumber,
			  szWorkPhone,
			  szHomePhone,
			  szOther,
			  tTime,
			  iTraffic);
	
	gtk_widget_destroy(((CAddUserBox *)pData)->pLoginWindow);
	
	delete (CAddUserBox *)pData;
	
	return TRUE;
}

gint CAddUserBox::OnMessageCancel(GtkWidget *pWidget, gpointer pData)
{
	close(((CAddUserBox *)pData)->sockfd);
	
	gtk_widget_destroy(((CAddUserBox *)pData)->pLoginWindow);
	
	delete (CAddUserBox *)pData;
	
	return TRUE;
}