#include <stdio.h>
#include <string.h>

#include "account_info_box.hpp"
#include "util.hpp"

CAccountInfoBox::CAccountInfoBox(char *pszLogin, time_t iTime, int iTraffic, int iFlags, time_t iCurrentTime, int iCurrentTraffic)
{
	char szTraffic[32];
	char szFlags[32];
	char szCurrentTime[32];
	char szCurrentTraffic[32];
	
	snprintf(szTraffic, sizeof(szTraffic), "%d", iTraffic);
	snprintf(szFlags, sizeof(szFlags), "%d", iFlags);
	snprintf(szCurrentTime, sizeof(szCurrentTime), GetTime(iCurrentTime));
	snprintf(szCurrentTraffic, sizeof(szCurrentTraffic), "%d", iCurrentTraffic);
	
	GtkWidget *pAccountInfoWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	GtkWidget *pClose = gtk_button_new_with_label("Close");
	GtkWidget *pAccountList = gtk_clist_new(2);
	GtkWidget *pCurrentList = gtk_clist_new(2);	
	
	gtk_signal_connect_object(GTK_OBJECT(pClose), "clicked", GTK_SIGNAL_FUNC(OnMessageClose), GTK_OBJECT(pAccountInfoWindow));
	
	gtk_widget_set_usize(pClose, 50, -1);
	
	GtkWidget *pVertBox = gtk_vbox_new(FALSE, FALSE);
	GtkWidget *pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	GtkWidget *pRowBox3 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox3, FALSE, TRUE, 5);
	
	gtk_container_add(GTK_CONTAINER(pAccountInfoWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pAccountList, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(pRowBox2), pCurrentList, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox3), pClose, TRUE, FALSE, 5);
	
	gtk_window_set_title(GTK_WINDOW(pAccountInfoWindow), "Account Info");
	
	gtk_clist_set_shadow_type(GTK_CLIST(pAccountList), GTK_SHADOW_IN);
	gtk_clist_set_shadow_type(GTK_CLIST(pCurrentList), GTK_SHADOW_IN);
	
	gtk_clist_set_column_auto_resize(GTK_CLIST(pAccountList), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(pAccountList), 1, TRUE);
	
	char *pppszTexts[6][2] =
	{
		{ "Login:",  pszLogin },
		{ "Remaining traffic:", szTraffic },
		{ "Remaining time:", GetTime(iTime) },
		{ "Flags:", szFlags },
		{ "Current traffic:", szCurrentTraffic },
		{ "Current time:", szCurrentTime },
	};

	gtk_clist_append(GTK_CLIST(pAccountList), pppszTexts[0]);
	gtk_clist_append(GTK_CLIST(pAccountList), pppszTexts[1]);
	gtk_clist_append(GTK_CLIST(pAccountList), pppszTexts[2]);
	gtk_clist_append(GTK_CLIST(pAccountList), pppszTexts[3]);
	
	gtk_clist_append(GTK_CLIST(pCurrentList), pppszTexts[4]);
	gtk_clist_append(GTK_CLIST(pCurrentList), pppszTexts[5]);
	
	gtk_clist_set_selectable(GTK_CLIST(pAccountList), 0, FALSE);
	gtk_clist_set_selectable(GTK_CLIST(pAccountList), 1, FALSE);
	gtk_clist_set_selectable(GTK_CLIST(pAccountList), 2, FALSE);
	gtk_clist_set_selectable(GTK_CLIST(pAccountList), 3, FALSE); 
	gtk_clist_set_selectable(GTK_CLIST(pCurrentList), 0, FALSE);
	gtk_clist_set_selectable(GTK_CLIST(pCurrentList), 1, FALSE);
	
	gtk_widget_show(pAccountList);
	gtk_clist_set_column_width(GTK_CLIST(pCurrentList), 0, GTK_CLIST(pAccountList)->column[0].width);
	gtk_clist_set_column_width(GTK_CLIST(pCurrentList), 1, GTK_CLIST(pAccountList)->column[1].width);
	gtk_widget_show(pCurrentList);
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pRowBox3);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pClose);
	gtk_widget_show(pAccountInfoWindow);
}

gint CAccountInfoBox::OnMessageClose(GtkWidget *pWidget, gpointer)
{
	gtk_widget_destroy(pWidget);
	
	return TRUE;
}