#include <stdio.h>
#include <string.h>

#include "account_history_box.hpp"
#include "util.hpp"

CAccountHistoryBox::CAccountHistoryBox(char *pszLogin)
{
	char *ppszRow[] = { "login",
		  					  "device",
							  "host",
							  "logged",
		  					  "time",
							  "input",
							  "output",
		  					  "traffic" };
	
	pAccountHistoryWindow = gtk_window_new(GTK_WINDOW_DIALOG);
	pClose = gtk_button_new_with_label("Close");
	pHistoryList = gtk_clist_new_with_titles(8, ppszRow);
	
	pScrolledWindow = gtk_scrolled_window_new(NULL, NULL);
	
	gtk_signal_connect(GTK_OBJECT(pClose), "clicked", GTK_SIGNAL_FUNC(OnMessageClose), this);
	
	gtk_widget_set_usize(pClose, 50, -1);
	
	pVertBox = gtk_vbox_new(FALSE, FALSE);
	pRowBox1 = gtk_hbox_new(FALSE, FALSE);
	pRowBox2 = gtk_hbox_new(FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox1, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(pVertBox), pRowBox2, FALSE, TRUE, 5);
	
	gtk_container_add(GTK_CONTAINER(pAccountHistoryWindow), pVertBox);
	
	gtk_box_pack_start(GTK_BOX(pRowBox1), pScrolledWindow, FALSE, FALSE, 5);
	gtk_box_pack_end(GTK_BOX(pRowBox2), pClose, TRUE, FALSE, 5);
	
	gtk_window_set_title(GTK_WINDOW(pAccountHistoryWindow), "Account History");
	
	gtk_clist_set_shadow_type(GTK_CLIST(pHistoryList), GTK_SHADOW_IN);
	
	gtk_container_add(GTK_CONTAINER(pScrolledWindow), pHistoryList);
}

gint CAccountHistoryBox::OnMessageClose(GtkWidget *pWidget, gpointer pData)
{
	gtk_widget_destroy(((CAccountHistoryBox *)pData)->pAccountHistoryWindow);
	
	delete (CAccountHistoryBox *)pData;
	
	return TRUE;
}

void CAccountHistoryBox::AddRecord(char *pszLogin,
											  char *pszDevice,
											  char *pszHost,
											  time_t tStartTime,
											  time_t tFinalTime,
											  time_t tLoginTime,
											  int iInputTraffic,
											  int iOutputTraffic,
											  int iTotalTraffic)
{
	char szStartTime[128];
	char szInputTraffic[32];
	char szOutputTraffic[32];
	char szTotalTraffic[32];
	
	struct tm *pstrStartTime = localtime(&tStartTime);
	
	strftime(szStartTime, sizeof(szStartTime), "%T %d %b %Y", pstrStartTime);
	
	snprintf(szInputTraffic, sizeof(szInputTraffic), "%d", iInputTraffic);
	snprintf(szOutputTraffic, sizeof(szOutputTraffic), "%d", iOutputTraffic);
	snprintf(szTotalTraffic, sizeof(szTotalTraffic), "%d", iTotalTraffic);
	
	char *ppszRow[] = { pszLogin,
							  pszDevice,
							  pszHost,
							  szStartTime,
							  GetTime(tLoginTime),
							  szInputTraffic,
							  szOutputTraffic,
		  					  szTotalTraffic };
	char *ppszAll[] = { "",
							  "",
							  "",
							  "Total:",
							  GetTime(tLoginTime),
							  szInputTraffic,
							  szOutputTraffic,
		  					  szTotalTraffic };
	if (0 == strcmp(pszLogin, "@total@"))
		gtk_clist_append(GTK_CLIST(pHistoryList), ppszAll);
	else
		gtk_clist_append(GTK_CLIST(pHistoryList), ppszRow);
}

void CAccountHistoryBox::ShowBox()
{
	for (int j = 0; j < 8; j++)
		gtk_clist_set_column_auto_resize(GTK_CLIST(pHistoryList), j, TRUE);
	
	gtk_widget_show(pAccountHistoryWindow);
	gtk_widget_show(pScrolledWindow);
	gtk_widget_show(pHistoryList); 
	
	gtk_widget_set_usize(pScrolledWindow, 500, 200);
	
	gtk_widget_show(pRowBox1);
	gtk_widget_show(pRowBox2);
	gtk_widget_show(pVertBox);
	gtk_widget_show(pClose);
}