#ifndef __USERS_HPP__
#define __USERS_HPP__

#include <time.h>
#include <gdbm.h>
#include <utmp.h>

#include "conf.hpp"

typedef struct 
{
	time_t tTime;
	int iTraffic;
	unsigned int iFlags;
} SUsersEntry;

#define DISCONNECT_FLAG		0x0001
#define DELETE_FLAG			0x0002

class CUsersDatabase
{
	public:
		CUsersDatabase(CConfigurationFile *, char **, bool fgReadOnly = false);
		~CUsersDatabase();
	
	public:
		bool AddRecord(char *pszLogin, time_t tTime, int iTraffic, int iDisconnect);
		bool DeleteRecord(char *pszLogin);
		bool UpdateRecord(char *pszLogin, time_t tTime, int iTraffic, int iDisconnect);
		bool ExistsRecord(char *pszLogin);
		bool CreditRecord(char *pszLogin, time_t tTime, int iTraffic);
		bool ExpiredCheck(char *pszLogin, time_t tTime = 0, int iTraffic = 0);
		bool ReadRecord(char *pszLogin, SUsersEntry *);
		bool GetTotals(time_t *, int *);
		int GetCount(char *);
		static int Compare(const void *, const void *);
		char *ReadRecord(SUsersEntry *, int);
	
	private:
		char szUsersDatabase[128];
		char szLastLogin[128];
		GDBM_FILE dbfUsers;
		datum *pstrItems;
		int iItems;
};

#endif // __USERS_HPP__