#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "users.hpp"
#include "logfile.hpp"

CUsersDatabase::CUsersDatabase(CConfigurationFile *pConfig, char **pszError, bool fgReadOnly)
{
	pstrItems = (datum *)NULL;	
	iItems = 0;
	
	*pszError = NULL;
	
	strncpy(szUsersDatabase, 
			  pConfig->GetString("Global", "data_dir", "/tmp"), 
			  sizeof(szUsersDatabase));
	strcat(szUsersDatabase, "/users.db");
	if (true == fgReadOnly)
		dbfUsers = gdbm_open(szUsersDatabase, 0, GDBM_READER, 0, NULL);
	else
		dbfUsers = gdbm_open(szUsersDatabase, 0, GDBM_WRCREAT, 0644, NULL);
	if (NULL == dbfUsers) {
		*pszError = "Error opening users database...";
		return;
	}
}

CUsersDatabase::~CUsersDatabase()
{
	for (int i = 0; i < iItems; i++)
		free(pstrItems[i].dptr);
	
	if (NULL != pstrItems)
		free(pstrItems);
	
	if (NULL != dbfUsers)
		gdbm_close(dbfUsers);
}

bool CUsersDatabase::AddRecord(char *pszLogin, time_t tTime, int iTraffic, int iFlags)
{
	SUsersEntry sUsers = {tTime, iTraffic, iFlags};
	
	datum strUsersKey = {pszLogin, strlen(pszLogin)};
	datum strUsersData = {(char *)&sUsers, sizeof(SUsersEntry)};
	
	if (0 != gdbm_store(dbfUsers, strUsersKey, strUsersData, GDBM_INSERT))
   	return false;

	return true;	
}

bool CUsersDatabase::DeleteRecord(char *pszLogin)
{
	datum strUsersKey;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (0 != gdbm_delete(dbfUsers, strUsersKey))
		return false;
	
	return true;
}

bool CUsersDatabase::UpdateRecord(char *pszLogin, time_t tTime, int iTraffic, int iFlags)
{
	datum strUsersKey;
	datum strUsersData;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (false == gdbm_exists(dbfUsers, strUsersKey))
		return false;
	
	strUsersData = gdbm_fetch(dbfUsers, strUsersKey);
	if (NULL == strUsersData.dptr)
		return false;
	
	((SUsersEntry *)strUsersData.dptr)->tTime = tTime;
	((SUsersEntry *)strUsersData.dptr)->iTraffic = iTraffic;
	((SUsersEntry *)strUsersData.dptr)->iFlags = iFlags;

	if (0 != gdbm_store(dbfUsers, strUsersKey, strUsersData, GDBM_REPLACE)) {
		free(strUsersData.dptr);
		return false;
	}
	
	free(strUsersData.dptr);
	
	return true;
}

bool CUsersDatabase::ExistsRecord(char *pszLogin)
{
	datum strUsersKey;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (0 == gdbm_exists(dbfUsers, strUsersKey))
		return false;
	
	return true;
}

bool CUsersDatabase::CreditRecord(char *pszLogin, time_t tTime, int iTraffic)
{
	datum strUsersKey;
	datum strUsersData;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (false == gdbm_exists(dbfUsers, strUsersKey))
		return false;
	
	strUsersData = gdbm_fetch(dbfUsers, strUsersKey);
	if (NULL == strUsersData.dptr)
		return false;
	
	((SUsersEntry *)strUsersData.dptr)->tTime -= tTime;
	((SUsersEntry *)strUsersData.dptr)->iTraffic -= iTraffic;
	
	if (0 != gdbm_store(dbfUsers, strUsersKey, strUsersData, GDBM_REPLACE)) {
		free(strUsersData.dptr);
		return false;
	}
	
	free(strUsersData.dptr);
	
	return true;
}

bool CUsersDatabase::ExpiredCheck(char *pszLogin, time_t tTime, int iTraffic)
{
	datum strUsersKey;
	datum strUsersData;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (false == gdbm_exists(dbfUsers, strUsersKey))
		return true;
	
	strUsersData = gdbm_fetch(dbfUsers, strUsersKey);
	if (NULL == strUsersData.dptr)
		return true;
	
	if (((((SUsersEntry *)strUsersData.dptr)->iFlags & DISCONNECT_FLAG) == 0) ||
		 ((((SUsersEntry *)strUsersData.dptr)->tTime > tTime) &&
		  (((SUsersEntry *)strUsersData.dptr)->iTraffic > iTraffic))) {
		free(strUsersData.dptr);
		return false;
	}
	
	free(strUsersData.dptr);
	
	return true;
}

bool CUsersDatabase::ReadRecord(char *pszLogin, SUsersEntry *pEntry)
{
	datum strUsersKey;
	datum strUsersData;
	
	strUsersKey.dptr = pszLogin;
	strUsersKey.dsize = strlen(pszLogin);
	
	if (false == gdbm_exists(dbfUsers, strUsersKey))
		return false;
	
	strUsersData = gdbm_fetch(dbfUsers, strUsersKey);
	if (NULL == strUsersData.dptr)
		return false;
	
	memcpy(pEntry, strUsersData.dptr, sizeof(SUsersEntry));
	
	free(strUsersData.dptr);
	
	return true;
}

int CUsersDatabase::GetCount(char *pszTarget)
{
	for (int i = 0; i < iItems; i++)
		free(pstrItems[i].dptr);

	iItems = 0;
	
	datum strUserKey;
	datum strNextUserKey;
	
	strUserKey = gdbm_firstkey(dbfUsers);
	while (strUserKey.dptr) {
		strNextUserKey = gdbm_nextkey(dbfUsers, strUserKey);
		if (true == wildcard_compare(pszTarget, strUserKey.dptr, strUserKey.dsize)) {
			datum *pstrNewItems = (datum *)realloc(pstrItems, sizeof(datum) * (iItems + 1));
			if (NULL != pstrNewItems) {
				pstrItems = pstrNewItems;
				pstrItems[iItems] = strUserKey;
				iItems += 1;
			}
		} else {
			free(strUserKey.dptr);
		}
		strUserKey = strNextUserKey;
	}
	
	qsort(pstrItems, iItems, sizeof(datum), &Compare);
	
	return iItems;
}

char *CUsersDatabase::ReadRecord(SUsersEntry *pEntry, int iRecord)
{
	if (iRecord >= iItems)
		return "";
	
	datum strKey = pstrItems[iRecord];	
	if (NULL == strKey.dptr)
		return "";
	
	strncpy(szLastLogin, strKey.dptr, strKey.dsize);
	szLastLogin[strKey.dsize] = '\0';
	
	datum strUserData = gdbm_fetch(dbfUsers, strKey);
	if (NULL == strUserData.dptr)
		return "";
	
	memcpy(pEntry, strUserData.dptr, sizeof(SUsersEntry));
	
	free(strUserData.dptr);
	
	return szLastLogin;
}

int CUsersDatabase::Compare(const void *pKey1, const void *pKey2)
{
	return strncmp(((datum *)pKey1)->dptr, ((datum *)pKey2)->dptr,	((datum *)pKey1)->dsize < ((datum *)pKey2)->dsize ?((datum *)pKey1)->dsize : ((datum *)pKey2)->dsize);
}

bool CUsersDatabase::GetTotals(time_t *ptTime, int *piTraffic)
{
	*ptTime = 0;
	*piTraffic = 0;
	
	SUsersEntry strEntry;
	
	for (int i = 0; i < iItems; i++) {
		if (false == ReadRecord(&strEntry, i))
			return false;
		*ptTime += strEntry.tTime;
		*piTraffic += strEntry.iTraffic;
	}
	
	return true;
}
