#include "pidfile.hpp"
#include "errors.h"

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <paths.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/types.h>

#ifndef _PATH_VARRUN
	#define _PATH_VARRUN "/var/run/"
#endif // _PATH_VARRUN

CPidFile::CPidFile(char *pszPidFile)
{
	strcpy(szPidFile, _PATH_VARRUN);
	strcat(szPidFile, pszPidFile);
	
	iErrorCode = NO_ERROR;
}

CPidFile::~CPidFile()
{
	unlink(szPidFile);
}

bool CPidFile::WritePid()
{
	int iFile = open(szPidFile, O_RDWR | O_CREAT, 0644);
	if (-1 == iFile) {
		iErrorCode = OPEN_ERROR;
		return false;
	}
	
	FILE *fpFile = fdopen(iFile, "r+");
	if (NULL == fpFile) {
		iErrorCode = OPEN_ERROR;		
		close(iFile);
		return false;
	}
	
	if (flock(iFile, LOCK_EX | LOCK_NB) == -1) {
		iErrorCode = LOCK_ERROR;		
		return false;
	}
	if (0 == fprintf(fpFile, "%d\n", getpid())) {
		iErrorCode = WRITE_ERROR;		
		fclose(fpFile);
		return false;
	}
	fflush(fpFile);
	if (-1 == flock(iFile, LOCK_UN)) {
		iErrorCode = UNLOCK_ERROR;		
		fclose(fpFile);
		return false;
	}
	fclose(fpFile);
	
	return true;
}

bool CPidFile::CheckPid()
{
	FILE *fpFile = fopen(szPidFile, "r");
	if (NULL == fpFile)
		return true;
	int iPid = 0;
	fscanf(fpFile, "%d", &iPid);
	fclose(fpFile);
	
	if (getpid() == iPid)
		return true;
	
	if (kill(iPid, 0) && (ESRCH == errno))
		return true;
	
	return false;
}
