#ifndef __HRONO_HPP__
#define __HRONO_HPP__

#include <time.h>
#include <gdbm.h>
#include <utmp.h>

#include "conf.hpp"

#define HE_HOSTSIZE		48

typedef struct 
{
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[HE_HOSTSIZE];
	time_t tStartTime;
	time_t tFinalTime;
	time_t tLoginTime;              // tFinalTime - tStartTime
	int iInputTraffic;
	int iOutputTraffic;
	int iTotalTraffic;              // iInputTraffic + iOutputTraffic
} SHronoEntry;

class CHronoDatabase
{
	public:
		CHronoDatabase(CConfigurationFile *, char **, bool fgReadOnly = false);
		~CHronoDatabase();
		
	public:
		bool AddRecord(char *, char *, char *, time_t, time_t, int, int);
	
		int GetCount(char *, time_t, time_t);
		static int Compare(const void *, const void *);
		bool GetTotals(time_t *, int *, int *);
		bool ReadRecord(SHronoEntry *, int);
	
	private:
		char szHronoDatabase[128];
		GDBM_FILE dbfHrono;
		datum *pstrItems;
		int iItems;
};

#endif // __HRONO_HPP__