#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "hrono.hpp"
#include "logfile.hpp"

CHronoDatabase::CHronoDatabase(CConfigurationFile *pConfig, char **pszError, bool fgReadOnly)
{
	iItems = 0;
	pstrItems = (datum *)NULL;

	*pszError = NULL;

	strncpy(szHronoDatabase, 
			  pConfig->GetString("Global", "data_dir", "/tmp"), 
			  sizeof(szHronoDatabase));
	strcat(szHronoDatabase, "/hrono.db");
	if (true == fgReadOnly)
		dbfHrono = gdbm_open(szHronoDatabase, 0, GDBM_READER, 0, NULL);
	else
		dbfHrono = gdbm_open(szHronoDatabase, 0, GDBM_WRCREAT, 0644, NULL);
	if (NULL == dbfHrono) {
		*pszError = "Error opening hrono database...";
		return;
	}
}

CHronoDatabase::~CHronoDatabase()
{
	for (int i = 0; i < iItems; i++)
		free(pstrItems[i].dptr);
	
	if (NULL != pstrItems)
		free(pstrItems);
	
	if (NULL != dbfHrono)
		gdbm_close(dbfHrono);
}

bool CHronoDatabase::AddRecord(char *pszLogin,
								  		 char *pszDevice,
										 char *pszHost,
								  		 time_t tStartTime,
								  		 time_t tFinalTime,
								  		 int iInputTraffic,
								  		 int iOutputTraffic)
{
	SHronoEntry sHrono;
	
	strcpy(sHrono.szLogin, pszLogin);
	strcpy(sHrono.szDevice, pszDevice);
	strcpy(sHrono.szHost, pszHost);
	sHrono.tStartTime = tStartTime;
	sHrono.tFinalTime = tFinalTime;
	sHrono.tLoginTime = tFinalTime - tStartTime;
	sHrono.iInputTraffic = iInputTraffic;
	sHrono.iOutputTraffic = iOutputTraffic;
	sHrono.iTotalTraffic = iInputTraffic + iOutputTraffic;
	
	datum strHronoKey;
	datum strHronoData;
	
	char *pszBuffer = new char[sizeof(time_t) + strlen(pszLogin) + 1];
	if (NULL == pszBuffer)
		return false;
	
	do {
		memcpy(pszBuffer, &tStartTime, sizeof(time_t));
		memcpy(pszBuffer + sizeof(time_t), pszLogin, strlen(pszLogin));
		
		strHronoKey.dptr = pszBuffer;
		strHronoKey.dsize = sizeof(time_t) + strlen(pszLogin);
		
		tStartTime += 1;
	} while (true == gdbm_exists(dbfHrono, strHronoKey));
	strHronoData.dptr = (char *)&sHrono;
	strHronoData.dsize = sizeof(SHronoEntry);
	
	if (0 != gdbm_store(dbfHrono, strHronoKey, strHronoData, GDBM_INSERT)) {
//		delete pszBuffer;
		return false;
	}
	
//	delete pszBuffer;
	
	return true;	
}

int CHronoDatabase::GetCount(char *pszTarget, time_t tStartTime, time_t tFinalTime)
{
	for (int i = 0; i < iItems; i++)
		free(pstrItems[i].dptr);
	
	iItems = 0;
	
	datum strHronoKey;
	datum strNextHronoKey;
	
	strHronoKey = gdbm_firstkey(dbfHrono);
	while (strHronoKey.dptr) {
		strNextHronoKey = gdbm_nextkey(dbfHrono, strHronoKey);
		if ((*((time_t *)strHronoKey.dptr) >= tStartTime) &&
			 (*((time_t *)strHronoKey.dptr) <= tFinalTime) &&
			 (true == wildcard_compare(pszTarget,
												strHronoKey.dptr + sizeof(time_t),
												strHronoKey.dsize - sizeof(time_t)))) {
			datum *pstrNewItems = (datum *)realloc(pstrItems, sizeof(datum) * (iItems + 1));
			if (NULL != pstrNewItems) {
				pstrItems = pstrNewItems;
				pstrItems[iItems] = strHronoKey;
				iItems += 1;
			}
		} else {
			free(strHronoKey.dptr);
		}
		strHronoKey = strNextHronoKey;
	}
	
	qsort(pstrItems, iItems, sizeof(datum), &Compare);
	
	return iItems;
}

bool CHronoDatabase::ReadRecord(SHronoEntry *pEntry, int iRecord)
{
	if (iRecord >= iItems)
		return false;
	
	datum strKey = pstrItems[iRecord];	
	if (NULL == strKey.dptr)
		return false;
	
	datum strHronoData = gdbm_fetch(dbfHrono, strKey);
	if (NULL == strHronoData.dptr)
		return false;
	
	memcpy(pEntry, strHronoData.dptr, sizeof(SHronoEntry));
	
	free(strHronoData.dptr);
	
	return true;
}

int CHronoDatabase::Compare(const void *pKey1, const void *pKey2)
{
	time_t tKey1 = *((time_t *)((datum *)pKey1)->dptr);
	time_t tKey2 = *((time_t *)((datum *)pKey2)->dptr);
	if (tKey1 == tKey2)
		return 0;
	if (tKey1 > tKey2)
		return 1;
	return -1;
}

bool CHronoDatabase::GetTotals(time_t *ptTime, int *piInputTraffic, int *piOutputTraffic)
{
	*ptTime = 0;
	*piInputTraffic = 0;
	*piOutputTraffic = 0;
	
	SHronoEntry strEntry;
	
	for (int i = 0; i < iItems; i++) {
		if (false == ReadRecord(&strEntry, i))
			return false;
		*ptTime += strEntry.tLoginTime;
		*piInputTraffic += strEntry.iInputTraffic;
		*piOutputTraffic += strEntry.iOutputTraffic;
	}
	
	return true;
}
