#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <linux/version.h>
#include <sys/types.h>
#include <sys/socket.h>

#if LINUX_VERSION_CODE >= 0x020100
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/icmp.h>
#else
#include <linux/timer.h>
#endif

#include <linux/if.h>
#include <linux/ip_fw.h>

#include "firewall.hpp"
#include "conf.hpp"
#include "resolv.hpp"
#include "logfile.hpp"

extern CConfigurationFile *pConfig;

bool InsertAccountRule(char *pszHost)
{
	DeleteAccountRule(pszHost);
	
	struct ip_fw strOutput;
	struct ip_fw strInput;
	
	memset(&strOutput, 0, sizeof(struct ip_fw));	
	memset(&strInput, 0, sizeof(struct ip_fw));

	char *pszBuf = new char[strlen(pszHost) + 1];
	if (NULL == pszBuf)
		return false;
	pszHost = strcpy(pszBuf, pszHost);

	char *pszMask = strchr(pszHost, '/');
	if (NULL == pszMask)
		pszMask = "/255.255.255.255";
  	else
		*pszMask = '\0';
	
	bool fgInvertAddress = false;	
	for (; '\0' != *pszHost && (' ' == *pszHost || '\t' == *pszHost || '!' == *pszHost); pszHost++)
		if ('!' == *pszHost)
			fgInvertAddress = true;
	
#if LINUX_VERSION_CODE < 0x020100
	inet_aton(pszHost, &strOutput.fw_dst);
	inet_aton(pszMask + 1, &strOutput.fw_dmsk);
	strOutput.fw_flg = IP_FW_F_ALL | IP_FW_F_ACCTOUT;
	strOutput.fw_nsp = 2;
	strOutput.fw_ndp = 2;
	strOutput.fw_pts[1] = 0xffff;
	strOutput.fw_pts[3] = 0xffff;
	strOutput.fw_tosand = 0xff;
	
	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);
	strInput.fw_flg = IP_FW_F_ALL | IP_FW_F_ACCTIN;
	strInput.fw_nsp = 2;
	strInput.fw_ndp = 2;
	strInput.fw_pts[1] = 0xffff;
	strInput.fw_pts[3] = 0xffff;
	strInput.fw_tosand = 0xff;

	delete pszBuf;	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_ACCT_INSERT, &strInput, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_ACCT_INSERT, &strOutput, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#else
	inet_aton(pszHost, &strOutput.fw_dst);
	inet_aton(pszMask + 1, &strOutput.fw_dmsk);
	strOutput.fw_invflg = fgInvertAddress ? IP_FW_INV_DSTIP : 0;
	strOutput.fw_spts[1] = 0xffff;
	strOutput.fw_dpts[1] = 0xffff;
	strOutput.fw_tosand = 0xff;
	
	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);	
	strInput.fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
	strInput.fw_spts[1] = 0xffff;
	strInput.fw_dpts[1] = 0xffff;
	strInput.fw_tosand = 0xff;
	
	delete pszBuf;
	
	struct ip_fwnew strOutputRule = { 1, {strOutput, ""}, IP_FW_LABEL_OUTPUT };
	struct ip_fwnew strInputRule = { 1, {strInput, ""}, IP_FW_LABEL_INPUT };	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT, &strOutputRule, sizeof(struct ip_fwnew))) ||
		 (-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT, &strInputRule, sizeof(struct ip_fwnew)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#endif
	
	return true;
}

bool DeleteAccountRule(char *pszHost)
{
	struct ip_fw strOutput;
	struct ip_fw strInput;
	
	memset(&strOutput, 0, sizeof(struct ip_fw));	
	memset(&strInput, 0, sizeof(struct ip_fw));

	char *pszBuf = new char[strlen(pszHost) + 1];
	if (NULL == pszBuf)
		return false;
	pszHost = strcpy(pszBuf, pszHost);

	char *pszMask = strchr(pszHost, '/');
	if (NULL == pszMask)
		pszMask = "/255.255.255.255";
  	else
		*pszMask = '\0';
	
	bool fgInvertAddress = false;	
	for (; '\0' != *pszHost && (' ' == *pszHost || '\t' == *pszHost || '!' == *pszHost); pszHost++)
		if ('!' == *pszHost)
			fgInvertAddress = true;
	
#if LINUX_VERSION_CODE < 0x020100
	inet_aton(pszHost, &strOutput.fw_dst);
	inet_aton(pszMask + 1, &strOutput.fw_dmsk);
	strOutput.fw_flg = IP_FW_F_ALL | IP_FW_F_ACCTOUT;
	strOutput.fw_nsp = 2;
	strOutput.fw_ndp = 2;
	strOutput.fw_pts[1] = 0xffff;
	strOutput.fw_pts[3] = 0xffff;
	strOutput.fw_tosand = 0xff;
	
	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);
	strInput.fw_flg = IP_FW_F_ALL | IP_FW_F_ACCTIN;
	strInput.fw_nsp = 2;
	strInput.fw_ndp = 2;
	strInput.fw_pts[1] = 0xffff;
	strInput.fw_pts[3] = 0xffff;
	strInput.fw_tosand = 0xff;

	delete pszBuf;	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_ACCT_DELETE, &strInput, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_ACCT_DELETE, &strOutput, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#else
	inet_aton(pszHost, &strOutput.fw_dst);
	inet_aton(pszMask + 1, &strOutput.fw_dmsk);
	strOutput.fw_invflg = fgInvertAddress ? IP_FW_INV_DSTIP : 0;
	strOutput.fw_spts[1] = 0xffff;
	strOutput.fw_dpts[1] = 0xffff;
	strOutput.fw_tosand = 0xff;
	
	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);	
	strInput.fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
	strInput.fw_spts[1] = 0xffff;
	strInput.fw_dpts[1] = 0xffff;
	strInput.fw_tosand = 0xff;
	
	delete pszBuf;
	
	struct ip_fwchange strOutputRule = { {strOutput, ""}, IP_FW_LABEL_OUTPUT };
	struct ip_fwchange strInputRule = { {strInput, ""}, IP_FW_LABEL_INPUT };	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE, &strOutputRule, sizeof(struct ip_fwchange))) ||
		 (-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE, &strInputRule, sizeof(struct ip_fwchange)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#endif

	return true;
}

int GetTraffic(char *pszHost, int iType)
{
	static char szInput[128];	
	static char szOutput[128];
	char *pszLine;
	char *pszField[32];
	unsigned long int ulHost;
	unsigned long int ulMask;
	bool fgInvert;
	
	if (false == naddr2h(pszHost, &ulHost, &ulMask, &fgInvert)) {
		lprintf("Internal error converting addr/mask...\n");
		return -1;
	}
	snprintf(szInput, sizeof(szInput), "%08lX/%08lX->%08lX/%08lX", ulHost, ulMask, 0L, 0L);
	snprintf(szOutput, sizeof(szOutput), "%08lX/%08lX->%08lX/%08lX", 0L, 0L, ulHost, ulMask);
	pszLine = new char[4096];
	if (NULL == pszLine) {
		lprintf("Error allocating memory...\n");
		return -1;
	}
#if LINUX_VERSION_CODE < 0x020100
	char szFile[] = "/proc/net/ip_acct";
#else	
	char szFile[] = "/proc/net/ip_fwchains";
#endif	
	FILE *fpFile = fopen(szFile, "r");
	if (NULL == fpFile) {
		lprintf("Error opening %s...\n", szFile);
		delete pszLine;
		return -1;
	}
#if LINUX_VERSION_CODE < 0x020100
	fgets(pszLine, 4096, fpFile);						// There is a title in the old file
#endif	
	while (NULL != fgets(pszLine, 4096, fpFile)) {
		for (int i = 0; pszLine[i] != '\0'; i++)
			if ((10 == pszLine[i]) || (13 == pszLine[i]))
				pszLine[i] = '\0';
		int j = 0;
#if LINUX_VERSION_CODE < 0x020100
		for (int i = 0; i < 20; i++) {
#else		
		for (int i = 0; i < 18; i++) {
#endif			
			while ((pszLine[j] == ' ') || (pszLine[j] == '\t'))
				j += 1;
			pszField[i] = pszLine + j;
			while ((pszLine[j] != ' ') && (pszLine[j] != '\t') && (pszLine[j] != '\0'))
				j += 1;
			pszLine[j] = '\0';
			j += 1;
		}
#if LINUX_VERSION_CODE < 0x020100
		int iFlags = strtol(pszField[3], (char **)NULL, 16);
		if ((INPUT_TRAFFIC == iType) &&
			 (0 == strcmp(szInput, pszField[0])) &&
			 (iFlags & IP_FW_F_ACCTIN)) {
#else
		int iFlags = atoi(pszField[4]);
		if ((INPUT_TRAFFIC == iType) &&
			 (0 == strcmp(IP_FW_LABEL_INPUT, pszField[0])) &&
			 (0 == strcmp(szInput, pszField[1])) &&
			 (0 == strcmp("-", pszField[17])) &&
			 (fgInvert ? (iFlags & 1) : !(iFlags & 1))) {
#endif
			fclose(fpFile);
			delete pszLine;
#if LINUX_VERSION_CODE < 0x020100
			return atoi(pszField[7]);
#else
			return atoi(pszField[9]);
#endif
		}
#if LINUX_VERSION_CODE < 0x020100
		if ((OUTPUT_TRAFFIC == iType) &&
			 (0 == strcmp(szOutput, pszField[0])) &&
			 (iFlags & IP_FW_F_ACCTOUT)) {
#else
		if ((OUTPUT_TRAFFIC == iType) &&
			 (0 == strcmp(IP_FW_LABEL_OUTPUT, pszField[0])) &&
			 (0 == strcmp(szOutput, pszField[1])) &&
			 (0 == strcmp("-", pszField[17])) &&
			 (fgInvert ? (iFlags & 2) : !(iFlags & 2))) {
#endif
			fclose(fpFile);
			delete pszLine;
#if LINUX_VERSION_CODE < 0x020100
			return atoi(pszField[7]);
#else
			return atoi(pszField[9]);
#endif
		}
	}
	fclose(fpFile);
	delete pszLine;
	return -1;
}

bool DisableHost(char *pszHost, int iAllowedPort)
{
	EnableHost(pszHost, iAllowedPort);		// We do not want to insert blocking rules two times
	
	int iAllowedPorts[3];
	
	iAllowedPorts[2] = iAllowedPort;
	iAllowedPorts[1] = pConfig->GetInteger("Global", "port", 0);
   iAllowedPorts[0] = pConfig->GetInteger("Passwdd", "port", 0);
	
	char *pszBuf = new char[strlen(pszHost) + 1];
	if (NULL == pszBuf)
	   return false;
	pszHost = strcpy(pszBuf, pszHost);

	char *pszMask = strchr(pszHost, '/');
	if (NULL == pszMask)
		pszMask = "/255.255.255.255";
  	else
		*pszMask = '\0';
	
	bool fgInvertAddress = false;	
	for (; '\0' != *pszHost && (' ' == *pszHost || '\t' == *pszHost || '!' == *pszHost); pszHost++)
		if ('!' == *pszHost)
			fgInvertAddress = true;
	
#if LINUX_VERSION_CODE < 0x020100
	struct ip_fw strAccept;
	struct ip_fw strDeny;
	
	memset(&strAccept, 0, sizeof(struct ip_fw));	
	memset(&strDeny, 0, sizeof(struct ip_fw));
	
	inet_aton(pszHost, &strAccept.fw_src);
	inet_aton(pszMask + 1, &strAccept.fw_smsk);
	strAccept.fw_flg = IP_FW_F_TCP | IP_FW_F_ACCEPT | IP_FW_F_SRNG | IP_FW_F_BIDIR;
	strAccept.fw_nsp = 2;
	strAccept.fw_ndp = 3;
	strAccept.fw_pts[1] = 0xffff;
	strAccept.fw_pts[2] = iAllowedPorts[0];
	strAccept.fw_pts[3] = iAllowedPorts[1];
	strAccept.fw_pts[4] = iAllowedPorts[2];
	strAccept.fw_tosand = 0xff;

	inet_aton(pszHost, &strDeny.fw_src);
	inet_aton(pszMask + 1, &strDeny.fw_smsk);
	strDeny.fw_flg = IP_FW_F_ALL | IP_FW_F_SRNG | IP_FW_F_DRNG;
	strDeny.fw_nsp = 2;
	strDeny.fw_ndp = 2;
	strDeny.fw_pts[1] = 0xffff;
	strDeny.fw_pts[3] = 0xffff;
	strDeny.fw_tosand = 0xff;
	
	delete pszBuf;	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT_IN, &strDeny, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT_IN, &strAccept, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#else
	struct ip_fw strAllow[6];
	struct ip_fw strInput;
	
	for (int i = 0; i < 6; i++)
		memset(&strAllow[i], 0, sizeof(struct ip_fw));	
	memset(&strInput, 0, sizeof(struct ip_fw));

	for (int i = 0; i < 3; i++) {
		inet_aton(pszHost, &strAllow[i * 2].fw_src);
		inet_aton(pszMask + 1, &strAllow[i * 2].fw_smsk);
		strAllow[i * 2].fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
		strAllow[i * 2].fw_proto = 6;
		strAllow[i * 2].fw_spts[1] = 0xffff;
		strAllow[i * 2].fw_dpts[0] = iAllowedPorts[i];
		strAllow[i * 2].fw_dpts[1] = iAllowedPorts[i];
		strAllow[i * 2].fw_tosand = 0xff;

		inet_aton(pszHost, &strAllow[i * 2 + 1].fw_dst);
		inet_aton(pszMask + 1, &strAllow[i * 2 + 1].fw_dmsk);
		strAllow[i * 2 + 1].fw_invflg = fgInvertAddress ? IP_FW_INV_DSTIP : 0;
		strAllow[i * 2 + 1].fw_proto = 6;
		strAllow[i * 2 + 1].fw_spts[0] = iAllowedPorts[i];
		strAllow[i * 2 + 1].fw_spts[1] = iAllowedPorts[i];
		strAllow[i * 2 + 1].fw_dpts[1] = 0xffff;
		strAllow[i * 2 + 1].fw_tosand = 0xff;
	}

	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);	
	strInput.fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
	strInput.fw_spts[1] = 0xffff;
	strInput.fw_dpts[1] = 0xffff;
	strInput.fw_tosand = 0xff;
	
	delete pszBuf;
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	
	struct ip_fwnew strInputRule = { 1, {strInput, ""}, IP_FW_LABEL_INPUT };
	strcpy(strInputRule.fwn_rule.label, IP_FW_LABEL_BLOCK);	
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT, &strInputRule, sizeof(struct ip_fwnew)))) {
		close(sockfd);
		return false;
	}
	for (int i = 0; i < (iAllowedPort == -1 ? 4 : 6); i++) {
		struct ip_fwnew strAllowRule = { 1, {strAllow[i], ""}, IP_FW_LABEL_INPUT };
		strcpy(strAllowRule.fwn_rule.label, IP_FW_LABEL_ACCEPT);
		
		if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_INSERT, &strAllowRule, sizeof(struct ip_fwnew)))) {
			close(sockfd);
			return false;
		}
	}
	close(sockfd);
#endif	
	
	return true;
}

bool EnableHost(char *pszHost, int iAllowedPort)
{
	int iAllowedPorts[3];
	
	iAllowedPorts[2] = iAllowedPort;
	iAllowedPorts[1] = pConfig->GetInteger("Global", "port", 0);
   iAllowedPorts[0] = pConfig->GetInteger("Passwdd", "port", 0);
	
	char *pszBuf = new char[strlen(pszHost) + 1];
	if (NULL == pszBuf)
	   return false;
	pszHost = strcpy(pszBuf, pszHost);

	char *pszMask = strchr(pszHost, '/');
	if (NULL == pszMask)
		pszMask = "/255.255.255.255";
  	else
		*pszMask = '\0';
	
	bool fgInvertAddress = false;	
	for (; '\0' != *pszHost && (' ' == *pszHost || '\t' == *pszHost || '!' == *pszHost); pszHost++)
		if ('!' == *pszHost)
			fgInvertAddress = true;

	struct ip_fw strAllow[6];
	struct ip_fw strInput;
	
	for (int i = 0; i < 6; i++)
		memset(&strAllow[i], 0, sizeof(struct ip_fw));	
	memset(&strInput, 0, sizeof(struct ip_fw));
	
#if LINUX_VERSION_CODE < 0x020100
	struct ip_fw strAccept;
	struct ip_fw strDeny;
	
	memset(&strAccept, 0, sizeof(struct ip_fw));	
	memset(&strDeny, 0, sizeof(struct ip_fw));
	
	inet_aton(pszHost, &strAccept.fw_src);
	inet_aton(pszMask + 1, &strAccept.fw_smsk);
	strAccept.fw_flg = IP_FW_F_TCP | IP_FW_F_ACCEPT | IP_FW_F_SRNG | IP_FW_F_BIDIR;
	strAccept.fw_nsp = 2;
	strAccept.fw_ndp = 3;
	strAccept.fw_pts[1] = 0xffff;
	strAccept.fw_pts[2] = iAllowedPorts[0];
	strAccept.fw_pts[3] = iAllowedPorts[1];
	strAccept.fw_pts[4] = iAllowedPorts[2];
	strAccept.fw_tosand = 0xff;

	inet_aton(pszHost, &strDeny.fw_src);
	inet_aton(pszMask + 1, &strDeny.fw_smsk);
	strDeny.fw_flg = IP_FW_F_ALL | IP_FW_F_SRNG | IP_FW_F_DRNG;
	strDeny.fw_nsp = 2;
	strDeny.fw_ndp = 2;
	strDeny.fw_pts[1] = 0xffff;
	strDeny.fw_pts[3] = 0xffff;
	strDeny.fw_tosand = 0xff;
	
	delete pszBuf;	
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE_IN, &strDeny, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE_IN, &strAccept, sizeof(struct ip_fw)))) {
		close(sockfd);
		return false;
	}
	close(sockfd);
#else	
	for (int i = 0; i < 3; i++) {
		inet_aton(pszHost, &strAllow[i * 2].fw_src);
		inet_aton(pszMask + 1, &strAllow[i * 2].fw_smsk);
		strAllow[i * 2].fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
		strAllow[i * 2].fw_proto = 6;
		strAllow[i * 2].fw_spts[1] = 0xffff;
		strAllow[i * 2].fw_dpts[0] = iAllowedPorts[i];
		strAllow[i * 2].fw_dpts[1] = iAllowedPorts[i];
		strAllow[i * 2].fw_tosand = 0xff;

		inet_aton(pszHost, &strAllow[i * 2 + 1].fw_dst);
		inet_aton(pszMask + 1, &strAllow[i * 2 + 1].fw_dmsk);
		strAllow[i * 2 + 1].fw_invflg = fgInvertAddress ? IP_FW_INV_DSTIP : 0;
		strAllow[i * 2 + 1].fw_proto = 6;
		strAllow[i * 2 + 1].fw_spts[0] = iAllowedPorts[i];
		strAllow[i * 2 + 1].fw_spts[1] = iAllowedPorts[i];
		strAllow[i * 2 + 1].fw_dpts[1] = 0xffff;
		strAllow[i * 2 + 1].fw_tosand = 0xff;
	}

	inet_aton(pszHost, &strInput.fw_src);
	inet_aton(pszMask + 1, &strInput.fw_smsk);	
	strInput.fw_invflg = fgInvertAddress ? IP_FW_INV_SRCIP : 0;
	strInput.fw_spts[1] = 0xffff;
	strInput.fw_dpts[1] = 0xffff;
	strInput.fw_tosand = 0xff;
	
	delete pszBuf;
	
	int sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (-1 == sockfd)
		return false;
	
	struct ip_fwchange strInputRule = { { strInput, "" }, IP_FW_LABEL_INPUT };
	strcpy(strInputRule.fwc_rule.label, IP_FW_LABEL_BLOCK);	
	if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE, &strInputRule, sizeof(struct ip_fwchange)))) {
		close(sockfd);
		return false;
	}
	for (int i = 0; i < (iAllowedPort == -1 ? 4 : 6); i++) {
		struct ip_fwchange strAllowRule = { { strAllow[i], "" }, IP_FW_LABEL_INPUT };
		strcpy(strAllowRule.fwc_rule.label, IP_FW_LABEL_ACCEPT);
		
		if ((-1 == setsockopt(sockfd, IPPROTO_IP, IP_FW_DELETE, &strAllowRule, sizeof(struct ip_fwchange)))) {
			close(sockfd);
			return false;
		}
	}
	close(sockfd);
#endif
	
	return true;
}
