#ifndef __CURRENT_HPP__
#define __CURRENT_HPP__

#include <time.h>
#include <gdbm.h>
#include <utmp.h>

#include "conf.hpp"

#define CE_HOSTSIZE		48

typedef struct 
{
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];
	char szHost[CE_HOSTSIZE];
	char szGateway[CE_HOSTSIZE];
	time_t tStartTime;
	time_t tFinalTime;
	int iStartInputTraffic;						// Not used - reserved - must be 0
	int iStartOutputTraffic;					// Not used - reserver - must be 0
	int iFinalInputTraffic;
	int iFinalOutputTraffic;
} SCurrentEntry;

class CCurrentDatabase
{
	public:
		CCurrentDatabase(CConfigurationFile *, char **, bool fgReadOnly = false);
		~CCurrentDatabase();
	
	public:
		bool UpdateRecord(char *, char *, char *, char *, time_t, int, int);
		bool AddRecord(char *, char *, char *, char *, time_t tTime = 0, int iInputTraffic = 0, int iInputTraffic = 0);
		bool ExistsRecord(char *);
		bool GetRecord(char *, SCurrentEntry *);
		void DeleteRecord(char *);
		void EnumCurrent(void (*)(char *, char *, char *, char *));
		bool GetFirstRecord(SCurrentEntry *);
		bool GetNextRecord(SCurrentEntry *);
		time_t GetLoginTime(char *);
		time_t GetTime(char *);
		int GetTraffic(char *);
	
	private:
		char szCurrentDatabase[128];
		GDBM_FILE dbfCurrent;
		datum strCurrentKey;
};

#endif // __CURRENT_HPP__