#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "current.hpp"

CCurrentDatabase::CCurrentDatabase(CConfigurationFile *pConfig, char **pszError, bool fgReadOnly)
{
	strCurrentKey.dptr = NULL;

	*pszError = NULL;
	
	strncpy(szCurrentDatabase, 
			  pConfig->GetString("Global", "data_dir", "/tmp"), 
			  sizeof(szCurrentDatabase));
	strcat(szCurrentDatabase, "/current.db");
	if (true == fgReadOnly)
		dbfCurrent = gdbm_open(szCurrentDatabase, 0, GDBM_READER, 0, NULL);
	else
		dbfCurrent = gdbm_open(szCurrentDatabase, 0, GDBM_WRCREAT, 0644, NULL);
	if (NULL == dbfCurrent) {
		*pszError = "Error opening current database...";
		return;
	}
}

CCurrentDatabase::~CCurrentDatabase()
{
	if (NULL != strCurrentKey.dptr)
		free(strCurrentKey.dptr);

	if (NULL != dbfCurrent)
		gdbm_close(dbfCurrent);
}

bool CCurrentDatabase::UpdateRecord(char *pszLogin,
												char *pszDevice,
												char *pszHost,
												char *pszGateway,
												time_t tTime, 
												int iInputTraffic,
												int iOutputTraffic)
{
	datum strCurrentKey;
	datum strCurrentData;
	
	strCurrentKey.dptr = pszHost;
	strCurrentKey.dsize = strlen(pszHost);
	
	if (false == gdbm_exists(dbfCurrent, strCurrentKey))
		if (false == AddRecord(pszLogin, pszDevice, pszHost, pszGateway, tTime, iInputTraffic, iOutputTraffic))
			return false;
	
	strCurrentData = gdbm_fetch(dbfCurrent, strCurrentKey);
	if (NULL == strCurrentData.dptr)
		return false;
	
	((SCurrentEntry *)strCurrentData.dptr)->tFinalTime = tTime;
	((SCurrentEntry *)strCurrentData.dptr)->iFinalInputTraffic = iInputTraffic;
	((SCurrentEntry *)strCurrentData.dptr)->iFinalOutputTraffic = iOutputTraffic;	
	
	bool fgResult = false;
	if (0 == gdbm_store(dbfCurrent, strCurrentKey, strCurrentData, GDBM_REPLACE))
		fgResult = true;
	
	free(strCurrentData.dptr);
	
	return fgResult;
}

bool CCurrentDatabase::AddRecord(char *pszLogin, 
										   char *pszDevice,
											char *pszHost,
											char *pszGateway,
										   time_t tTime,
										   int iInputTraffic,
										   int iOutputTraffic)
{
	if (0 == tTime)
		tTime = time(NULL);
	
	SCurrentEntry sCurrent;
	
	strcpy(sCurrent.szLogin, pszLogin);
	strcpy(sCurrent.szDevice, pszDevice);
	strcpy(sCurrent.szHost, pszHost);
	strcpy(sCurrent.szGateway, pszGateway);
	sCurrent.tStartTime =
	sCurrent.tFinalTime = tTime;
	sCurrent.iStartInputTraffic =
	sCurrent.iFinalInputTraffic = iInputTraffic;
	sCurrent.iStartOutputTraffic =
	sCurrent.iFinalOutputTraffic = iOutputTraffic;
	
	datum strCurrentKey = { pszHost, strlen(pszHost) };
	datum strCurrentData = { (char *)&sCurrent, sizeof(SCurrentEntry) };
	
	if (0 != gdbm_store(dbfCurrent, strCurrentKey, strCurrentData, GDBM_REPLACE))
   	return false;
	
	return true;	
}

void CCurrentDatabase::DeleteRecord(char *pszHost)
{
	datum strCurrentKey = { pszHost, strlen(pszHost) };
	gdbm_delete(dbfCurrent, strCurrentKey);
}

bool CCurrentDatabase::ExistsRecord(char *pszHost)
{
	datum strCurrentKey = { pszHost, strlen(pszHost) };
	return gdbm_exists(dbfCurrent, strCurrentKey);
}

bool CCurrentDatabase::GetRecord(char *pszHost, SCurrentEntry *pEntry)
{
	datum strCurrentKey = { pszHost, strlen(pszHost) };
	datum strCurrentData = gdbm_fetch(dbfCurrent, strCurrentKey);
	
	if (NULL == strCurrentData.dptr)
		return false;
	
	memcpy(pEntry,  strCurrentData.dptr, sizeof(SCurrentEntry));
			 
	free(strCurrentData.dptr);

	return true;
}

time_t CCurrentDatabase::GetLoginTime(char *pszHost)
{
	time_t tResult = time(NULL);
	
	datum strCurrentKey = {pszHost, strlen(pszHost)};
	datum strCurrentData = gdbm_fetch(dbfCurrent, strCurrentKey);
	
	if (NULL == strCurrentData.dptr)
		return tResult;
	
	tResult = ((SCurrentEntry *)strCurrentData.dptr)->tStartTime;
	
	free(strCurrentData.dptr);

	return tResult;
}

time_t CCurrentDatabase::GetTime(char *pszLogin)
{
	time_t tResult = 0;
	
	datum strKey;
	datum strNextKey;
	
	strKey = gdbm_firstkey(dbfCurrent);
	while (strKey.dptr) {
		strNextKey = gdbm_nextkey(dbfCurrent, strKey);

		datum strData = gdbm_fetch(dbfCurrent, strKey);
	
		if (NULL == strData.dptr) {
			free(strKey.dptr);			
			continue;
		}
	
		if (0 == strcmp(pszLogin, ((SCurrentEntry *)strData.dptr)->szLogin))
			tResult += (((SCurrentEntry *)strData.dptr)->tFinalTime -
		               ((SCurrentEntry *)strData.dptr)->tStartTime);
		
		free(strData.dptr);		
		free(strKey.dptr);
		strKey = strNextKey;
	}
	
	return tResult;
}

int CCurrentDatabase::GetTraffic(char *pszLogin)
{
	int iResult = 0;
	
	datum strKey;
	datum strNextKey;
	
	strKey = gdbm_firstkey(dbfCurrent);
	while (strKey.dptr) {
		strNextKey = gdbm_nextkey(dbfCurrent, strKey);

		datum strData = gdbm_fetch(dbfCurrent, strKey);
	
		if (NULL == strData.dptr) {
			free(strKey.dptr);			
			continue;
		}
	
		if (0 == strcmp(pszLogin, ((SCurrentEntry *)strData.dptr)->szLogin))
			iResult += (((SCurrentEntry *)strData.dptr)->iFinalInputTraffic +
		               ((SCurrentEntry *)strData.dptr)->iFinalOutputTraffic);
		
		free(strData.dptr);		
		free(strKey.dptr);
		strKey = strNextKey;
	}
	
	return iResult;
}

void CCurrentDatabase::EnumCurrent(void (*pEnumerator)(char *, char *, char *, char *))
{
	datum strKey;
	datum strNextKey;
	char szLogin[UT_NAMESIZE + 1];
	char szDevice[UT_LINESIZE + 1];	
	char szHost[CE_HOSTSIZE];
	char szGateway[CE_HOSTSIZE];
	
	strKey = gdbm_firstkey(dbfCurrent);
	while (strKey.dptr) {
		strNextKey = gdbm_nextkey(dbfCurrent, strKey);

		datum strData = gdbm_fetch(dbfCurrent, strKey);
	
		if (NULL == strData.dptr) {
			free(strKey.dptr);			
			continue;
		}
	
		strcpy(szDevice, ((SCurrentEntry *)strData.dptr)->szDevice);
		strcpy(szLogin, ((SCurrentEntry *)strData.dptr)->szLogin);
		strcpy(szHost, ((SCurrentEntry *)strData.dptr)->szHost);
		strcpy(szGateway, ((SCurrentEntry *)strData.dptr)->szGateway);
		(*pEnumerator)(szLogin, szDevice, szHost, szGateway);
		free(strData.dptr);		
		free(strKey.dptr);
		strKey = strNextKey;
	}
}

bool CCurrentDatabase::GetFirstRecord(SCurrentEntry *pEntry)
{
	if (NULL != strCurrentKey.dptr)
		free(strCurrentKey.dptr);
	
	strCurrentKey = gdbm_firstkey(dbfCurrent);
	if (NULL == strCurrentKey.dptr)
		return false;
	
	datum strCurrentData = gdbm_fetch(dbfCurrent, strCurrentKey);
	if (NULL == strCurrentData.dptr)
		return false;
	
	memcpy(pEntry,  strCurrentData.dptr, sizeof(SCurrentEntry));
			 
	free(strCurrentData.dptr);

	return true;
}

bool CCurrentDatabase::GetNextRecord(SCurrentEntry *pEntry)
{
	datum strNextCurrentKey = gdbm_nextkey(dbfCurrent, strCurrentKey);
	if (NULL == strNextCurrentKey.dptr)
		return false;
	
	datum strCurrentData = gdbm_fetch(dbfCurrent, strNextCurrentKey);
	if (NULL == strCurrentData.dptr)
		return false;
	
	memcpy(pEntry,  strCurrentData.dptr, sizeof(SCurrentEntry));
			 
	free(strCurrentData.dptr);
	free(strCurrentKey.dptr);
	
	strCurrentKey = strNextCurrentKey;

	return true;
}