/*
** Copyright (c) 1999, 2000
** Adel I. Mirzazhanov. All rights reserved
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 
**     1.Redistributions of source code must retain the above copyright notice,
**       this list of conditions and the following disclaimer. 
**     2.Redistributions in binary form must reproduce the above copyright
**       notice, this list of conditions and the following disclaimer in the
**       documentation and/or other materials provided with the distribution. 
**     3.The name of the author may not be used to endorse or promote products
**       derived from this software without specific prior written permission. 
** 		  
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR  ``AS IS'' AND ANY EXPRESS
** OR IMPLIED WARRANTIES, INCLUDING,  BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN  NO  EVENT  SHALL THE AUTHOR BE LIABLE FOR ANY
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES;  LOSS OF USE,  DATA,  OR  PROFITS;  OR BUSINESS
** INTERRUPTION)  HOWEVER  CAUSED  AND  ON  ANY  THEORY OF LIABILITY,
** WHETHER  IN  CONTRACT,   STRICT   LIABILITY,  OR  TORT  (INCLUDING
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <time.h>
#include "rnd.h"
#include "./cast/cast.h"

UINT64 __rnd_seed;

/*
** randint(int n) - Produces a Random number from 0 to n-1 .
*/
UINT
randint(int n)
{
/**********************************************************************
* ENCRYPTION KEY HEX : 0102030405060708090A0B0C0D0E0F (128-bit)       *
* YOU CAN CHANGE IT IF YOU WANT                                       *
**********************************************************************/
 BYTE key[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,  /**/
                  0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f}; /**/
/**********************************************************************
* ENCRYPTION KEY HEX : 0102030405060708090A0B0C0D0E0F (128-bit)       *
* YOU CAN CHANGE IT IF YOU WANT                                       *
**********************************************************************/
 
 return ( (UINT)( x917cast_rnd(&key[0]) % (UINT64)n ) );
}

/*
** ANSI X9.17 pseudorandom generator that uses CAST algorithm instead of DES
** m = 1
** UINT64 random_seed - 64-bit random seed
** BYTE *key          - pointer to 128-bit (16 bytes) key
*/
UINT64
x917cast_rnd (BYTE *key)
{
 UINT64 local_time;
 UINT64 I;
 UINT64 I_plus_s;
 UINT64 Xi;
 UINT64 Xi_plus_I;
 cast_key ky;
 
 local_time = (UINT64)time(NULL);
 cast_setkey(&ky, (u8*)key, 16);
 cast_encrypt (&ky, (u8*)&local_time, (u8*)&I);         /* I=Ek(D), D-time  */
 I_plus_s = I ^ __rnd_seed;                             /* I (+) s          */
 cast_encrypt (&ky, (u8*)&I_plus_s, (u8*)&Xi);          /* Xi=Ek( I (+) s ) */
 Xi_plus_I = Xi ^ I;
 cast_encrypt (&ky, (u8*)&Xi_plus_I, (u8*)&__rnd_seed); /* s=Ek( Xi (+) I ) */
 return (Xi);
}

/*
** x917cast_setseed (UINT64 seed) - Initializes seed
** UINT64 seed - seed value
*/
void
x917cast_setseed (UINT64 seed)
{
 __rnd_seed = seed;
}
