/*
** Copyright (c) 1999, 2000
** Adel I. Mirzazhanov. All rights reserved
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 
**     1.Redistributions of source code must retain the above copyright notice,
**       this list of conditions and the following disclaimer. 
**     2.Redistributions in binary form must reproduce the above copyright
**       notice, this list of conditions and the following disclaimer in the
**       documentation and/or other materials provided with the distribution. 
**     3.The name of the author may not be used to endorse or promote products
**       derived from this software without specific prior written permission. 
** 		  
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR  ``AS IS'' AND ANY EXPRESS
** OR IMPLIED WARRANTIES, INCLUDING,  BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN  NO  EVENT  SHALL THE AUTHOR BE LIABLE FOR ANY
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES;  LOSS OF USE,  DATA,  OR  PROFITS;  OR BUSINESS
** INTERRUPTION)  HOWEVER  CAUSED  AND  ON  ANY  THEORY OF LIABILITY,
** WHETHER  IN  CONTRACT,   STRICT   LIABILITY,  OR  TORT  (INCLUDING
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
** randpass.c - Random password generation module of PWGEN program
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pwd.h>
#include <unistd.h>
#include "randpass.h"

char numeric[10] =
{
'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'
};
char cleters[26] =
{
'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
'U', 'V', 'W', 'X', 'Y', 'Z'
};
char leters[26] =
{
'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
'u', 'v', 'w', 'x', 'y', 'z'
};
unsigned short int special[32] =
{
33, 34, 35, 36,  37,  38,  39,  40,
41, 42, 43, 44,  45,  46,  47,  58,
59, 60, 61, 62,  63,  64,  91,  92,
93, 94, 95, 96, 123, 124, 125, 126
};

/*
** gen_symbol - generates random symbol from specified symbol class
** 	symbol_class
**	    S_NB	1
**	    S_SS	2
**	    S_CL	4
**	    S_SL	8
*/
char
gen_symbol (unsigned short int symbol_class)
{
  switch (symbol_class)
    {
    case S_NB:
      return ( numeric[randint(10)] );
    case S_SS:
      return ( special[randint(32)] );
    case S_CL:
      return ( cleters[randint(26)] );
    case S_SL:
      return ( leters[randint(26)] );
    default:
      return (-1);
    }
  return ((char)255);
}

/*
** gen_password - generates random password of specified type
*/
int
gen_rand_pass (char *password_string, int minl, int maxl, unsigned int pass_mode)
{
  int i = 0;
  int j = 0;
  int length = 0;
  char *str_pointer;
  int random_weight[4] = { 0, 0, 0, 0 };
  int max_weight = 0;
  int max_weight_element_number = 0;

  if (minl > 256 || maxl > 256 || minl < 1 || maxl < 1 || minl > maxl)
      return (-1);
  length = minl + randint(maxl-minl+1);
  str_pointer = password_string;

  for (i = 0; i < length; i++)
    {

/* Asign random weight in weight array if mode is present*/

      if ((pass_mode & S_NB) > 0)
	random_weight[0] = 1 + randint(10000);
      if ((pass_mode & S_SS) > 0)
	random_weight[1] = 1 + randint(10000);
      if ((pass_mode & S_CL) > 0)
	random_weight[2] = 1 + randint(10000);
      if ((pass_mode & S_SL) > 0)
	random_weight[3] = 1 + randint(10000);

/* Find an element with maximum weight */

      for (j = 0; j <= 3; j++)
	if (random_weight[j] > max_weight)
	  {
	    max_weight = random_weight[j];
	    max_weight_element_number = j;
	  }
/* Generate password symbol for mode with maximum weight */
      switch (max_weight_element_number)
	{
	case 0:
	  *str_pointer = gen_symbol (S_NB);
	  str_pointer++;
	  break;
	case 1:
	  *str_pointer = gen_symbol (S_SS);
	  str_pointer++;
	  break;
	case 2:
	  *str_pointer = gen_symbol (S_CL);
	  str_pointer++;
	  break;
	case 3:
	  *str_pointer = gen_symbol (S_SL);
	  str_pointer++;
	  break;
	}
      max_weight = 0;
      max_weight_element_number = 0;
      for (j = 0; j <= 3; j++) random_weight[j] = 0;
    }
  *str_pointer = 0;
  return (length);
}
