/*
** This is from the NIST implementation of  FIPS-181, so I CAN NOT
** copyright it.
** It is modified to compile itself
*/

#ifndef PRONPASS_H
#define PRONPASS_H	1

#ifndef OWN_TYPES_H
#include "owntypes.h"
#endif /* OWN_TYPES_H */

#ifndef RND_H
#include "rnd.h"
#endif /* RND_H */

#define TRUE                  1
#define FALSE                 0

#define RULE_SIZE             (sizeof(rules)/sizeof(struct unit))
#define ALLOWED(flag)         (digram[units_in_syllable[current_unit -1]][unit] & (flag))

#define MAX_UNACCEPTABLE      20
#define MAX_RETRIES           (4 * (int) pwlen + RULE_SIZE)

#define NOT_BEGIN_SYLLABLE    010
#define NO_FINAL_SPLIT        04
#define VOWEL                 02
#define ALTERNATE_VOWEL       01
#define NO_SPECIAL_RULE       0

#define BEGIN                 0200
#define NOT_BEGIN             0100
#define BREAK                 040
#define PREFIX                020
#define ILLEGAL_PAIR          010
#define SUFFIX                04
#define END                   02
#define NOT_END               01
#define ANY_COMBINATION       0

extern int gen_pron_pass (char *word, char *hyphenated_word, USHORT minlen,
               USHORT maxlen);

USHORT  random_unit (USHORT type);
USHORT  get_random (USHORT minlen, USHORT maxlen);
boolean have_initial_y (USHORT *units, USHORT unit_size);
boolean illegal_placement (USHORT *units, USHORT pwlen);
boolean improper_word (USHORT *units, USHORT word_size);
boolean have_final_split (USHORT *units, USHORT unit_size);
int gen_word (char *word, char *hyphenated_word, USHORT pwlen);
char   	*gen_syllable(char *syllable, USHORT pwlen, USHORT *units_in_syllable,
                      USHORT *syllable_length);
#endif /* PRONPASS_H */
