#!/usr/bin/perl
###############################################################################
#    Copyright (C) 2002-2204 by Eric Gerbier
#    Bug reports to: gerbier@users.sourceforge.net
#    $Id: test_os.sh 872 2006-08-17 09:32:26Z gerbier $
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
###############################################################################
# this script is to be called at end of install
# it is in perl to allow it to work on windows

use strict;
use warnings;

use Getopt::Long;      # option analysis
use File::Basename;    # dirname

use vars qw( $Verbose );
my $Version = '0.1-0';

#############################################################
# just display program version
sub version($) {
	my $version = shift(@_);
	print "\n";
	print
"afick_postinstall : another file integrity checker configurator\nversion $version\n";
	return;
}
#############################################################
# usage
# print some help
sub usage($) {
	my $version = shift(@_);
	print <<"EOHELP";

Usage: $0 [options]

afick_postinstall options (control afickonfig)  : 
 -c|--config_file file        configname of config file to use
 -h|--help                    show this help page
 -V|--version                 show afickonfig version
 -v|--verbose		     for debugging


Disclaimer:
This script is intended to provide a means for
detecting changes made to files, via a regular
comparison of MD5 hashes to an established baseline. 

Copyright (c) 2006 Eric Gerbier <gerbier\@users.sourceforge.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
EOHELP
	return;
}
#############################################################

# afick library
# it is used on post-install, so all should be ok
my $dirname = dirname($0);
require $dirname . '/afick-common.pl';

$| = 1;

# arg line
my $help;
my $configfile;
my $version;
Getopt::Long::Configure('no_ignore_case');
unless (
	GetOptions(
		'config_file|c=s' => \$configfile,
		'help|h'          => \$help,
		'verbose|v'       => \$Verbose
	)
  )
{
	usage($Version);
	die "abort : incorrect option\n";

}
if ($help) {

	# -h : help
	usage($Version);
	exit;
}
elsif ($version) {

	# -V : version
	version($Version);
	exit;
}

if ( !$configfile ) {
	$configfile = get_default_config();
}

# first : create empty history file if a new install (not an upgrade)
# to avoid clean_config to remove directive

# get history file name from configuration file
my %macros;
my %alias = get_default_alias();
my %directive;
my %rules;
my %onlydir;

get_configuration( $configfile, \%macros, \%alias, \%directive, \%rules,
	\%onlydir );
my $history = $directive{'history'};

# create it if necessary
if ($history) {
	touch($history);
}

# second : append local config file to config file if it exists
# to avoid duplicate copying, we read first until the mark then write
# (just append at end may append many times the same lines)
my $mark         = 'put your local config below';
my $local_config = $configfile . '.local';
if ( -s $local_config ) {

	# read current config to mark and store
	my $fh_config;
	open( $fh_config, '<', $configfile );
	my @config;
	while (<$fh_config>) {

		# todo
		#search for environment variable : ${} and replace it
		#if (m/(.*)\${\w+}(.*)/) {
		#	$_ =  $1 . $ENV{$2} . $3;
		#}
		push @config, $_;
		last if (m/$mark/);
	}
	close($fh_config);

	# rewrite it
	open( $fh_config, '>', $configfile );
	foreach my $line (@config) {
		print $fh_config $line;
	}

	# add local config
	my $fh_local;
	open( $fh_local, '<', $local_config );
	while (<$fh_local>) {
		print $fh_config $_;
		debug("copy line $_");
	}
	close($fh_local);
	close($fh_config);

	# remove local config
	unlink($local_config);
}

# third : clean configuration
system("afickonfig.pl -c $configfile --clean_config");
system("afickonfig.pl -c $configfile --addpath --addlib");
