#!/usr/bin/perl -w
###############################################################################
#    Copyright (C) 2004 by Eric Gerbier
#    Bug reports to: gerbier@users.sourceforge.net
#    $Id: Makefile.pl 876 2006-08-17 09:47:53Z gerbier $
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#################################################################################
# a perl script to check for module requirements, needed by afick on tar.gz intall
# to build the makefile
#################################################################################

use strict;
use warnings;
use diagnostics;

#################################################################################
# search in a perl file for module use (with 'use' keyword)
sub check_module($) {
	my $fic = shift(@_);

	my $fh;    # file handle
	open( $fh, '<', $fic ) or warn "impossible to open $fic : $!\n";

	my $nb_ko = 0;    # number of failed modules
	while (<$fh>) {

		# search for 'use' keyword
		# I suppose 'require' keywords are used with eval
		if ( $_ =~ m/^use\s+([^\s;(]*)/ ) {

			# get the name without any import list
			my $module = $1;

			#change tree structure to directories
			$module =~ s/::/\//;

			# now test
			eval { require $module . '.pm' };
			if ($@) {

				# we do not test the error message
				print "WARNING : module $module not found : $@\n";
				$nb_ko++;
			}
		}
	}
	close($fh);

	if ( $nb_ko == 0 ) {
		print "FINE : all module founds to install $fic\n";
		return 1;
	}
	else {
		warn
"WARNING : can not install $fic : some necessary modules are missing\n";
		return 0;
	}
}
#################################################################################
# change perl path (shebang) for all perl scripts (*.pl)
sub change_header($$) {
	my $old = shift(@_);    # old perl path
	my $new = shift(@_);    # new perl path

	# get all perl script
	my @list = glob("*.pl");
	foreach my $fic (@list) {
		print "$fic\n";
		rename $fic, $fic . '.sav';
		my $fh_old;
		open( $fh_old, '<', $fic . '.sav' );
		my $fh_new;
		open( $fh_new, '>', $fic );

		my $nbline = 0;     # test for first line
		while (<$fh_old>) {
			if ( $nbline == 0 ) {

				# we change only the first script line
				print $fh_new '#!' . $new . " -w\n";
			}
			else {
				print $fh_new $_;
			}
			$nbline++;
		}

		close($fh_old);
		close($fh_new);
	}
	chmod oct(755), @list;
	return;
}
#################################################################################
#			main
#################################################################################

# search and configure perl path
################################
# use which : a very common unix command (but not installed everywhere)
# perhaps it will be better to use the "type --path" builtin command for posix-shells
#my $cmd      = "type --path perl";
my $cmd      = "which perl";
my @out      = `$cmd`;
my $perlpath = $out[0];
chomp($perlpath);

# only change perl path if not (linux) standard
if ( $perlpath ne '/usr/bin/perl' ) {
	change_header( '/usr/bin/perl', $perlpath );
}

# check for needed modules
# we only check the main programs : afick and afick-tk
# todo ? : check all others perl scripts ?
# ################################
if ( check_module('afick.pl') ) {

	# ok : "prepare" makefile for install
	rename( 'Makefile.in', 'makefile' );
	if ( check_module('afick-tk.pl') ) {

		# all is ok
		print "now you can run 'make all' to install console and gui\n";
	}
	else {

		# gui can be installed
		print "now you can run 'make install' to install console tool\n";
	}
}
else {

	# no install possible
	warn "you can not install any afick component\n";
}
