#!/bin/sh
#set -x
GIMPVER=`gimptool --version`

if [ x$GIMPVER != x ]
then
   GIMPVER=`echo $GIMPVER| sed 's/^\(...\).*/\1/'`
   if [ "`uname -s`" = SunOS ]
   then
      # look for .../lib/gimp/$GIMPVER/
      for d in /usr /usr/local /usr/openwin 
      do
         if [ -d $d/lib/gimp/$GIMPVER ]
         then
            PlugIn=$d/lib/gimp/$GIMPVER/plug-ins
            break;
         fi
      done
      # look for .../gimp/gimprc
      for d in  /usr /usr/share /usr/local /usr/local/share /usr/openwin /usr/openwin/share
      do
         if [ -f $d/gimp/gimprc ]
         then
             RcDir=$d/gimp
            break;
         fi
      done
   else
      PlugIn=`gimptool -n --install-admin-bin xwprint2 | cut -f4 -d' '`
      RcDir=`gimptool -n --install-admin-script xwprint2rc | cut -f6 -d' '|sed 's:scripts.*::'`
   fi

   if [ x$PlugIn = x ]
   then
      echo plug-ins directory not found
      exit
   fi
   if [ x$RcDir = x ]
   then
      echo directory for rc files not found
      exit
   fi

   if [ "$1" = uninstall ]
   then
      rm $PlugIn >/dev/null 2>&1
      rm $RcDir/xwprint2rc >/dev/null 2>&1
      exit 0
   else
      cp xwprint2 $PlugIn
      cp xwprint2rc $RcDir
   fi
#else
#   echo Please install gimp first
#   echo Bitte gimp zuvor installieren
#   echo Installez gimp avant linstallation de xwprint2
#   exit 1
fi                     
