/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "wysiwyg.h"

#include "base.h"
#include "default.h"
#include "fileio.h"
#include "gfx.h"
#include "limits.h"
#include "pbcache.h"
#include "resource.h"
#include "x11.h"

static int        realWYSIWYG=0; /* 0 - no wysiwyg
                                    1 - wysiwyg     */
/* activate WYSIWYG Mode */
void xwSetRealMode(void)
{
   realWYSIWYG=1;
   return;
}

/* deactivate WYSIWYG Mode */
void xwUnSetRealMode(void)
{
   realWYSIWYG=0;
   return;
}

/* as WYSIWYG */
int xwAskRealMode(void)
{
   return(realWYSIWYG);
}

/* get cached picture */
char *xwGetRealPicture(char *source)
{
   static char    dest[1024]; /* Destination File */
   static char    IDNr[1024]; /* INode Number */
   struct stat    attribute;  /* File Attribute */

   int            xres,yres;  /* File Resolution */
   float          aspect;     /* File Aspect Ratio */
   int            xdres,ydres;/* Display Resolution */

   if (xwGetPrefValue(xwgWYSIWYG)==wmHWYSIWYG)
   {
      xdres=DisplayWidth(fl_get_display(),DefaultScreen(fl_get_display()));
      ydres=DisplayHeight(fl_get_display(),DefaultScreen(fl_get_display()));
   }
   else
   {
      xdres=DisplayWidth(fl_get_display(),DefaultScreen(fl_get_display()))/3;
      ydres=DisplayHeight(fl_get_display(),DefaultScreen(fl_get_display()))/3;
   }

   strcpy(dest,source);

   if ( (xwGetPrefValue(xwgWYSIWYG)!=wmNormal) && (realWYSIWYG==1) )
   {
      strcpy(dest,xwGetFile("","PBCache"));
      strcat(dest,"/");
      strcat(dest,wysName);
      strcat(dest,"-");

      if (stat(source,&attribute) == 0)
      {
         sprintf(IDNr,"%x",(int) attribute.st_ino);
         strcat(dest,IDNr);

         strcpy(IDNr,dest);
         strcat(IDNr,"tmp");

         /* file not exists */
         if (xwExist(dest)==-1)
         {
            if (xwGFXImport(source,dest)==0)
            {

               if (checkppm(dest)==0)
               {
                  xres=xwGetGFXX();
                  yres=xwGetGFXY();
                  aspect=(float) xres/(float) yres;

                  if (xres>xdres)
                  {
                     xres=xdres;
                     yres=(int) ((float) xres/aspect);
                  }

                  if (yres>ydres)
                  {
                     yres=ydres;
                     xres=(int) ((float) yres*aspect);
                  }

                  if (xwGFXLoadPicture(dest)==xwTrue)
                  {
                     xwGFXSetTrans(0);
                     xwGFXScalePicture(memPicture,createTemp,0,0,xres,yres,0);
                     xwGFXSavePicture(IDNr);
                     unlink(dest);
                     link(IDNr,dest);
                     unlink(IDNr);
                  }
               }
            }
            else
            {
               strcpy(dest,source);
            }
         }
      }
      else
      {
         strcpy(dest,source);
      }
   }

   return(dest);
}