/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWVARIABLE_H
#define _XWVARIABLE_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define vardefcount     4096

#define vardefGet       0
#define vardefSet       1

/* Initialize Variable Array */
void xwInitVarDef(void);
/* Delete & Initialize Variable */
void xwDInitVarDef(void);

/* Set Float variable */
void xwSetFVarDef(char *astr,float az);
/* Set Integer variable */
void xwSetIVarDef(char *astr,int az);
/* Set Variable */
void xwSetVarDef(char *astr,char *bstr);

/* Get Float Variable */
float xwGetFVarDef(char *astr);
/* Get Integer Variable */
int xwGetIVarDef(char *astr);
/* Get Variable */
char *xwGetVarDef(char *astr);

/* Insert Variable */
char *xwInsertVarDef(char *astr);
/* Insert Variable - Internal Routine */
void xwInsVarDef(void);

/* List all Variables */
void xwListVarDef(void);

/* Search Variable */
int xwSearchVarDef(int mo,char *astr);

#endif