/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "variable.h"

#include "base.h"

static char       *varName[vardefcount];
static char       *varContent[vardefcount];

static char       strCache[2048]="";

/* Initialize Variable Array */
void xwInitVarDef(void)
{
   int            az;

   for (az=0 ; az<vardefcount ; az++)
   {
      varName[az]=NULL;
      varContent[az]=NULL;
   }

   return;
}

/* Delete & Initialize Variable */
void xwDInitVarDef(void)
{
   int            az;

   for (az=0 ; az<vardefcount ; az++)
   {
      if (varName[az]!=NULL)
      {
         free(varName[az]);
         varName[az]=NULL;
         free(varContent[az]);
         varContent[az]=NULL;
      }
   }

   return;
}

/* Set Float variable */
void xwSetFVarDef(char *astr,float az)
{
   xwSetVarDef(astr,DoubleStr(az,1));

   return;
}

/* Set Integer variable */
void xwSetIVarDef(char *astr,int az)
{
   xwSetVarDef(astr,IntStr(az));

   return;
}

/* Set Variable */
void xwSetVarDef(char *astr,char *bstr)
{
   char           variable[20];
   int            index;

   if ( (strlen(astr)<20) && (strlen(bstr)<1002) )
   {
      strcpy(variable,astr);
      strUpper(variable);

      index=xwSearchVarDef(vardefSet,variable);
      if (index>-1)
      {
         /* Variable Name */
         if (varName[index]==NULL)
         {
            varName[index] = (char*) malloc(strlen(variable)+1);
         }
         else
         {
            varName[index] = (char*) realloc(varName[index],strlen(variable)+1);
         }
         if (varName[index]!=NULL) strcpy(varName[index],variable);

         /* Variable Content */
         if (varContent[index]==NULL)
         {
            varContent[index] = (char*) malloc(strlen(bstr)+1);
         }
         else
         {
            varContent[index] = (char*) realloc(varContent[index],strlen(bstr)+1);
         }
         if (varContent[index]!=NULL) strcpy(varContent[index],bstr);
      }
      else
      {
         printf("xwGUI: not enough memmory available for variable !!!\n");
      }
   }

   return;
}

/* Get Float Variable */
float xwGetFVarDef(char *astr)
{
   return(atof(xwGetVarDef(astr)));
}

/* Get Integer Variable */
int xwGetIVarDef(char *astr)
{
   return(atoi(xwGetVarDef(astr)));
}

/* Get Variable */
char *xwGetVarDef(char *astr)
{
   char           variable[20];
   int            index;

   if (strlen(astr)<20)
   {
      strcpy(variable,astr);
      strUpper(variable);

      index=xwSearchVarDef(vardefGet,variable);
      if (index>-1)
      {
         return(varContent[index]);
      }
   }

   return("");
}

/* Insert Variable */
char *xwInsertVarDef(char *astr)
{
   strcpy(strCache,astr);
   xwInsVarDef();

   return(strCache);
}

/* Insert Variable - Internal Routine */
void xwInsVarDef(void)
{
   static char       strResult[2048];
   static char       strVariable[2048];
   unsigned char     *strptr;

   int               strFlag;

   strcpy(strResult,"");
   strcpy(strVariable,"");

   strFlag=0;

   /* search begin of variable */
   strptr=strchr(strCache,'%');
   if (strptr!=NULL)
   {
      strFlag=1;

      /* first part of string */
      strptr[0]='\0';
      strcpy(strResult,strCache);
      strptr=strptr+1;
      strcpy(strVariable,strptr);

      /* search end of variable */
      strptr=strchr(strVariable,'%');
      if (strptr!=NULL)
      {
         /* terminate variable */
         strptr[0]='\0';

         /* Insert Variable */
         strcat(strResult,xwGetVarDef(strVariable));

         /* rest of string */
         strptr=strptr+1;
         strcat(strResult,strptr);

         strcpy(strCache,strResult);
      }
   }

   /* Next Variable, please */
   if (strFlag==1) xwInsVarDef();

   return;
}

/* List all Variables */
void xwListVarDef(void)
{
   int            search;

   printf("Internal Variable definition...\n\n");

   /* search name */
   for (search=0; search<vardefcount ; search++)
   {
      if (varName[search]!=NULL)
      {
         printf("%s = ",varName[search]);
         if (varContent[search]!=NULL)
         {
            printf("%s\n",varContent[search]);
         }
         else
         {
            printf(" No Content\n");
         }
      }
   }

   return;
}

/* Search Variable */
int xwSearchVarDef(int mo,char *astr)
{
   int            entry;
   int            empty;
   int            search;

   char           variable[20];

   strcpy(variable,astr);

   entry=-1;
   empty=-1;

   /* search name */
   for (search=0; search<vardefcount ; search++)
   {
      if (varName[search]==NULL)
      {
         if (empty==-1) empty=search;
      }
      else
      {
         if (strcmp(varName[search],variable) == 0) entry=search;
      }
   }

   /* create new variable */
   if ( (entry==-1) && (mo==vardefSet) ) entry=empty;

   return(entry);
}

