#!/bin/sh
#set -x
OS=`uname -s`
CPU=`uname -p`
IROOT=user

# check for user 'root'
#if [ "$HOME" = /root ]; then
#   IROOT='root'
#fi
#if [ "$HOME" = / ]; then
#   IROOT='root'
#fi

if [ 0 = `id | tr '=()' ':::' | cut -d: -f 2` ]; then
   IROOT='root'
fi

if [ "$IROOT" != root ]; then
   echo "You must logged in as 'root' for installing xwGUI !"
   echo "Sie mssen sich als 'root' einloggen um xwGUI"
   echo "installieren zu knnen !"
   echo "Devi essere 'root' per installare xwGUI !"
   rm -f xforms.txt
   rm -f t1lib.txt
   rm -f X11.txt
   exit 1
fi

echo
echo "search needed files..."
echo "suche nach bentigten Daten..."
echo "Cerco i file necessari..."
echo

_tst=`echo -n`
if [ x$_tst = x-n ]
then
   echoType=SYSV_E
else
   echoType=BSD_E
fi

cecho()
{
   sed -e "s/#$echoType//" $1
}

# ##################################################################################################
# # INITIALIZING                                                                                   #
# ##################################################################################################

# check xforms installation
rm -f xforms.txt
if [ "$OS" = SunOS ]; then
   if [ -f /usr/lib/libforms.so.0.88 ]; then
      echo "/usr/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/lib/libforms.so.0.88# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.88 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.88# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.88 ]; then
      echo "/usr/local/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.88# >Makefile.tmp
   fi

   if [ -f /usr/lib/libforms.so.0.89 ]; then
      echo "/usr/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/lib/libforms.so.0.89# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.89 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.89# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.89 ]; then
      echo "/usr/local/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.89# >Makefile.tmp
   fi;

   if [ -f /usr/lib/libforms.so.0.9999 ]; then
      echo "/usr/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/lib/libforms.so.0.9999# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.9999 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.9999# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.9999 ]; then
      echo "/usr/local/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.SOLARIS | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.9999# >Makefile.tmp
   fi;
else
   if [ -f /usr/lib/libforms.so.0.88 ]; then
      echo "/usr/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/lib/libforms.so.0.88# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.88 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.88# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.88 ]; then
      echo "/usr/local/lib/libforms.so.0.88" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.88# >Makefile.tmp
   fi

   if [ -f /usr/lib/libforms.so.0.89 ]; then
      echo "/usr/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/lib/libforms.so.0.89# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.89 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.89# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.89 ]; then
      echo "/usr/local/lib/libforms.so.0.89" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.89# >Makefile.tmp
   fi;

   if [ -f /usr/lib/libforms.so.0.9999 ]; then
      echo "/usr/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/lib/libforms.so.0.9999# >Makefile.tmp
   fi
   if [ -f /usr/X11R6/lib/libforms.so.0.9999 ]; then
      echo "/usr/X11R6/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/X11R6/lib/libforms.so.0.9999# >Makefile.tmp
   fi
   if [ -f /usr/local/lib/libforms.so.0.9999 ]; then
      echo "/usr/local/lib/libforms.so.0.9999" >xforms.txt
      cecho Makefile.LINUX | sed -e s#%XFORMS#/usr/local/lib/libforms.so.0.9999# >Makefile.tmp
   fi;
fi;


# check t1lib installation
rm -f t1lib.txt
if [ -f /usr/lib/libt1.so.1 ]; then
   echo "/usr/lib/libt1.so.1" >t1lib.txt
   cecho Makefile.tmp | sed -e s#%LIBT1#/usr/lib/libt1.so.1# >Makefile
fi
if [ -f /usr/X11R6/lib/libt1.so.1 ]; then
   echo "/usr/X11R6/lib/libt1.so.1" >t1lib.txt
   cecho Makefile.tmp | sed -e s#%LIBT1#/usr/X11R6/lib/libt1.so.1# >Makefile
fi
if [ -f /usr/local/lib/libt1.so.1 ]; then
   echo "/usr/local/lib/libt1.so.1" >t1lib.txt
   cecho Makefile.tmp | sed -e s#%LIBT1#/usr/local/lib/libt1.so.1# >Makefile
fi


# check X11 development installation
rm -f X11.txt
if [ -s /usr/include/X11/Xlib.h ]; then
   echo "/usr/include/X11/Xlib.h" >X11.txt
fi
if [ -f /usr/X11R6/include/X11/Xlib.h ]; then
   echo "/usr/X11R6/include/X11/Xlib.h" >X11.txt
fi
if [ -f /usr/local/include/X11/Xlib.h ]; then
   echo "/usr/local/include/X11/Xlib.h" >X11.txt
fi
if [ -f include/X11/Xlib.h ]; then
   echo "include/X11/Xlib.h" >X11.txt
fi

# for internal test's
#  rm -f xforms.txt
#  rm -f t1lib.txt
#  rm -f X11.txt

# ##################################################################################################
# # COMPILING                                                                                      #
# ##################################################################################################

# correct settings
if [ -f xforms.txt ]; then
   if [ -f t1lib.txt ]; then
      if [ -f X11.txt ]; then
         echo "configure xwGUI..."
         echo "Konfiguriere xwGUI..."
         echo "Configurazione xwGUI..."
         echo
         make clean
         echo "compile xwGUI..."
         echo "bersetze xwGUI..."
         echo "Compilazione xwGUI..."
         echo
         #              1         2         3         4         5         6         7;
         #     1234567890123456789012345678901234567890123456789012345678901234567890;
         echo "|======================================================|"
         if [ "$OS" = SunOS ]; then
            if make; then
               echo ""
            else
               echo ""
               echo "Compiling Error !!!"
               echo "bersetzungsfehler !!!"
               echo "Errore di compilazione !!!"
               rm -f xforms.txt
               rm -f t1lib.txt
               rm -f X11.txt
               exit 1
            fi
         else
            if make; then
               echo ""
            else
               echo ""
               echo "Compiling Error !!!"
               echo "bersetzungsfehler !!!"
               echo "Errore di compilazione !!!"
               rm -f xforms.txt
               rm -f t1lib.txt
               rm -f X11.txt
               exit 1
            fi
         fi
         echo
         echo "install xwGUI..."
         echo "Installiere xwGUI..."
         echo "Installazione xwGUI..."
         echo
         make install
         echo "set group ID and permissions..."
         echo "Setze Gruppen ID und Zugriffsrechte..."
         echo "Configurazione ID e permessi di gruppo..."
         chgrp `ls -l /dev/lp1 | awk '{print $4}'` /usr/local/bin/xwgui2
         chmod 755 /usr/local/bin/xwgui2
         chmod 755 /usr/local/lib/xwgui2/Xwgui
         echo
         echo "You must do an relogin now. Don't login as root."
         echo "Type xwgui2 to start xwGUI."
         echo "Um xwGUI zu nutzen sollten Sie sich jetzt als Nutzer"
         echo "( nicht root ) anmelden. xwGUI knnen Sie durch"
         echo "Eingabe von xwgui2 starten."
         echo "Ora esci e rientra. Non entrare come root."
         echo "Usa xwgui2 per lanciare xwGUI."
         echo ""
         echo "Binry: /usr/local/bin/xwgui2"
         echo "Datas : /usr/local/lib/xwgui2"
         rm -f xforms.txt
         rm -f t1lib.txt
         rm -f X11.txt
         exit 1
      fi
   fi
fi

# ##################################################################################################
# # FAILED                                                                                         #
# ##################################################################################################

# failed settings
echo "-------------------------------------------------------------------------"
echo "Missing File/s !"
echo "Datei/en nicht gefunden !"
echo "File mancante !"
echo
echo "GLIBC-Version:"
ls -l /lib/ld*.so
echo

if [ -f xforms.txt ]; then :;else
   echo "-------------------------------------------------------------------------"
   echo "Install XForms Library, please !"
   echo "Bitte, installieren Sie die XForms Bibliothek !"
   echo "Installa XForms Paket, per favore ! Version >=0.88"
   echo "Package: xforms.rpm"
   echo "URL: http://world.std.com/~xforms"
fi

if [ -f t1lib.txt ]; then :;else
   echo "-------------------------------------------------------------------------"
   echo "Install T1Lib Package Version >=1.1.0, please !"
   echo "Bitte, installieren Sie das T1Lib Paket ! Version >=1.1.0"
   echo "Installa T1Lib Paket, per favore ! Version >=1.1.0"
   echo "Package: t1lib.rpm"
   echo "URL: http://ibiblio.org/pub/Linux//libs/graphics ( SunSite/MetaLab )"
fi

if [ -f X11.txt ]; then :;else
   echo "-------------------------------------------------------------------------"
   echo "Install XFree Development Package, please !"
   echo "Bitte, installieren Sie das XFree Entwickler Paket !"
   echo "Installa XFree Entwickler Paket, per favore !"
   echo "Package: xdevel.rpm"
fi

rm -f xforms.txt
rm -f t1lib.txt
rm -f X11.txt
exit 1
