/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWSELECTFP_H
#define _XWSELECTFP_H

#include <forms.h>
#include <string.h>
#include <unistd.h>

typedef struct picframeform
{
   /* Main-Form data */
   FL_FORM           *form;
   /* Event Loop */
   FL_OBJECT         *obj;
   int               ready;
   
   FL_OBJECT         *browser;
   FL_OBJECT         *up;
   FL_OBJECT         *down;

   FL_OBJECT         *cancel;

} picframeform;

/* Event Handling */
void xwSelectFP(FL_OBJECT *objA,FL_OBJECT *objB);
/* Select Frame/Picture */
void xwOpenFP(void);
/* Close Select Frame/Picture */
void xwCloseFP(void);
/* actualize browser */
void xwActualizeFP(void);
/* deactivate Frame/Picture */
void xwDeactivateFP(void);
/* Activate Frame/Picture */
void xwActivateFP(void);


#endif