/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "selectfp.h"

/* xwGUI Includes */
#include "default.h"
#include "frame.h"
#include "main_action.h"
#include "page.h"
#include "paper.h"
#include "picture.h"
#include "resource.h"
#include "handler.h"
#include "x11.h"

static struct picframeform pff;

static int                 SelectFPFlag=0;

/* Event Handling */
void xwSelectFP(FL_OBJECT *objA,FL_OBJECT *objB)
{
   int            az;

   if (objA==objB)
   {
      if (SelectFPFlag==0)
      {
         xwOpenFP();
      }
      else
      {
         xwCloseFP();
      }
   }
   else
   {
      if (SelectFPFlag==1)
      {
         /* Exit */
         if (objA==pff.cancel)
         {
            xwCloseFP();
         }

         /* Browser */
         else if (objA==pff.browser)
         {
            az=fl_get_browser(pff.browser)-1;
            if (az>-1)
            {
               az=(fl_get_browser_maxline(pff.browser)-1)-az;

               /* Normal Picture Mode */
               if (xwCheckFrameMode()==-1)
               {
                  xwSetActivePicture(az);
               }
               /* Frame Mode */
               else if ( (xwCheckFrameMode()==0) && (xwCheckEditFrame()==-1) )
               {
                  /*
                  xwSetActivePicFrame(az);
                  */
                  xwSetActiveFrame(az);
               }
               /* Frame Edit Mode */
               else if ( (xwCheckFrameMode()==0) && (xwCheckEditFrame()==0) )
               {
                  xwSetActiveFrame(az);
               }

               xwDrawPage(pgRedraw);
            }
         }

         /* Up */
         else if (objA==pff.up)
         {
            xwFront();
            if (xwCheckFrameMode()==-1)
            {
               fl_set_browser_topline(pff.browser,xwGetPictureCount()-xwGetActivePicture());
            }
            else
            {
               fl_set_browser_topline(pff.browser,xwGetFrameCount()-xwGetActiveFrame());
            }
         }

         /* Down */
         else if (objA==pff.down)
         {
            xwBack();
            if (xwCheckFrameMode()==-1)
            {
               fl_set_browser_topline(pff.browser,xwGetPictureCount()-xwGetActivePicture());
            }
            else
            {
               fl_set_browser_topline(pff.browser,xwGetFrameCount()-xwGetActiveFrame());
            }            
         }

      }
   }

   return;
}

/* Select Frame/Picture */
void xwOpenFP(void)
{
   if (SelectFPFlag==0)
   {
      pff.form = fl_bgn_form(FL_UP_BOX,250,400);
      fl_set_border_width(1);

      pff.browser = fl_add_browser(FL_HOLD_BROWSER,5,5,210,365,"");
      xwCreateFrameChoice(pff.browser);

      pff.up = fl_add_button(FL_TOUCH_BUTTON,220,165,20,20,"@8UpArrow");
      pff.down = fl_add_button(FL_TOUCH_BUTTON,220,190,20,20,"@2UpArrow");

      pff.cancel = fl_add_button(FL_NORMAL_BUTTON,5,375,240,20,xwGR(1,"prtf.Close","Close"));

      fl_end_form();

      fl_prepare_form_window(pff.form,FL_PLACE_GEOMETRY,FL_FULLBORDER,xwGR(1,"msg.Browser","Picture/Frame Browser"));
/*
      fl_prepare_form_window(pff.form,FL_PLACE_GEOMETRY,FL_NOBORDER,xwGR(1,"msg.Browser","Picture/Frame Browser"));
*/
/*
      fl_set_form_position(pff.form,xwGetPrefValue(xwgLayerXPos),xwGetPrefValue(xwgLayerYPos));
*/

      fl_set_form_dblbuffer(pff.form,0);
      fl_show_form_window(pff.form);

      fl_set_form_position(pff.form,xwGetPrefValue(xwgLayerXPos),xwGetPrefValue(xwgLayerYPos));

      /* Exit Handler */
      fl_set_form_atclose(pff.form,nclose_cb,(void *) "1");

      SelectFPFlag=1;
   }

   return;
}

/* Close Select Frame/Picture */
void xwCloseFP(void)
{
   int                  xpos,ypos;
   XWindowAttributes    attr;

   if (SelectFPFlag==1)
   {
      fl_get_winorigin(pff.form->window,&xpos,&ypos);
      XGetWindowAttributes(fl_get_display(),pff.form->window,&attr);

      xpos=xpos-attr.x;
      ypos=ypos-attr.y;

      xwSetPrefValue(xwgLayerXPos,xpos);
      xwSetPrefValue(xwgLayerYPos,ypos);
      xwSetPrefValue(xwgLayer,1);

      fl_hide_form(pff.form);
      fl_free_form(pff.form);
      SelectFPFlag=0;
   }
   else
   {
      xwSetPrefValue(xwgLayer,0);
   }

   return;
}

/* actualize browser */
void xwActualizeFP(void)
{
   if (SelectFPFlag==1)
   {
      fl_freeze_form(pff.form);
      fl_clear_browser(pff.browser);
      xwCreateFrameChoice(pff.browser);
      if (xwCheckFrameMode()==-1)
      {
         fl_set_browser_topline(pff.browser,xwGetPictureCount()-xwGetActivePicture());
      }
      else
      {
         fl_set_browser_topline(pff.browser,xwGetFrameCount()-xwGetActiveFrame());
      }
      fl_unfreeze_form(pff.form);
   }

   return;
}

/* deactivate Frame/Picture */
void xwDeactivateFP(void)
{
   if (SelectFPFlag==1)
   {
      fl_deactivate_form(pff.form);
   }

   return;
}

/* Activate Frame/Picture */
void xwActivateFP(void)
{
   if (SelectFPFlag==1)
   {
      fl_activate_form(pff.form);
   }

   return;
}
