/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "resource.h"

#include "base.h"


static      char        *resourceBuffer=NULL;   /* Resource Datas */
static      int         resourceSize=0;         /* Resource Size */
static      int         resourceFlag=0;         /* Resource loading ? */
static      char        resourceLang[20];       /* Language Code */
static      char        installDir[256];        /* Installation Path */
static      char        homeDir[256];           /* Home Directory */
static      char        homeDrawer[256];        /* Home Drawer */

/* Load Resource & Check Language Code */
void xwInitResource(const char *source)
{
   FILE           *fh;
   int            size;
   struct stat    sstat;

   /* Langauage Check Variable */
   int            flag;
   char           *lang;
   const char     *strptr;

   /* load Resource File */
   if ( (fh=fopen(source,"rb")) != NULL )
   {
      if (stat(source,&sstat)==0)
      {
         size=(int) sstat.st_size;
         resourceSize=size;

         resourceBuffer = (char*) calloc(size+4,1);
         if (resourceBuffer!=NULL)
         {
            resourceFlag=1;
            fread(resourceBuffer,1,size,fh);
         }
      }
      fclose(fh);
   }

   /* Check Language */
   flag=-1;
   lang=getenv("LANG");
   if (lang != NULL)
   {
      strcpy(resourceLang,lang);
      strptr=xwGR(1,"lang","en");
      strcpy(resourceLang,strptr);
      flag=0;
   }

   lang=getenv("LC_ALL");
   if ( (lang != NULL) && (flag==-1) )
   {
      strcpy(resourceLang,lang);
      if (strlen(resourceLang)>2)
      {
         resourceLang[2]='\0';
         flag=0;
      }
   }

   lang=getenv("LC_MESAGES");
   if ( (lang != NULL) && (flag==-1) )
   {
      strcpy(resourceLang,lang);
      if (strlen(resourceLang)>2)
      {
         resourceLang[2]='\0';
         flag=0;
      }
   }

   if (flag==-1)
   {
      strcpy(resourceLang,"en");
   }

   /* Correct locale initialize */
   setlocale(LC_ALL,"");
   setlocale(LC_ALL,"C");
   
   return;
}

/* Free Resource Datas */
void xwFreeResource(void)
{
   if (resourceFlag==1)
   {
      free(resourceBuffer);
   }

   return;
}

/* Install Path Check */
void xwInstallPath(const char *path)
{
   struct stat             sstat;
   char                    *strptr;
   char                    Puffer[256];

   strptr=getenv("HOME");
   strcpy(homeDir,strptr);

   /* Check Install Directory */
   strcpy(Puffer,"/usr/X11R6/lib/");
   strcat(Puffer,path);
   if (stat(Puffer,&sstat)==0)
   {
      strcpy(installDir,Puffer);
      strcat(installDir,"/");
   }
   else
   {
      strcpy(Puffer,"/usr/X11/lib/");
      strcat(Puffer,path);
      if (stat(Puffer,&sstat)==0)
      {
         strcpy(installDir,Puffer);
      }
      else
      {
         strcpy(Puffer,"/usr/X/lib/");
         strcat(Puffer,path);
         if (stat(Puffer,&sstat)==0)
         {
            strcpy(installDir,Puffer);
         }
         else
         {
            strcpy(Puffer,"/usr/lib/");
            strcat(Puffer,path);
            if (stat(Puffer,&sstat)==0)
            {
               strcpy(installDir,Puffer);
            }
            else
            {
               strcpy(Puffer,"/usr/local/lib/");
               strcat(Puffer,path);
               if (stat(Puffer,&sstat)==0)
               {
                  strcpy(installDir,Puffer);
               }
               else
               {
                  strcpy(Puffer,homeDir);
                  strcat(Puffer,"/");
                  strcat(Puffer,path);
                  if (stat(Puffer,&sstat)==0)
                  {
                     strcpy(installDir,Puffer);
                  }
               }
            }
         }

      }
   }

   return;
}

/* Set Home Drawer */
void xwSetDrawer(const char *drawer)
{
   if (strlen(drawer)>0)
   {
      strcpy(homeDrawer,drawer);
   }
   
   return;
}

/* Get Install Path */
const char * xwGetIP(const char *file)
{
   static char       path[256];
   
   strcpy(path,installDir);
   
   if (file!=NULL)
   {
      strcat(path,"/");
      strcat(path,file);
   }
   
   return(path);
}

/* Get Programm File */
char *xwGetFile(char *drawer,char *file)
{
   static char       path[2048];

   strcpy(path,homeDir);
   strcat(path,"/");
   if (strlen(drawer)==0)
   {
      strcat(path,homeDrawer);
   }
   else
   {
      strcpy(path,drawer);
   }
   if (strlen(file)>0)
   {
      strcat(path,"/");
      strcat(path,file);
   }
   
   /* actual home directory */
   if (strcmp(drawer,"//") == 0) strcpy(path,homeDir);
   
  
   /*printf("xwGetFile: %s\n",path);*/
   
   return(path);
}

/* Set Language Code */
void xwSetLang(const char *lang)
{
   strcpy(resourceLang,lang);
   return;
}

/* Get Language Code */
const char * xwGetLang(void)
{
   return(resourceLang);
}

/* Get Resource */
const char * xwGR(int lang,const char *resource,const char *def)
{
   static char             res[1024];
   char                    Puffer[1024];
   char                    search[1024];

   char                    *nextSearch;
   char                    *aktSearch;
   char                    *endSearch;
   char                    *startStr,*endStr;

   char                    *strptrA,*strptrB,*strptrC;
   int                     a,b;

   if (resourceFlag==1)
   {
      /* Search Argument */
      strcpy(search,resource);
      if (lang==1)
      {
         strcat(search,".");
         strcat(search,resourceLang);
      }
      strcat(search,":");

#ifdef printResource
      printf("%s %s\n",search,def);
#endif

      nextSearch=resourceBuffer;
      endSearch=resourceBuffer+resourceSize;
      while (nextSearch<endSearch)
      {
         /* Search next Entry */
         aktSearch=strstr(nextSearch,search);

         /* Found Searchstring */
         if (aktSearch!=NULL)
         {
            /* search start of line */
            if (aktSearch!=resourceBuffer)
            {
               startStr=aktSearch;

               /* advance down to '\n' */
               while ( (*startStr!='\0') && (*startStr != '\n') && (startStr > resourceBuffer) ) startStr--;

               if (startStr>resourceBuffer) startStr++;

            }
            else
            {
               startStr=resourceBuffer;
            }

            /* search end of line */
            endStr=aktSearch;

            /* advance up to '\n' */
            while ( (*endStr!='\0') && (*endStr != '\n') && (endStr < endSearch) ) endStr++;

            if ( (( (int) endStr - (int) startStr) > 0) && ((int) endStr>0) )
            {
               strncpy(res, startStr, (int)(endStr - startStr));
               res[(int)(endStr - startStr)]='\0';
            }

            /* printf(">%s<\n",res); */

            /* next Search */
            nextSearch=aktSearch+1;

         }
         else
         {
            strcpy(res,"");
            nextSearch=endSearch;
         }

         if (strlen(res)>0)
         {
            /* Delete Remark */
            strptrA=strNoRem(res,"#");
            strcpy(Puffer,strptrA);

            /* Delete Spaces */
            strTrim(Puffer);

            strptrA=strstr(Puffer,search);
            if (strptrA==Puffer)
            {
               /* Found Searching Resource !!! */
               nextSearch=endSearch;

               strptrA=strptrA+strlen(search);

               strcpy(res,strptrA);
               strTrim(res);
            }

         }
         else
         {
            strcpy(res,def);
         }
      }
   }
   else
   {     
      strcpy(res,def);
   }

   /* Convert String - ( \n -> 0x10 ) */
   strptrA=res;
   while ( (strptrB=strstr(strptrA,"\\n"))!=NULL)
   {
      a=((int)strptrB)-((int)strptrA);
      if (a>0)
      {
         b=(strlen(res)-a);
         strptrC=strptrB+1;
         memcpy(strptrB,strptrC,b);
         res[a]='\n';
      }
   }

   return(res);
}