/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWRENDER_H
#define _XWRENDER_H

#include <forms.h>

#include <string.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>

/* ImageMagic Convert String */
/*
#define imConvert "convert -geometry %XSIZE%x%YSIZE% -rotate %ROT% %IN% PPM:%OUT%"
*/

typedef struct renderdatas
{
   float             xwDPI;                  /* Inch Measure Factor */

   int               paperXSize;             /* PaperSize */
   int               paperYSize;

   int               paperLB;                /* Left Border */
   int               paperRB;                /* Right Border */
   int               paperTB;                /* Top Border */
   int               paperBB;                /* Bottom Border */
   
   int               fileSize;               /* Filesize */

   int               elements;               /* Count of Picture/Frames */
   
   int               rot;                    /* Rotated Picture */
   int               xpos;                   /* X-Position */
   int               ypos;                   /* Y-Position */
   int               xsize;                  /* X-Size */
   int               ysize;                  /* Y-Size */
   int               xxsize;
   int               yysize;
   
   int               xfpos;                  /* Frame X-Position */
   int               yfpos;                  /* Frame Y-Position */
   int               xfsize;                 /* Frame X-Size */
   int               yfsize;                 /* Frame Y-Size */

/* Frame Border Datas */   
   int               frmSize;                /* Frame Size */
   int               frmSColor;              /* Frame Background Color */
   int               frmBorder;              /* Frame Draw Border Size */
   int               frmColor;               /* Frame Color */

   int               frmMax;                 /* Maximal Border Size */

/* Picture Border Datas */   
   int               picSize;                /* Picture Size */
   int               picSColor;              /* Picture Background Color */
   int               picBorder;              /* Picture Draw Border Size */
   int               picColor;               /* Picture Color */   
   
   int               fsize;                  /* Framesize */
   int               bsize;                  /* Bordersize */

} renderdatas;

typedef struct rgbColors
{
   unsigned char     r;
   unsigned char     g;
   unsigned char     b;
} rgbColors;

/* Refresh Command */
void xwRenderRefresh(void);   
/* Rendering Engine */
Pixmap xwRender(float dpi,int mo,int xsize,int ysize);
/* Render Engine for Pixmaps */
Pixmap xwRenderPixmap(float dpi,int pixNr,int *xsize,int *ysize);
/* Render Engine for Text */
void xwRNDText(int frm,float dpi);


#endif
