/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPRTMANAGER_H
#define _XWPRTMANAGER_H

#include <forms.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define maxwidgets    1024
#define maxprinter    1024

#define callcount     10
#define scriptcount   1024
#define defcount      1024
#define linecount     2048

/* Widget Definitions */
#define wgScript      0
#define wgBoolean     1
#define wgChoice      2


typedef struct widgetdata
{
   char        *ID[maxwidgets];           /* Identifier */
   int         pri[maxwidgets];           /* Script Priority */
   char        *type[maxwidgets];         /* Widget Type */
   int         tab[maxwidgets];           /* Widget Tabulator */ 
   char        *name[maxwidgets];         /* Widget Name */
   char        *option[maxwidgets];       /* Script Option */
   char        *def[maxwidgets];          /* Default Setting */
   float       minval[maxwidgets];        /* Minimal Value */
   float       maxval[maxwidgets];        /* Maximal Value */
   float       step[maxwidgets];          /* Step Value */
   char        *entrys[maxwidgets];       /* Internal Entrys */
   char        *wentrys[maxwidgets];      /* Widget Entrys */
   char        *variable[maxwidgets];     /* Variable Name */
} widgetdata;

typedef struct printerdata
{
   char        *name[maxprinter];         /* Printer Name */
   char        *script[maxprinter];       /* first Script entry */
   int         hide[maxprinter];          /* Hide Printer */
   
   char        *guiAName[maxprinter];     /* GUI A Name */ 
   int         countA[maxprinter];        /* GUI A count */
   char        *guiA[maxprinter][20];     /* GUI A */
   int         idxA[maxprinter][20];      /* Index A */
   int         tabA[maxprinter];          /* GUI A Tab */
   char        *defA[maxprinter][20];     /* Default A */
   char        *entrysA[maxprinter][20];  /* Entrys A */
   char        *wentrysA[maxprinter][20]; /* Widget Entrys A */

   char        *guiBName[maxprinter];     /* GUI B Name */ 
   int         countB[maxprinter];        /* GUI B count */
   char        *guiB[maxprinter][20];     /* GUI B */
   int         idxB[maxprinter][20];      /* Index B */
   int         tabB[maxprinter];          /* GUI B Tab */        
   char        *defB[maxprinter][20];     /* Default B */
   char        *entrysB[maxprinter][20];  /* Entrys B */
   char        *wentrysB[maxprinter][20]; /* Widget Entrys B */

   char        *guiCName[maxprinter];     /* GUI C Name */
   int         countC[maxprinter];        /* GUI C count */
   char        *guiC[maxprinter][20];     /* GUI C */
   int         idxC[maxprinter][20];      /* Index C */
   int         tabC[maxprinter];          /* GUI C Tab */
   char        *defC[maxprinter][20];     /* Default C */
   char        *entrysC[maxprinter][20];  /* Entrys C */
   char        *wentrysC[maxprinter][20]; /* Widget Entrys C */

   char        *guiDName[maxprinter];     /* GUI D Name */
   int         countD[maxprinter];        /* GUI D count */
   char        *guiD[maxprinter][20];     /* GUI D */
   int         idxD[maxprinter][20];      /* Index D */
   int         tabD[maxprinter];          /* GUI D Tab */
   char        *defD[maxprinter][20];     /* Default D */
   char        *entrysD[maxprinter][20];  /* Entrys D */
   char        *wentrysD[maxprinter][20]; /* Widget Entrys D */
} printerdata;


/* Initialize PrtManager Datas */
void xwInitPrtManager(void);
/* Delete & Initialize PrtManager Datas */
void xwDInitPrtManager(void);

/* Add Widget Counter */
int xwAddWCount(void);
/* Add Widget */
void xwAddWidget(int wd,char *ID);
/* Set Script Priority */
void xwSetWidgetPri(int wd,int pri);
/* Set Widget Type */
void xwSetWidgetType(int wd,char *type);
/* Set Widget Tab */
void xwSetWidgetTab(int wd,int flag);
/* Set Widget Name */
void xwSetWidgetName(int wd,char *name);
/* Set Widget Option */
void xwSetWidgetOption(int wd,char *option);
/* Set Widget Default */
void xwSetWidgetDefault(int wd,char *def);
/* Modify Widget Default */
void xwModifyWidgetDefault(int idx,char *def);
/* Set Widget MinValue */
void xwSetWidgetMinVal(int wd,float value);
/* Set Widget MaxValue */
void xwSetWidgetMaxVal(int wd,float value);
/* Set Widget Step Value */
void xwSetWidgetStep(int wd,float value);
/* Set Widget Entrys */
void xwSetWidgetEntrys(int wd,char *entrys);
/* Set Widget WEntrys */
void xwSetWidgetWEntrys(int wd,char *wentrys);
/* Set Widget Variable */
void xwSetWidgetVariable(int wd,char *variable);

/* Get Max Widget */
int xwGetWidgetCount(void);
/* Get Widget ID */
char *xwGetWidgetID(int idx);
/* Get Widget Index */
int xwGetWidgetIndex(char *ID);
/* Get Script Priority */
int xwGetWidgetPri(int idx);
/* Get Widget Type */
char *xwGetWidgetType(int idx);
/* Get Widget Tab */
int xwGetWidgetTab(int idx);
/* Get Widget Name */
char *xwGetWidgetName(int idx);
/* Get Widget Option */
char *xwGetWidgetOption(int idx);
/* Get Widget Default */
char *xwGetWidgetDefault(int idx);
/* Get Widget MinValue */
float xwGetWidgetMinVal(int idx);
/* Get Widget MaxValue */
float xwGetWidgetMaxVal(int idx);
/* Get Widget Step Value */
float xwGetWidgetStep(int idx);
/* Get Widget Entrys */
char *xwGetWidgetEntrys(int idx);
/* Get Widget WEntrys */
char *xwGetWidgetWEntrys(int idx);
/* Get Widget Variable */
char *xwGetWidgetVariable(int idx);

/* Printer Data Manipulation */

/* ----- SET PRINTER DATA ----- */

/* Add Printer */
void xwAddPrinter(char *name);
/* Clone Printer */
void xwClonePrinter(char *name);
/* Set Printer Scripts */
void xwSetPrinterScript(char *script);
/* Hide Printer */
void xwSetHidePrinter(void);
/* Set Printer GUI Name */
void xwSetPrinterGUIName(int nr,char *name);
/* Set Printer Tab */
void xwSetPrinterGUITab(int nr,int pos);
/* Add Printer Widget */
void xwAddPrinterWidget(int nr,char *name);
/* Set Printer Widget Default */
void xwSetPrinterWidgetDefault(char *widget,char *def);
/* Set Printer Widget Entrys */
void xwSetPrinterWidgetEntrys(char *widget,char *entrys);
/* Set Printer Widget WEntrys */
void xwSetPrinterWidgetWEntrys(char *widget,char *entrys);

/* ----- GET PRINTER DATA ----- */

/* Get Max Printer */
int xwGetPrinterCount(void);
/* Get Printer Widget Count */
int xwGetPrinterWCount(int nr,int idx);
/* Get Printer Name */
char *xwGetPrinterName(int idx);
/* Get Printer Script */
char *xwGetPrinterScript(int idx);
/* Get Hide Printer */
int xwGetHidePrinter(int idx);
/* Get Printer GUI */
char *xwGetPrinterGUI(int nr,int idx);
/* Get Printer Tab */
int xwGetPrinterGUITab(int nr,int idx);
/* Get Printer Widget */
char *xwGetPrinterWidget(int nr,int idx,int pos);
/* Get Printer Widget Index */
int xwGetPrinterWIndex(int nr,int idx,int pos);
/* Get Printer Number */
int xwGetPrinterNumber(char *printer);
/* Get Printer Widget Entrys */
char *xwGetPrinterWidgetEntrys(int nr,int idx,int pos);
/* Get Printer Widget Entrys */
char *xwGetPrinterWidgetWEntrys(int nr,int idx,int pos);

/* ----- MISC ROUTINES ----- */

/* Create Printer Index */
void xwCreatePrinterIndex(void);
/* Set Defaults */
void xwSetDefaults(int idx);
/* Save Setting's */
void xwSavePrinterSetting(char *driver,char *printer,char *file,int idx);
/* Load Setting */
void xwLoadPrinterSetting(char *driver,char *printer,char *file);
/* Create Printer Script */
void xwCreatePrinterScript(void);


#endif