/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prtmanager.h"

#include "base.h"
#include "interpreter.h"
#include "pref_printer.h"
#include "resource.h"
#include "variable.h"

/* Widget Definitions */
static widgetdata          WD;
static int                 wdCount;
/* Printer Definitions */
static printerdata         PD;
static int                 pdCount;

/* Initialize PrtManager Datas */
void xwInitPrtManager(void)
{
   int            az;
   int            bz;

   wdCount=-1;
   for (az=0 ; az<maxwidgets ; az++)
   {
      WD.ID[az]=NULL;
      WD.pri[az]=0;
      WD.type[az]=NULL;
      WD.tab[az]=0;
      WD.name[az]=NULL;
      WD.option[az]=NULL;
      WD.def[az]=NULL;
      WD.minval[az]=0;
      WD.maxval[az]=1;
      WD.step[az]=0.01;
      WD.entrys[az]=NULL;
      WD.wentrys[az]=NULL;
      WD.variable[az]=NULL;
   }

   pdCount=-1;
   for (az=0 ; az<maxprinter ; az++)
   {
      PD.name[az]=NULL;
      PD.script[az]=NULL;
      PD.hide[az]=0;
      PD.guiAName[az]=NULL;
      PD.guiBName[az]=NULL;
      PD.guiCName[az]=NULL;
      PD.guiDName[az]=NULL;
      
      for (bz=0 ; bz<20 ; bz++)
      {
         PD.guiA[az][bz]=NULL;
         PD.guiB[az][bz]=NULL;
         PD.guiC[az][bz]=NULL;
         PD.guiD[az][bz]=NULL;

         PD.idxA[az][bz]=-1;
         PD.idxB[az][bz]=-1;
         PD.idxC[az][bz]=-1;
         PD.idxD[az][bz]=-1;

         PD.defA[az][bz]=NULL;
         PD.defB[az][bz]=NULL;
         PD.defC[az][bz]=NULL;
         PD.defD[az][bz]=NULL;

         PD.entrysA[az][bz]=NULL;
         PD.entrysB[az][bz]=NULL;
         PD.entrysC[az][bz]=NULL;
         PD.entrysD[az][bz]=NULL;

         PD.wentrysA[az][bz]=NULL;
         PD.wentrysB[az][bz]=NULL;
         PD.wentrysC[az][bz]=NULL;
         PD.wentrysD[az][bz]=NULL;
      }

      PD.countA[az]=-1;
      PD.countB[az]=-1;
      PD.countC[az]=-1;
      PD.countD[az]=-1;

      PD.tabA[az]=0;
      PD.tabB[az]=0;
      PD.tabC[az]=0;
      PD.tabD[az]=0;
   }

   return;
}

/* Delete & Initialize PrtManager Datas */
void xwDInitPrtManager(void)
{
   int            az;
   int            bz;

   for (az=0 ; az<=wdCount ; az++)
   {
      if (WD.ID[az]!=NULL) free(WD.ID[az]);
      WD.ID[az]=NULL;
      WD.pri[az]=0;
      if (WD.type[az]!=NULL) free(WD.type[az]);
      WD.type[az]=NULL;
      WD.tab[az]=0;
      if (WD.name[az]!=NULL) free(WD.name[az]);
      WD.name[az]=NULL;
      if (WD.option[az]!=NULL) free(WD.option[az]);
      WD.option[az]=NULL;
      if (WD.def[az]!=NULL) free(WD.def[az]);
      WD.def[az]=NULL;
      WD.minval[az]=0;
      WD.maxval[az]=1;
      WD.step[az]=0.01;
      if (WD.entrys[az]!=NULL) free(WD.entrys[az]);
      WD.entrys[az]=NULL;
      if (WD.wentrys[az]!=NULL) free(WD.wentrys[az]);
      WD.wentrys[az]=NULL;
      if (WD.variable[az]!=NULL) free(WD.variable[az]);
      WD.variable[az]=NULL;
   }
   wdCount=-1;

   for (az=0 ; az<maxprinter ; az++)
   {
      if (PD.name[az]!=NULL) free(PD.name[az]);
      PD.name[az]=NULL;
      if (PD.script[az]!=NULL) free(PD.script[az]);
      PD.script[az]=NULL;
      PD.hide[az]=0;
      if (PD.guiAName[az]!=NULL) free(PD.guiAName[az]);
      PD.guiAName[az]=NULL;
      if (PD.guiBName[az]!=NULL) free(PD.guiBName[az]);
      PD.guiBName[az]=NULL;
      if (PD.guiCName[az]!=NULL) free(PD.guiCName[az]);
      PD.guiCName[az]=NULL;
      if (PD.guiDName[az]!=NULL) free(PD.guiDName[az]);
      PD.guiDName[az]=NULL;

      for (bz=0 ; bz<20 ; bz++)
      {
         if (PD.guiA[az][bz]!=NULL) free(PD.guiA[az][bz]);
         PD.guiA[az][bz]=NULL;
         if (PD.guiB[az][bz]!=NULL) free(PD.guiB[az][bz]);
         PD.guiB[az][bz]=NULL;
         if (PD.guiC[az][bz]!=NULL) free(PD.guiC[az][bz]);
         PD.guiC[az][bz]=NULL;
         if (PD.guiD[az][bz]!=NULL) free(PD.guiD[az][bz]);
         PD.guiD[az][bz]=NULL;

         PD.idxA[az][bz]=-1;
         PD.idxB[az][bz]=-1;
         PD.idxC[az][bz]=-1;
         PD.idxD[az][bz]=-1;

         if (PD.defA[az][bz]!=NULL) free(PD.defA[az][bz]);
         PD.defA[az][bz]=NULL;
         if (PD.defB[az][bz]!=NULL) free(PD.defB[az][bz]);
         PD.defB[az][bz]=NULL;
         if (PD.defC[az][bz]!=NULL) free(PD.defC[az][bz]);
         PD.defC[az][bz]=NULL;
         if (PD.defD[az][bz]!=NULL) free(PD.defD[az][bz]);
         PD.defD[az][bz]=NULL;
         
         if (PD.entrysA[az][bz]!=NULL) free(PD.entrysA[az][bz]);
         PD.entrysA[az][bz]=NULL;
         if (PD.entrysB[az][bz]!=NULL) free(PD.entrysB[az][bz]);
         PD.entrysB[az][bz]=NULL;
         if (PD.entrysC[az][bz]!=NULL) free(PD.entrysC[az][bz]);
         PD.entrysC[az][bz]=NULL;
         if (PD.entrysD[az][bz]!=NULL) free(PD.entrysD[az][bz]);
         PD.entrysD[az][bz]=NULL;
         
         if (PD.wentrysA[az][bz]!=NULL) free(PD.wentrysA[az][bz]);
         PD.wentrysA[az][bz]=NULL;
         if (PD.wentrysB[az][bz]!=NULL) free(PD.wentrysB[az][bz]);
         PD.wentrysB[az][bz]=NULL;
         if (PD.wentrysC[az][bz]!=NULL) free(PD.wentrysC[az][bz]);
         PD.wentrysC[az][bz]=NULL;
         if (PD.wentrysD[az][bz]!=NULL) free(PD.wentrysD[az][bz]);
         PD.wentrysD[az][bz]=NULL;
      }

      PD.countA[az]=-1;
      PD.countB[az]=-1;
      PD.countC[az]=-1;
      PD.countD[az]=-1;
      
      PD.tabA[az]=0;
      PD.tabB[az]=0;
      PD.tabC[az]=0;
      PD.tabD[az]=0;
   }
   pdCount=-1;

   return;
}

/* ----- SET WIDGET DATA ----- */

/* Add Widget Counter */
int xwAddWCount(void)
{
   if (wdCount<maxwidgets)
   {
      wdCount++;
      return(wdCount);
   }
   else
   {
      return(-1);
   }
}

/* Add Widget */
void xwAddWidget(int wd,char *ID)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.ID[wd]==NULL)
      {
         WD.ID[wd] = (char*) malloc(strlen(ID)+1);
      }
      else
      {
         WD.ID[wd] = (char*) realloc(WD.ID[wd],strlen(ID)+1);
      }
      if (WD.ID[wd]!=NULL) strcpy(WD.ID[wd],ID);
   }
   return;
}

/* Set Script Priority */
void xwSetWidgetPri(int wd,int pri)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      WD.pri[wd]=pri;
   }
   return;
}

/* Set Widget Type */
void xwSetWidgetType(int wd,char *type)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.type[wd]==NULL)
      {
         WD.type[wd] = (char*) malloc(strlen(type)+1);
      }
      else
      {
         WD.type[wd] = (char*) realloc(WD.type[wd],strlen(type)+1);
      }
      if (WD.type[wd]!=NULL) strcpy(WD.type[wd],type);
   }
   return;
}

/* Set Widget Tab */
void xwSetWidgetTab(int wd,int flag)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      WD.tab[wd]=flag;
   }
   return;
}

/* Set Widget Name */
void xwSetWidgetName(int wd,char *name)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
   if (WD.name[wd]==NULL)
      {
         WD.name[wd] = (char*) malloc(strlen(name)+1);
      }
      else
      {
         WD.name[wd] = (char*) realloc(WD.name[wd],strlen(name)+1);
      }
      if (WD.name[wd]!=NULL) strcpy(WD.name[wd],name);
   }
   return;
}

/* Set Widget Option */
void xwSetWidgetOption(int wd,char *option)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.option[wd]==NULL)
      {
         WD.option[wd] = (char*) malloc(strlen(option)+1);
      }
      else
      {
         WD.option[wd] = (char*) realloc(WD.option[wd],strlen(option)+1);
      }
      if (WD.option[wd]!=NULL) strcpy(WD.option[wd],option);
   }
   return;
}

/* Set Widget Default */
void xwSetWidgetDefault(int wd,char *def)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.def[wd]==NULL)
      {
         WD.def[wd] = (char*) malloc(strlen(def)+1);
      }
      else
      {
         WD.def[wd] = (char*) realloc(WD.def[wd],strlen(def)+1);
      }
      if (WD.def[wd]!=NULL) strcpy(WD.def[wd],def);
   }
   return;
}

/* Modify Widget Default */
void xwModifyWidgetDefault(int idx,char *def)
{
   if ( (idx>-1) && (idx<maxwidgets) )
   {
      if (WD.def[idx]==NULL)
      {
         WD.def[idx] = (char*) malloc(strlen(def)+1);
      }
      else
      {
         WD.def[idx] = (char*) realloc(WD.def[idx],strlen(def)+1);
      }
      if (WD.def[idx]!=NULL) strcpy(WD.def[idx],def);
   }
   return;
}

/* Set Widget MinValue */
void xwSetWidgetMinVal(int wd,float value)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      WD.minval[wd]=value;
   }
   return;
}

/* Set Widget MaxValue */
void xwSetWidgetMaxVal(int wd,float value)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      WD.maxval[wd]=value;
   }
   return;
}

/* Set Widget Step Value */
void xwSetWidgetStep(int wd,float value)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      WD.step[wd]=value;
   }
   return;
}

/* Set Widget Entrys */
void xwSetWidgetEntrys(int wd,char *entrys)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.entrys[wd]==NULL)
      {
         WD.entrys[wd] = (char*) malloc(strlen(entrys)+1);
      }
      else
      {
         WD.entrys[wd] = (char*) realloc(WD.entrys[wd],strlen(entrys)+1);
      }
      if (WD.entrys[wd]!=NULL) strcpy(WD.entrys[wd],entrys);
   }
   return;
}

/* Set Widget WEntrys */
void xwSetWidgetWEntrys(int wd,char *wentrys)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.wentrys[wd]==NULL)
      {
         WD.wentrys[wd] = (char*) malloc(strlen(wentrys)+1);
      }
      else
      {
         WD.wentrys[wd] = (char*) realloc(WD.wentrys[wd],strlen(wentrys)+1);
      }
      if (WD.wentrys[wd]!=NULL) strcpy(WD.wentrys[wd],wentrys);
   }
   return;
}

/* Set Widget Variable */
void xwSetWidgetVariable(int wd,char *variable)
{
   if ( (wd>-1) && (wd<maxwidgets) )
   {
      if (WD.variable[wd]==NULL)
      {
         WD.variable[wd] = (char*) malloc(strlen(variable)+1);
      }
      else
      {
         WD.variable[wd] = (char*) realloc(WD.variable[wd],strlen(variable)+1);
      }
      if (WD.variable[wd]!=NULL) strcpy(WD.variable[wd],variable);
   }
   return;
}

/* ----- GET WIDGET DATAS ----- */

/* Get Max Widget */
int xwGetWidgetCount(void)
{
   return(wdCount);
}

/* Get Widget ID */
char *xwGetWidgetID(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.ID[idx]!=NULL) ) return(WD.ID[idx]);
   return("");
}

/* Get Widget Index */
int xwGetWidgetIndex(char *ID)
{
   int            az;
   
   if (wdCount>-1)
   {
      for (az=0 ; az<=wdCount ; az++)
      {
         if (WD.ID[az]!=NULL)
         {
            if (strcmp(WD.ID[az],ID) == 0) return(az); 
         }
      }
   }
   
   return(-1);
}

/* Get Script Priority */
int xwGetWidgetPri(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) ) return(WD.pri[idx]);
   return(-1);
}

/* Get Widget Type */
char *xwGetWidgetType(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.type[idx]!=NULL) ) return(WD.type[idx]);
   return("");
}

/* Get Widget Tab */
int xwGetWidgetTab(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.tab[idx]!=0) ) return(0);
   return(-1);
}

/* Get Widget Name */
char *xwGetWidgetName(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.name[idx]!=NULL) ) return(WD.name[idx]);
   return("");
}

/* Get Widget Option */
char *xwGetWidgetOption(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.option[idx]!=NULL) ) return(WD.option[idx]);
   return("");
}

/* Get Widget Default */
char *xwGetWidgetDefault(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.def[idx]!=NULL) ) return(WD.def[idx]);
   return("");
}

/* Get Widget MinValue */
float xwGetWidgetMinVal(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) ) return(WD.minval[idx]);
   return(0);
}

/* Get Widget MaxValue */
float xwGetWidgetMaxVal(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) ) return(WD.maxval[idx]);
   return(0);
}

/* Get Widget Step Value */
float xwGetWidgetStep(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) ) return(WD.step[idx]);
   return(0);
}

/* Get Widget Entrys */
char *xwGetWidgetEntrys(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.entrys[idx]!=NULL) ) return(WD.entrys[idx]);
   return("");
}

/* Get Widget WEntrys */
char *xwGetWidgetWEntrys(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.wentrys[idx]!=NULL) ) return(WD.wentrys[idx]);
   return("");
};

/* Get Widget Variable */
char *xwGetWidgetVariable(int idx)
{
   if ( (idx>-1) && (idx<=wdCount) && (WD.variable[idx]!=NULL) ) return(WD.variable[idx]);
   return("");
};

/* Printer Data Manipulation */

/* ----- SET PRINTER DATA ----- */

/* Add Printer */
void xwAddPrinter(char *name)
{
   if (pdCount<maxprinter)
   {
      pdCount++;

      if (PD.name[pdCount]==NULL)
      {
         PD.name[pdCount] = (char*) malloc(strlen(name)+1);
      }
      else
      {
         PD.name[pdCount] = (char*) realloc(PD.name[pdCount],strlen(name)+1);
      }
      if (PD.name[pdCount]!=NULL) strcpy(PD.name[pdCount],name);
   }
   return;
}

/* Clone Printer */
void xwClonePrinter(char *name)
{
   int            idx;
   int            count;
   int            gui;
   
   
   idx=xwGetPrinterNumber(name);
   if (idx>-1)
   {
      /* Clone Print Script */
      xwSetPrinterScript(xwGetPrinterScript(idx));
      
      /* Clone GUI Name */
      xwSetPrinterGUIName(1,xwGetPrinterGUI(1,idx));
      xwSetPrinterGUIName(2,xwGetPrinterGUI(2,idx));
      xwSetPrinterGUIName(3,xwGetPrinterGUI(3,idx));
      xwSetPrinterGUIName(4,xwGetPrinterGUI(4,idx));
   
      /* Clone TAB Flag */
      xwSetPrinterGUITab(1,xwGetPrinterGUITab(1,idx));
      xwSetPrinterGUITab(2,xwGetPrinterGUITab(2,idx));
      xwSetPrinterGUITab(3,xwGetPrinterGUITab(3,idx));
      xwSetPrinterGUITab(4,xwGetPrinterGUITab(4,idx));

      for (gui=1 ; gui<=4 ; gui++)
      {
         for (count=0 ; count<=xwGetPrinterWCount(gui,idx) ; count++)
         {
            xwAddPrinterWidget(gui,xwGetPrinterWidget(gui,idx,count));
         }
      }
   }
   return;
}

/* Set Printer Scripts */
void xwSetPrinterScript(char *script)
{
   if ( (pdCount>-1) && (pdCount<maxprinter) )
   {
      if (PD.script[pdCount]==NULL)
      {
         PD.script[pdCount] = (char*) malloc(strlen(script)+1);
      }
      else
      {
         PD.script[pdCount] = (char*) realloc(PD.script[pdCount],strlen(script)+1);
      }
      if (PD.script[pdCount]!=NULL) strcpy(PD.script[pdCount],script);
   }
   return;
}

/* Hide Printer */
void xwSetHidePrinter(void)
{
   if ( (pdCount>-1) && (pdCount<maxprinter) )
   {
      PD.hide[pdCount]=1;
   }
   return;
}

/* Set Printer GUI Name */
void xwSetPrinterGUIName(int nr,char *name)
{
   if (strlen(name)>0)
   {
      if (nr==1)
      {
         if (PD.guiAName[pdCount]==NULL)
         {
            PD.guiAName[pdCount] = (char*) malloc(strlen(name)+1);
         }
         else
         {
            PD.guiAName[pdCount] = (char*) realloc(PD.guiAName[pdCount],strlen(name)+1);
         }
         if (PD.guiAName[pdCount]!=NULL) strcpy(PD.guiAName[pdCount],name);
      }
      else if (nr==2)
      {
         if (PD.guiBName[pdCount]==NULL)
         {
            PD.guiBName[pdCount] = (char*) malloc(strlen(name)+1);
         }
         else
         {
            PD.guiBName[pdCount] = (char*) realloc(PD.guiBName[pdCount],strlen(name)+1);
         }
         if (PD.guiBName[pdCount]!=NULL) strcpy(PD.guiBName[pdCount],name);
      }
      else if (nr==3)
      {
         if (PD.guiCName[pdCount]==NULL)
         {
            PD.guiCName[pdCount] = (char*) malloc(strlen(name)+1);
         }
         else
         {
            PD.guiCName[pdCount] = (char*) realloc(PD.guiCName[pdCount],strlen(name)+1);
         }
         if (PD.guiCName[pdCount]!=NULL) strcpy(PD.guiCName[pdCount],name);
      }
      else if (nr==4)
      {
         if (PD.guiDName[pdCount]==NULL)
         {
            PD.guiDName[pdCount] = (char*) malloc(strlen(name)+1);
         }
         else
         {
            PD.guiDName[pdCount] = (char*) realloc(PD.guiDName[pdCount],strlen(name)+1);
         }
         if (PD.guiDName[pdCount]!=NULL) strcpy(PD.guiDName[pdCount],name);
      }
   }
   return;
}

/* Set Printer Tab */
void xwSetPrinterGUITab(int nr,int pos)
{
   if ( (pdCount>-1) && (pdCount<maxprinter) )
   {
      if (nr==1) PD.tabA[pdCount]=pos;
      else if (nr==2) PD.tabB[pdCount]=pos;
      else if (nr==3) PD.tabC[pdCount]=pos;
      else if (nr==4) PD.tabD[pdCount]=pos;
   }
   return;
}

/* Add Printer Widget */
void xwAddPrinterWidget(int nr,char *name)
{
   if ( (pdCount>-1) && (pdCount<maxprinter) )
   {
      if (nr==1)
      {
         PD.countA[pdCount]++;
         if ( (PD.countA[pdCount]>-1) && (PD.countA[pdCount]<20) )
         {
            if (PD.guiA[pdCount][PD.countA[pdCount]]==NULL)
            {
               PD.guiA[pdCount][PD.countA[pdCount]] = (char*) malloc(strlen(name)+1);
            }
            else
            {
               PD.guiA[pdCount][PD.countA[pdCount]] = (char*) realloc(PD.guiA[pdCount][PD.countA[pdCount]],strlen(name)+1);
            }
            if (PD.guiA[pdCount][PD.countA[pdCount]]!=NULL) strcpy(PD.guiA[pdCount][PD.countA[pdCount]],name);
         }
      }
      else if (nr==2)
      {
         PD.countB[pdCount]++;
         if ( (PD.countB[pdCount]>-1) && (PD.countB[pdCount]<20) )
         {
            if (PD.guiB[pdCount][PD.countB[pdCount]]==NULL)
            {
               PD.guiB[pdCount][PD.countB[pdCount]] = (char*) malloc(strlen(name)+1);
            }
            else
            {
               PD.guiB[pdCount][PD.countB[pdCount]] = (char*) realloc(PD.guiB[pdCount][PD.countB[pdCount]],strlen(name)+1);
            }
            if (PD.guiB[pdCount][PD.countB[pdCount]]!=NULL) strcpy(PD.guiB[pdCount][PD.countB[pdCount]],name);
         }
      }
      else if (nr==3)
      {
         PD.countC[pdCount]++;
         if ( (PD.countC[pdCount]>-1) && (PD.countC[pdCount]<20) )
         {
            if (PD.guiC[pdCount][PD.countC[pdCount]]==NULL)
            {
               PD.guiC[pdCount][PD.countC[pdCount]] = (char*) malloc(strlen(name)+1);
            }
            else
            {
               PD.guiC[pdCount][PD.countC[pdCount]] = (char*) realloc(PD.guiC[pdCount][PD.countC[pdCount]],strlen(name)+1);
            }
            if (PD.guiC[pdCount][PD.countC[pdCount]]!=NULL) strcpy(PD.guiC[pdCount][PD.countC[pdCount]],name);
         }
      }
      else if (nr==4)
      {
         PD.countD[pdCount]++;
         if ( (PD.countD[pdCount]>-1) && (PD.countD[pdCount]<20) )
         {
            if (PD.guiD[pdCount][PD.countD[pdCount]]==NULL)
            {
               PD.guiD[pdCount][PD.countD[pdCount]] = (char*) malloc(strlen(name)+1);
            }
            else
            {
               PD.guiD[pdCount][PD.countD[pdCount]] = (char*) realloc(PD.guiD[pdCount][PD.countD[pdCount]],strlen(name)+1);
            }
            if (PD.guiD[pdCount][PD.countD[pdCount]]!=NULL) strcpy(PD.guiD[pdCount][PD.countD[pdCount]],name);
         }
      }
   }
   return;
}

/* Set Printer Widget Default */
void xwSetPrinterWidgetDefault(char *widget,char *def)
{
   int            az;

   if ( (pdCount>-1) && (pdCount<maxprinter) && (strlen(widget)>0) && (strlen(def)>0) )
   {   
      for (az=0 ; az<20 ; az++)
      { 
         /* Search Widget */
         if ( (PD.guiA[pdCount][az]!=NULL) && (strcmp(PD.guiA[pdCount][az],widget) == 0) )
         {
            if (PD.defA[pdCount][az]==NULL)
            {
               PD.defA[pdCount][az] = (char*) malloc(strlen(def)+1);
            }
            else
            {
               PD.defA[pdCount][az] = (char*) realloc(PD.defA[pdCount][az],strlen(def)+1);
            }
            if (PD.defA[pdCount][az]!=NULL) strcpy(PD.defA[pdCount][az],def);
         }
         
         /* Search Widget */
         if ( (PD.guiB[pdCount][az]!=NULL) && (strcmp(PD.guiB[pdCount][az],widget) == 0) )
         {
            if (PD.defB[pdCount][az]==NULL)
            {
               PD.defB[pdCount][az] = (char*) malloc(strlen(def)+1);
            }
            else
            {
               PD.defB[pdCount][az] = (char*) realloc(PD.defB[pdCount][az],strlen(def)+1);
            }
            if (PD.defB[pdCount][az]!=NULL) strcpy(PD.defB[pdCount][az],def);
         }
         
         /* Search Widget */
         if ( (PD.guiC[pdCount][az]!=NULL) && (strcmp(PD.guiC[pdCount][az],widget) == 0) )
         {
            if (PD.defC[pdCount][az]==NULL)
            {
               PD.defC[pdCount][az] = (char*) malloc(strlen(def)+1);
            }
            else
            {
               PD.defC[pdCount][az] = (char*) realloc(PD.defC[pdCount][az],strlen(def)+1);
            }
            if (PD.defC[pdCount][az]!=NULL) strcpy(PD.defC[pdCount][az],def);
         }
         
         /* Search Widget */
         if ( (PD.guiD[pdCount][az]!=NULL) && (strcmp(PD.guiD[pdCount][az],widget) == 0) )
         {
            if (PD.defD[pdCount][az]==NULL)
            {
               PD.defD[pdCount][az] = (char*) malloc(strlen(def)+1);
            }
            else
            {
               PD.defD[pdCount][az] = (char*) realloc(PD.defD[pdCount][az],strlen(def)+1);
            }
            if (PD.defD[pdCount][az]!=NULL) strcpy(PD.defD[pdCount][az],def);
         }         
         
      }
   }

   return;
}

/* Set Printer Widget Entrys */
void xwSetPrinterWidgetEntrys(char *widget,char *entrys)
{
   int            az;

   if ( (pdCount>-1) && (pdCount<maxprinter) && (strlen(widget)>0) && (strlen(entrys)>0) )
   {   
      for (az=0 ; az<20 ; az++)
      { 
         /* Search Widget */
         if ( (PD.guiA[pdCount][az]!=NULL) && (strcmp(PD.guiA[pdCount][az],widget) == 0) )
         {
            if (PD.entrysA[pdCount][az]==NULL)
            {
               PD.entrysA[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.entrysA[pdCount][az] = (char*) realloc(PD.entrysA[pdCount][az],strlen(entrys)+1);
            }
            if (PD.entrysA[pdCount][az]!=NULL) strcpy(PD.entrysA[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiB[pdCount][az]!=NULL) && (strcmp(PD.guiB[pdCount][az],widget) == 0) )
         {
            if (PD.entrysB[pdCount][az]==NULL)
            {
               PD.entrysB[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.entrysB[pdCount][az] = (char*) realloc(PD.entrysB[pdCount][az],strlen(entrys)+1);
            }
            if (PD.entrysB[pdCount][az]!=NULL) strcpy(PD.entrysB[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiC[pdCount][az]!=NULL) && (strcmp(PD.guiC[pdCount][az],widget) == 0) )
         {
            if (PD.entrysC[pdCount][az]==NULL)
            {
               PD.entrysC[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.entrysC[pdCount][az] = (char*) realloc(PD.entrysC[pdCount][az],strlen(entrys)+1);
            }
            if (PD.entrysC[pdCount][az]!=NULL) strcpy(PD.entrysC[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiD[pdCount][az]!=NULL) && (strcmp(PD.guiD[pdCount][az],widget) == 0) )
         {
            if (PD.entrysD[pdCount][az]==NULL)
            {
               PD.entrysD[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.entrysD[pdCount][az] = (char*) realloc(PD.entrysD[pdCount][az],strlen(entrys)+1);
            }
            if (PD.entrysD[pdCount][az]!=NULL) strcpy(PD.entrysD[pdCount][az],entrys);
         }         
         
      }
   }

   return;
}

/* Set Printer Widget WEntrys */
void xwSetPrinterWidgetWEntrys(char *widget,char *entrys)
{
   int            az;

   if ( (pdCount>-1) && (pdCount<maxprinter) && (strlen(widget)>0) && (strlen(entrys)>0) )
   {   
      for (az=0 ; az<20 ; az++)
      { 
         /* Search Widget */
         if ( (PD.guiA[pdCount][az]!=NULL) && (strcmp(PD.guiA[pdCount][az],widget) == 0) )
         {
            if (PD.wentrysA[pdCount][az]==NULL)
            {
               PD.wentrysA[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.wentrysA[pdCount][az] = (char*) realloc(PD.wentrysA[pdCount][az],strlen(entrys)+1);
            }
            if (PD.wentrysA[pdCount][az]!=NULL) strcpy(PD.wentrysA[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiB[pdCount][az]!=NULL) && (strcmp(PD.guiB[pdCount][az],widget) == 0) )
         {
            if (PD.wentrysB[pdCount][az]==NULL)
            {
               PD.wentrysB[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.wentrysB[pdCount][az] = (char*) realloc(PD.wentrysB[pdCount][az],strlen(entrys)+1);
            }
            if (PD.wentrysB[pdCount][az]!=NULL) strcpy(PD.wentrysB[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiC[pdCount][az]!=NULL) && (strcmp(PD.guiC[pdCount][az],widget) == 0) )
         {
            if (PD.wentrysC[pdCount][az]==NULL)
            {
               PD.wentrysC[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.wentrysC[pdCount][az] = (char*) realloc(PD.wentrysC[pdCount][az],strlen(entrys)+1);
            }
            if (PD.wentrysC[pdCount][az]!=NULL) strcpy(PD.wentrysC[pdCount][az],entrys);
         }
         
         /* Search Widget */
         if ( (PD.guiD[pdCount][az]!=NULL) && (strcmp(PD.guiD[pdCount][az],widget) == 0) )
         {
            if (PD.wentrysD[pdCount][az]==NULL)
            {
               PD.wentrysD[pdCount][az] = (char*) malloc(strlen(entrys)+1);
            }
            else
            {
               PD.wentrysD[pdCount][az] = (char*) realloc(PD.wentrysD[pdCount][az],strlen(entrys)+1);
            }
            if (PD.wentrysD[pdCount][az]!=NULL) strcpy(PD.wentrysD[pdCount][az],entrys);
         }         
         
      }
   }

   return;
}

/* ----- GET PRINTER DATAS ----- */

/* Get Max Printer */
int xwGetPrinterCount(void)
{
   return(pdCount);
}

/* Get Printer Widget Count */
int xwGetPrinterWCount(int nr,int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if (nr==1) return(PD.countA[idx]);
      if (nr==2) return(PD.countB[idx]);
      if (nr==3) return(PD.countC[idx]);
      if (nr==4) return(PD.countD[idx]);
   }

   return(-1);
}

/* Get Printer Name */
char *xwGetPrinterName(int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if (PD.name[idx]!=NULL) return(PD.name[idx]);
   }
   return("");
}

/* Get Printer Script */
char *xwGetPrinterScript(int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if (PD.script[idx]!=NULL) return(PD.script[idx]);
   }
   return("");
}

/* Get Hide Printer */
int xwGetHidePrinter(int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      return(PD.hide[idx]);
   }
   return(0);
}

/* Get Printer GUI */
char *xwGetPrinterGUI(int nr,int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if ( (nr==1) && (PD.guiAName[idx]!=NULL) ) return(PD.guiAName[idx]);
      if ( (nr==2) && (PD.guiBName[idx]!=NULL) ) return(PD.guiBName[idx]);
      if ( (nr==3) && (PD.guiCName[idx]!=NULL) ) return(PD.guiCName[idx]);
      if ( (nr==4) && (PD.guiDName[idx]!=NULL) ) return(PD.guiDName[idx]);
   }
   return("");
}

/* Get Printer GUI Tab */
int xwGetPrinterGUITab(int nr,int idx)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if (nr==1) return(PD.tabA[idx]);
      else if (nr==2) return(PD.tabB[idx]);
      else if (nr==3) return(PD.tabC[idx]);
      else if (nr==4) return(PD.tabD[idx]);
   }
   return(0);
}

/* Get Printer Widget */
char *xwGetPrinterWidget(int nr,int idx,int pos)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if ( (nr==1) && (PD.guiA[idx][pos]!=NULL) ) return(PD.guiA[idx][pos]);
      if ( (nr==2) && (PD.guiB[idx][pos]!=NULL) ) return(PD.guiB[idx][pos]);
      if ( (nr==3) && (PD.guiC[idx][pos]!=NULL) ) return(PD.guiC[idx][pos]);
      if ( (nr==4) && (PD.guiD[idx][pos]!=NULL) ) return(PD.guiD[idx][pos]);
   }
   return("");
}

/* Get Printer Widget Index */
int xwGetPrinterWIndex(int nr,int idx,int pos)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if ( (nr==1) && (PD.idxA[idx][pos]>-1) ) return(PD.idxA[idx][pos]);
      if ( (nr==2) && (PD.idxB[idx][pos]>-1) ) return(PD.idxB[idx][pos]);
      if ( (nr==3) && (PD.idxC[idx][pos]>-1) ) return(PD.idxC[idx][pos]);
      if ( (nr==4) && (PD.idxD[idx][pos]>-1) ) return(PD.idxD[idx][pos]);
   }
   return(-1);
}

/* Get Printer Number */
int xwGetPrinterNumber(char *printer)
{
   int            bz;
   
   if (printer!=NULL)
   {
      /* Search Printer */
      for (bz=0 ; bz<=pdCount ; bz++)
      {
         if ( (PD.name[bz]!=NULL) && (strcmp(printer,PD.name[bz]) == 0) )
         {
            return(bz);
         }
      }

   }
   return(-1);
}

/* Get Printer Widget Entrys */
char *xwGetPrinterWidgetEntrys(int nr,int idx,int pos)
{
   if ( (idx>-1) && (idx<maxprinter) )
   {
      if ( (nr==1) && (PD.entrysA[idx][pos]!=NULL) ) return(PD.entrysA[idx][pos]);
      if ( (nr==2) && (PD.entrysB[idx][pos]!=NULL) ) return(PD.entrysB[idx][pos]);
      if ( (nr==3) && (PD.entrysC[idx][pos]!=NULL) ) return(PD.entrysC[idx][pos]);
      if ( (nr==4) && (PD.entrysD[idx][pos]!=NULL) ) return(PD.entrysD[idx][pos]);
   }
   return(NULL);
}

/* Get Printer Widget Entrys */
char *xwGetPrinterWidgetWEntrys(int nr,int idx,int pos)
{
   if ( (idx>-1) && (idx<=maxprinter) )
   {
      if ( (nr==1) && (PD.wentrysA[idx][pos]!=NULL) ) return(PD.wentrysA[idx][pos]);
      if ( (nr==2) && (PD.wentrysB[idx][pos]!=NULL) ) return(PD.wentrysB[idx][pos]);
      if ( (nr==3) && (PD.wentrysC[idx][pos]!=NULL) ) return(PD.wentrysC[idx][pos]);
      if ( (nr==4) && (PD.wentrysD[idx][pos]!=NULL) ) return(PD.wentrysD[idx][pos]);
   }
   return(NULL);
}

/* ----- MISC ROUTINES ----- */

/* Create Printer Index */
void xwCreatePrinterIndex(void)
{
   int            bz;
   int            widget;
   int            printer;

   /* Printer Loop */
   for (printer=0 ; printer<=pdCount ; printer++)
   {
      /* Widget Loop */
      for (widget=0 ; widget<=20 ; widget++)
      {
         PD.idxA[printer][widget]=-1;
         PD.idxB[printer][widget]=-1;
         PD.idxC[printer][widget]=-1;
         PD.idxD[printer][widget]=-1;

         for (bz=0 ; bz<=wdCount ; bz++)
         {
            if ( (PD.guiA[printer][widget]!=NULL) && (WD.ID[bz]!=NULL) && (strcmp(PD.guiA[printer][widget],WD.ID[bz]) == 0) )
            {
               PD.idxA[printer][widget]=bz;
            }
            else if ( (PD.guiB[printer][widget]!=NULL) && (WD.ID[bz]!=NULL) && (strcmp(PD.guiB[printer][widget],WD.ID[bz]) == 0) )
            {
               PD.idxB[printer][widget]=bz;
            }
            else if ( (PD.guiC[printer][widget]!=NULL) && (WD.ID[bz]!=NULL) && (strcmp(PD.guiC[printer][widget],WD.ID[bz]) == 0) )
            {
               PD.idxC[printer][widget]=bz;
            }
            else if ( (PD.guiD[printer][widget]!=NULL) && (WD.ID[bz]!=NULL) && (strcmp(PD.guiD[printer][widget],WD.ID[bz]) == 0) )
            {
               PD.idxD[printer][widget]=bz;
            }
         }
      }
   }

   return;
}

/* Set Defaults */
void xwSetDefaults(int idx)
{
   int            az;

   if ( (idx>-1) && (idx<=pdCount) )
   {
      /* Delete all Variables */
      xwDInitVarDef();

      /* Widget Loop */
      for (az=0 ; az<=20 ; az++)
      {
         /* Widget Index */
         if (PD.idxA[idx][az]>-1)
         {
            /* Widget Variable */
            if (WD.variable[PD.idxA[idx][az]]!=NULL)
            {
               /* Printer Default */
               if (PD.defA[idx][az]!=NULL)
               {
                  xwSetVarDef(WD.variable[PD.idxA[idx][az]],PD.defA[idx][az]);
               }
               else
               {
                  /* Widget Default */
                  if (WD.def[PD.idxA[idx][az]]!=NULL)
                  {
                     xwSetVarDef(WD.variable[PD.idxA[idx][az]],WD.def[PD.idxA[idx][az]]);
                  }
                  else
                  {
                     xwSetVarDef(WD.variable[PD.idxA[idx][az]],"");
                  }
               }
            }
         }

         /* Widget Index */
         if (PD.idxB[idx][az]>-1)
         {
            /* Widget Variable */
            if (WD.variable[PD.idxB[idx][az]]!=NULL)
            {
               /* Printer default */
               if (PD.defB[idx][az]!=NULL)
               {
                  xwSetVarDef(WD.variable[PD.idxB[idx][az]],PD.defB[idx][az]);
               }
               else
               {
                  /* Widget Default */
                  if (WD.def[PD.idxB[idx][az]]!=NULL)
                  {
                     xwSetVarDef(WD.variable[PD.idxB[idx][az]],WD.def[PD.idxB[idx][az]]);
                  }
                  else
                  {
                     xwSetVarDef(WD.variable[PD.idxB[idx][az]],"");
                  }
               }
            }
         }

         /* Widget Index */
         if (PD.idxC[idx][az]>-1)
         {
            /* Widget Variable */
            if (WD.variable[PD.idxC[idx][az]]!=NULL)
            {
               /* Printer default */
               if (PD.defC[idx][az]!=NULL)
               {
                  xwSetVarDef(WD.variable[PD.idxC[idx][az]],PD.defC[idx][az]);
               }
               else
               {
                  /* Widget Default */            
                  if (WD.def[PD.idxC[idx][az]]!=NULL)
                  {
                     xwSetVarDef(WD.variable[PD.idxC[idx][az]],WD.def[PD.idxC[idx][az]]);
                  }
                  else
                  {
                     xwSetVarDef(WD.variable[PD.idxC[idx][az]],"");
                  }
               }
            }
         }

         /* Widget Index */
         if (PD.idxD[idx][az]>-1)
         {
            /* Widget Variable */
            if (WD.variable[PD.idxD[idx][az]]!=NULL)
            {
               /* Printer default */
               if (PD.defD[idx][az]!=NULL)
               {
                  xwSetVarDef(WD.variable[PD.idxD[idx][az]],PD.defD[idx][az]);
               }
               else
               {
                  /* Widget Default */
                  if (WD.def[PD.idxD[idx][az]]!=NULL)
                  {
                     xwSetVarDef(WD.variable[PD.idxD[idx][az]],WD.def[PD.idxD[idx][az]]);
                  }
                  else
                  {
                     xwSetVarDef(WD.variable[PD.idxD[idx][az]],"");
                  }
               }
            }
         }

      }
   }

   return;
}

/* Save Setting's */
void xwSavePrinterSetting(char *driver,char *printer,char *file,int idx)
{
   char           bufferA[1024];
   char           bufferB[1024];
   int            az;
   FILE           *fh;

   if ( (strlen(driver)>0) && (strlen(printer)>0) && (strlen(file)>0) && (idx>-1) )
   {
      /* Create Driver Folder */
      strcpy(bufferA,strrchr(driver,'/')+1);
      for (az=0 ; az<strlen(bufferA) ; az++)
      {
         if (bufferA[az]==0x20) bufferA[az]='-';
      }
      /*
      strcpy(bufferB,xwGetFile("xwGUI2/",""));
      strcat(bufferB,bufferA);
      */
      
      strcpy(bufferB,xwGetFile("",bufferA));
      
      mkdir(bufferB,S_IRWXU);

      /* Create Printer Folder */
      strcpy(bufferA,printer);
      for (az=0 ; az<strlen(bufferA) ; az++)
      {
         if (bufferA[az]==0x20) bufferA[az]='-';
      }
      strcat(bufferB,"/");
      strcat(bufferB,bufferA);
      mkdir(bufferB,S_IRWXU);

      /* Create Setting Path */
      strcpy(bufferA,file);
      for (az=0 ; az<strlen(bufferA) ; az++)
      {
         if (bufferA[az]==0x20) bufferA[az]='-';
      }
      strcat(bufferB,"/");
      strcat(bufferB,bufferA);

      /* Create Setting File */
      fh=fopen(bufferB,"w");
      if (fh!= NULL)
      {
         fputs("# xwGUI Setting File\n",fh);
         fputs("# written by xwGUI\n",fh);
         fputs("# (c) by Stefan Kraus\n",fh);
         fputs("# License: GPL\n\n",fh);

         fputs("SETTING\n",fh);

         /* Widget Loop */
         for (az=0 ; az<=19 ; az++)
         {
            /* Widget Index */
            if (PD.idxA[idx][az]>-1)
            {
               /* Widget Variable */
               if (WD.variable[PD.idxA[idx][az]]!=NULL)
               {
                  fputs(" DEF \"",fh);
                  fputs(WD.variable[PD.idxA[idx][az]],fh);
                  fputs("\" \"",fh);
                  fputs(xwGetVarDef(WD.variable[PD.idxA[idx][az]]),fh);
                  fputs("\"\n",fh);
               }
            }
            /* Widget Index */
            if (PD.idxB[idx][az]>-1)
            {
               /* Widget Variable */
               if (WD.variable[PD.idxB[idx][az]]!=NULL)
               {
                  fputs(" DEF \"",fh);
                  fputs(WD.variable[PD.idxB[idx][az]],fh);
                  fputs("\" \"",fh);
                  fputs(xwGetVarDef(WD.variable[PD.idxB[idx][az]]),fh);
                  fputs("\"\n",fh);
               }
            }
            /* Widget Index */
            if (PD.idxC[idx][az]>-1)
            {
               /* Widget Variable */
               if (WD.variable[PD.idxC[idx][az]]!=NULL)
               {
                  fputs(" DEF \"",fh);
                  fputs(WD.variable[PD.idxC[idx][az]],fh);
                  fputs("\" \"",fh);
                  fputs(xwGetVarDef(WD.variable[PD.idxC[idx][az]]),fh);
                  fputs("\"\n",fh);
               }
            }
            /* Widget Index */
            if (PD.idxD[idx][az]>-1)
            {
               /* Widget Variable */
               if (WD.variable[PD.idxD[idx][az]]!=NULL)
               {
                  fputs(" DEF \"",fh);
                  fputs(WD.variable[PD.idxD[idx][az]],fh);
                  fputs("\" \"",fh);
                  fputs(xwGetVarDef(WD.variable[PD.idxD[idx][az]]),fh);
                  fputs("\"\n",fh);
               }

            }
         }

         fputs("END\n",fh);

         fclose(fh);
      }
   }

   return;
}

/* Load Setting */
void xwLoadPrinterSetting(char *driver,char *printer,char *file)
{
   char           bufferA[1024];
   int            az;
   FILE           *fh;

   if ( (strlen(driver)>0) && (strlen(printer)>0) && (strlen(file)>0) )
   {
      /*
      strcpy(bufferA,xwGetFile("xwGUI2/",""));
      strcat(bufferA,strrchr(driver,'/')+1);
      */
      strcpy(bufferA,xwGetFile("",strrchr(driver,'/')+1));
      strcat(bufferA,"/");
      strcat(bufferA,printer);
      strcat(bufferA,"/");
      strcat(bufferA,file);
      for (az=0 ; az<strlen(bufferA) ; az++)
      {
         if (bufferA[az]==0x20) bufferA[az]='-';
      }

      /* Check Setting File */
      fh=fopen(bufferA,"r");
      if (fh!= NULL)
      {
         fclose(fh);
         xwInterpret(bufferA,NULL);
      }
   }

   return;
}

/* Create Printer Script */
void xwCreatePrinterScript(void)
{
   int            guiNr;         /* GUI 1-4 */
   int            widgetNr;      /* Widgets 0-19 */
   int            WN,GN;
   int            wMaxNr;        /* Widget Max Nr. */
   int            idx;           /* WidgetIndex */
   int            lineNr;
   int            ready;

   int            priActual;     /* Actual Priority */
   int            priMin;        /* Minimal Priority */
   int            priMax;        /* Maximal Priority */

   FILE           *fh;
   char           prtScript[1024];

   idx=xwGetPrinterNumber( xwGetPrefPrinter() );
   if (idx>-1)
   {
      strcpy(prtScript,xwGetFile("","working.script"));
      /* Create Setting File */
      fh=fopen(prtScript,"w");
      if (fh!= NULL)
      {
         if (PD.script[idx]!=NULL)
         {
            strcpy(prtScript,PD.script[idx]);
         }
         else
         {
            strcpy(prtScript,"");
         }
         priActual=-1;
         priMin=-1;
         priMax=999999;

         lineNr=1;

         ready=0;
         while ( ready!=-1)
         {
            for (guiNr=1 ; guiNr<=4 ; guiNr++)
            {
               if (guiNr==1) wMaxNr=PD.countA[idx];
               if (guiNr==2) wMaxNr=PD.countB[idx];
               if (guiNr==3) wMaxNr=PD.countC[idx];
               if (guiNr==4) wMaxNr=PD.countD[idx];

               for (widgetNr=0 ; widgetNr<=wMaxNr ; widgetNr++)
               {
                  /* Get Widget Nr. */
                  if (guiNr==1) priActual=WD.pri[PD.idxA[idx][widgetNr]];
                  if (guiNr==2) priActual=WD.pri[PD.idxB[idx][widgetNr]];
                  if (guiNr==3) priActual=WD.pri[PD.idxC[idx][widgetNr]];
                  if (guiNr==4) priActual=WD.pri[PD.idxD[idx][widgetNr]];

                  /*
                  printf("PriB %i > PriA %i > PriC %i\n",priB,priA,priC);
                  */
                  
                  /*
                  if (priActual==1300) printf("Actual Pri: %i\n",priActual);
                  */

                  if ( (priMin<priActual) && (priActual<priMax) )
                  {
                     /*
                     printf("Actual Pri: %i ( Min: %i Max: %i)\n",priActual,priMin,priMax);
                     */
                     priMax=priActual;
                     WN=widgetNr;
                     GN=guiNr;
                  }
               }
            }

           
            /*printf("Next Min Value: %i\n",priMax);*/           

            if (priMax==999999)
            {
               ready=-1;
               if (strlen(prtScript)>0)
                {
                   fputs(xwInsertVarDef(prtScript),fh);
                   fputs("\n",fh);
                   strcpy(prtScript,"");
                }
            }
            else
            {
               priMin=priMax;
               priMax=999999;

               if ( (priMin/100)>lineNr )
               {
                  if (strlen(prtScript)>0)
                  {
                     fputs(xwInsertVarDef(prtScript),fh);
                     fputs("\n",fh);
                     strcpy(prtScript,"");
                  }
                  else
                  {
                     strcpy(prtScript,"");
                  }
                  lineNr=priMin/100;
               }

               if ( (GN==1) && (WD.option[PD.idxA[idx][WN]]!=NULL) ) strcat(prtScript,WD.option[PD.idxA[idx][WN]]);
               if ( (GN==2) && (WD.option[PD.idxB[idx][WN]]!=NULL) ) strcat(prtScript,WD.option[PD.idxB[idx][WN]]);
               if ( (GN==3) && (WD.option[PD.idxC[idx][WN]]!=NULL) ) strcat(prtScript,WD.option[PD.idxC[idx][WN]]);
               if ( (GN==4) && (WD.option[PD.idxD[idx][WN]]!=NULL) ) strcat(prtScript,WD.option[PD.idxD[idx][WN]]);

               /*printf("Script: %s\n",prtScript);*/
            }
         }
         fclose(fh);
      }
   }

   return;
}



