/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XWPRTGUI_H
#define _XWPRTGUI_H

#include <forms.h>

/* Widget Type */
#define pgNone          0
#define pgPixmap        1

/* Widget Group Type */
#define ptNone          0

/* Widget Definitions */
#define pdLimit         1000
#define pdNormal           0
#define pdGammaB           1
#define pdGammaW           2
#define pdRed              3
#define pdGreen            4
#define pdBlue             5
#define pdCyan             6
#define pdMagenta          7
#define pdYellow           8
#define pdSaturation    2000
#define pdContrast      2001
#define pdContrastC     2002
#define pdContrastM     2003
#define pdContrastY     2004
#define pdCorrect       2005
#define pdCorrectR      2006
#define pdCorrectG      2007
#define pdCorrectB      2008
#define pdCorrectC      2009
#define pdCorrectM      2010
#define pdCorrectY      2011
#define pdThreshold     2012

#define pdMaxWidget       30

/* 400 */
#define pdWidth          330

typedef struct guiform
{
   int            guiNr;

   FL_FORM        *form;
   FL_OBJECT      *button[30][10];
   int            flag[30][10];
   int            type[30];
   int            index[30];

} guiform;

/* Init Widgets */
void xwInitGUI(void);
/* Delete All Widgets */
void xwDeleteGUI(void);
/* Create GUI */
void xwCreateGUI(int prtNr,int guiNr,FL_FORM *form,int xpos, int ypos);
/* Add Choice Widget */
void xwAddChoice(void);
/* Add Boolean Widget */
void xwAddBoolean(void);
/* Add Slider Widget */
void xwAddSlider(int mode);
/* Add Input Widget */
void xwAddInput(void);
/* Add Exec Widget */
void xwAddExec(void);
/* Add LP Widget */
void xwAddLP(void);
/* Add TP Widget */
void xwAddTPBrowserA(int mo);
void xwAddTPBrowserB(int mo);

/* ########## Input Routines ########## */

/* Check GUI */
void xwCheckGUI(FL_OBJECT *obj,int guiNr,int prtNr);
/* Check Choice */
void xwCheckChoice(FL_OBJECT *obj);
/* Check Boolean */
void xwCheckBoolean(FL_OBJECT *obj);
/* Check Slider */
void xwCheckSlider(FL_OBJECT *obj);
/* Check Input */
void xwCheckInput(FL_OBJECT *obj);
/* Check Exec */
void xwCheckExec(FL_OBJECT *obj);
/* Check LP */
void xwCheckLP(FL_OBJECT *obj);


/* ########## Misc Routines ########## */

/* Get Widget Entry by Number */
char *xwGetWidgetText(int nr,int init,char *source);

#endif