/* xwGUI -- an X11-GUI for photo prints
 * Copyright (C) 2001 Stefan Kraus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prtgui.h"

#include "base.h"
#include "driver_lp.h"
#include "limits.h"
#include "prtmanager.h"
#include "resource.h"
#include "driver_turboprint.h"
#include "variable.h"

/* Icon Import */
#include "pixmaps/prefgui_con.xpm" /* Contrast */
#include "pixmaps/prefgui_conC.xpm"
#include "pixmaps/prefgui_conM.xpm"
#include "pixmaps/prefgui_conY.xpm"
#include "pixmaps/prefgui_corA.xpm" /* Color Correction */
#include "pixmaps/prefgui_corR.xpm"
#include "pixmaps/prefgui_corG.xpm"
#include "pixmaps/prefgui_corB.xpm"
#include "pixmaps/prefgui_corC.xpm"
#include "pixmaps/prefgui_corM.xpm"
#include "pixmaps/prefgui_corY.xpm"
#include "pixmaps/prefgui_sat.xpm"  /* Saturation */
#include "pixmaps/prefgui_th.xpm"   /* Threshold */

static guiform gf;

static int        xwPosXO;
static int        xwPosX;
static int        xwPosY;
static int        xwIndex;

static int        xwWNr;
static int        xwPrtNr;
static int        xwGuiNr;
static int        xwIdx;

/* Widget Entrys */
static char       xwEntrys[1024];
static char       xwWEntrys[1024];

/* Init Widgets */
void xwInitGUI(void)
{
   int            az,bz;

   gf.guiNr=-1;

   for (az=0 ; az<pdMaxWidget ; az++)
   {
      for (bz=0 ; bz<=9 ; bz++)
      {
         gf.button[az][bz]=NULL;
         gf.flag[az][bz]=pgNone;
      }
      gf.type[az]=ptNone;
      gf.index[az]=-1;
   }
   return;
}

/* Delete All Widgets */
void xwDeleteGUI(void)
{
   int            az,bz;

   for (az=0 ; az<pdMaxWidget ; az++)
   {
      for (bz=0 ; bz<=9 ; bz++)
      {
         if (gf.button[az][bz]!=NULL)
         {
            /* Hide Object */
            fl_hide_object(gf.button[az][bz]);
            /* Free Pixmap - If Object has an Pixmap */
            if (gf.flag[az][bz]==pgPixmap)
            {
               fl_free_pixmapbutton_pixmap(gf.button[az][bz]);
               gf.flag[az][bz]=pgNone;
            }
            /* Remove Object */
            fl_delete_object(gf.button[az][bz]);
            /* fl_free_object(gf.button[az][bz]); */
            gf.button[az][bz]=NULL;
         }
         gf.type[az]=ptNone;
         gf.index[az]=-1;
      }
   }
     
   return;
}

/* Create GUI */
void xwCreateGUI(int prtNr,int guiNr,FL_FORM *form,int xpos, int ypos)
{
   int            az,bz;
   char           wdType[128];   /* Widget Type */
   const char     *strptr;
   
   int            tpMode=-1;     /* TurboPrint Widget Mode */

   if ( (prtNr>-1) && (guiNr>-1) )
   {
      xwPosXO=xpos;
      xwPosX=xpos+80+xwGetPrinterGUITab(guiNr,prtNr); /* +100 */
      xwPosY=ypos+2;
      xwIndex=-1;

      xwPrtNr=prtNr;
      xwGuiNr=guiNr;

      /* Delete Old Widgets */
      xwDeleteGUI();

      /* Freeze Form */
      fl_freeze_form(form);

      /* Get Widget Counts */
      bz=xwGetPrinterWCount(guiNr,prtNr);
      if (bz>-1)
      {
         for (az=0 ; az<=bz ; az++)
         {
            /* TurboPrint Widget Mode */
            tpMode=-1;
         
            /* Get Widget */
            xwIdx=xwGetPrinterWIndex(xwGuiNr,xwPrtNr,az);

            /* Widget Entrys Check */
            strptr=xwGetPrinterWidgetWEntrys(guiNr,prtNr,az);
            if (strptr!=NULL)
            {
               strcpy(xwWEntrys,strptr);
            }
            else
            {
               strcpy(xwWEntrys,xwGetWidgetWEntrys(xwIdx));
            }
            strptr=xwGetPrinterWidgetEntrys(guiNr,prtNr,az);
            if (strptr!=NULL)
            {
               strcpy(xwEntrys,strptr);
            }
            else
            {
               strcpy(xwEntrys,xwGetWidgetEntrys(xwIdx));
            }

            if (strlen(xwGetWidgetType(xwIdx))>0)
            {
               strcpy(wdType,xwGetWidgetType(xwIdx));
               strUpper(wdType);

               /* Allows new Widgets */
               fl_addto_form(form);

               /* Choice Widget */
               if (strcmp(wdType,"CHOICE") == 0) xwAddChoice();
               /* Boolean Widget */
               else if (strcmp(wdType,"BOOLEAN") == 0) xwAddBoolean();
               /* Slider Widget */
               else if (strcmp(wdType,"SLIDER") == 0) xwAddSlider(pdNormal);
               /* GammaB Widget */
               else if (strcmp(wdType,"GAMMAB") == 0) xwAddSlider(pdGammaB);
               /* GammaW Widget */
               else if (strcmp(wdType,"GAMMAW") == 0) xwAddSlider(pdGammaW);
               /* Red Widget */
               else if (strcmp(wdType,"RED") == 0) xwAddSlider(pdRed);
               /* Green Widget */
               else if (strcmp(wdType,"GREEN") == 0) xwAddSlider(pdGreen);
               /* Blue Widget */
               else if (strcmp(wdType,"BLUE") == 0) xwAddSlider(pdBlue);
               /* Cyan Widget */
               else if (strcmp(wdType,"CYAN") == 0) xwAddSlider(pdCyan);
               /* Magenta Widget */
               else if (strcmp(wdType,"MAGENTA") == 0) xwAddSlider(pdMagenta);
               /* Yellow Widget */
               else if (strcmp(wdType,"YELLOW") == 0) xwAddSlider(pdYellow);
               /* Saturation Widget */
               else if (strcmp(wdType,"SATURATION") == 0) xwAddSlider(pdSaturation);
               /* Contrast Widget */
               else if (strcmp(wdType,"CONTRAST") == 0) xwAddSlider(pdContrast);
               /* Contrast C Widget */
               else if (strcmp(wdType,"CONTRASTC") == 0) xwAddSlider(pdContrastC);
               /* Contrast M Widget */
               else if (strcmp(wdType,"CONTRASTM") == 0) xwAddSlider(pdContrastM);
               /* Contrast Y Widget */
               else if (strcmp(wdType,"CONTRASTY") == 0) xwAddSlider(pdContrastY);
               /* Correct Widget */
               else if (strcmp(wdType,"CORRECT") == 0) xwAddSlider(pdCorrect);
               /* Correct R Widget */
               else if (strcmp(wdType,"CORRECTR") == 0) xwAddSlider(pdCorrectR);
               /* Correct G Widget */
               else if (strcmp(wdType,"CORRECTG") == 0) xwAddSlider(pdCorrectG);
               /* Correct B Widget */
               else if (strcmp(wdType,"CORRECTB") == 0) xwAddSlider(pdCorrectB);
               /* Correct C Widget */
               else if (strcmp(wdType,"CORRECTC") == 0) xwAddSlider(pdCorrectC);
               /* Correct M Widget */
               else if (strcmp(wdType,"CORRECTM") == 0) xwAddSlider(pdCorrectM);
               /* Correct Y Widget */
               else if (strcmp(wdType,"CORRECTY") == 0) xwAddSlider(pdCorrectY);
               /* Threshold Widget */
               else if (strcmp(wdType,"THRESHOLD") == 0) xwAddSlider(pdThreshold);
               
               /* Exec Widget */
               else if (strcmp(wdType,"EXEC") == 0) xwAddExec();

               /* Input Widget */
               else if (strcmp(wdType,"INPUT") == 0) xwAddInput();
               /* LP Widget */
               else if (strcmp(wdType,"LP") == 0) xwAddLP();

               /* TurboPrint Printer Browser */
               else if (strcmp(wdType,"TPPRINTER") == 0)
               {
                  xwAddTPBrowserA(0);
                  tpMode=0;
               }
               /* TurboPrint Quality Browser */
               else if (strcmp(wdType,"TPQUALITY") == 0)
               {
                  xwAddTPBrowserA(1);
                  tpMode=1;
               }
               /* TurboPrint Paper Browser */
               else if (strcmp(wdType,"TPPAPER") == 0)
               {
                  xwAddTPBrowserA(2);
                  tpMode=2;
               }
               /* TurboPrint Media Browser */
               else if (strcmp(wdType,"TPMEDIA") == 0)
               {
                  xwAddTPBrowserA(3);
                  tpMode=3;
               }
               
               /* Close new Widget Definitions */
               fl_end_form();
               
               /* TurboPrint Browser Initialize */
               if (tpMode>-1) xwAddTPBrowserB(tpMode);
               
            }
            else
            {
               if (xwIndex<(pdMaxWidget-1)) xwIndex++;
            }
         }
      }

      /* unfreeze form */
      fl_unfreeze_form(form);
   }

   /*xwListVarDef();*/

   return;
}

/* Add Choice Widget */
void xwAddChoice(void)
{
   int            xx;
   int            az,bz,cz,dz;
   char           astr[1024],bstr[1024];
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      xx=xwPosX;
      if (xwGetWidgetTab(xwIdx)==0) xx=xx+25;

      /* Draw Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_choice(FL_DROPLIST_CHOICE,xx,xwPosY,pdWidth,20,xwGR(1,strptr,strptr));
      fl_set_object_boxtype(gf.button[xwIndex][0],FL_UP_BOX);

      /* Init Widget Entrys */
      strcpy(astr,xwWEntrys);
      if (strlen(astr)>0)
      {
         bz=0;
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]!='|')
            {
               bstr[bz]=astr[az];
               bz++;
            }
            else
            {
               bstr[bz]=0x00;
               if (strlen(bstr)==0) strcat(bstr,"-----");
               fl_addto_choice(gf.button[xwIndex][0],xwGR(1,bstr,bstr));

               bstr[0]=0x00;
               bz=0;
            }
         }
         bstr[bz]=0x00;
         if (strlen(bstr)==0) strcat(bstr,"-----");
         fl_addto_choice(gf.button[xwIndex][0],xwGR(1,bstr,bstr));
      }

      /* Search Widget Entry */
      strcpy(astr,xwEntrys);
      if (strlen(astr)>0)
      {
         cz=-1;
         dz=-1;
         bz=0;
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]!='|')
            {
               bstr[bz]=astr[az];
               bz++;
            }
            else
            {
               bstr[bz]=0x00;

               if (strcmp(bstr,xwGetVarDef(xwGetWidgetVariable(xwIdx))) == 0)
               {
                  dz=cz+1;
               }
               else
               {
                  cz++;
               }

               bstr[0]=0x00;
               bz=0;
            }
         }
         bstr[bz]=0x00;
         if (strcmp(bstr,xwGetVarDef(xwGetWidgetVariable(xwIdx))) == 0)
         {
            dz=cz+1;
         }
      }

      /* printf("dz=%i\n",dz); */

      if (dz>-1)
      {
         fl_set_choice(gf.button[xwIndex][0],dz+1);
      }
      else
      {
         fl_set_choice(gf.button[xwIndex][0],1);
      }

      xwPosY=xwPosY+22;
   }

   return;
}

/* Add Boolean Widget */
void xwAddBoolean(void)
{
   int            xx;
   int            az,bz,cz,dz;
   char           astr[1024],bstr[1024];
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      xx=xwPosX;
      if (xwGetWidgetTab(xwIdx)==0) xx=xx+25;

      /* Draw Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_lightbutton(FL_PUSH_BUTTON,xx,xwPosY,pdWidth,20,xwGR(1,strptr,strptr));

      /* Search Widget Entry */
      strcpy(astr,xwEntrys);
      if (strlen(astr)>0)
      {
         cz=-1;
         bz=0;
         for (az=0 ; az<strlen(astr) ; az++)
         {
            if (astr[az]!='|')
            {
               bstr[bz]=astr[az];
               bz++;
            }
            else
            {
               bstr[bz]=0x00;

               if (strcmp(bstr,xwGetVarDef(xwGetWidgetVariable(xwIdx))) == 0)
               {
                  dz=cz+1;
               }
               else
               {
                  cz++;
               }

               bstr[0]=0x00;
               bz=0;
            }
         }
         bstr[bz]=0x00;
         if (strcmp(bstr,xwGetVarDef(xwGetWidgetVariable(xwIdx))) == 0)
         {
            dz=cz+1;
         }
      }
      if (dz>-1)
      {
         fl_set_button(gf.button[xwIndex][0],dz);
      }

      xwPosY=xwPosY+22;
   }

   return;
}

/* Add Slider Widget */
void xwAddSlider(int mode)
{
   int            xx;
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      xx=xwPosX;
      if (xwGetWidgetTab(xwIdx)==0) xx=xx+25;

      if (mode<pdLimit)
      {
         /* Draw Widget */
         strptr=xwGetWidgetName(xwIdx);
         gf.button[xwIndex][0]=fl_add_input(FL_FLOAT_INPUT,xx,xwPosY,50,20,xwGR(1,strptr,strptr));
         fl_set_object_lalign(gf.button[xwIndex][0],FL_ALIGN_LEFT);
         gf.button[xwIndex][1]=fl_add_slider(FL_HOR_SLIDER,xx+50,xwPosY,360,20,"");
         xwPosY=xwPosY+22;
      }
      else
      {
         /* Draw Widget */
         strptr=xwGetWidgetName(xwIdx);
         gf.button[xwIndex][0]=fl_add_input(FL_FLOAT_INPUT,xx,xwPosY+20,50,20,xwGR(1,strptr,strptr));
         fl_set_object_lalign(gf.button[xwIndex][0],FL_ALIGN_LEFT);
         gf.button[xwIndex][1]=fl_add_slider(FL_HOR_SLIDER,xx+50,xwPosY+20,360,20,"");
         gf.button[xwIndex][2]=fl_add_pixmap(FL_NORMAL_PIXMAP,xx+50,xwPosY,360,20,"");
         xwPosY=xwPosY+42;
      }

      if (mode==pdSaturation)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_sat_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
      }
      else if (mode==pdContrast)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_con_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
      }
      else if (mode==pdContrastC)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_conC_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_CYAN,FL_DARKCYAN);
      }
      else if (mode==pdContrastM)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_conM_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_MAGENTA,FL_ORCHID);
      }
      else if (mode==pdContrastY)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_conY_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_YELLOW,FL_DARKGOLD);
      }
      else if (mode==pdCorrect)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corA_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
      }
      else if (mode==pdCorrectR)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corR_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_RED,FL_INDIANRED);
      }
      else if (mode==pdCorrectG)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corG_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_GREEN,FL_PALEGREEN);
      }
      else if (mode==pdCorrectB)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corB_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_BLUE,FL_SLATEBLUE);
      }
      else if (mode==pdCorrectC)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corC_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_CYAN,FL_DARKCYAN);
      }
      else if (mode==pdCorrectM)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corM_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_MAGENTA,FL_ORCHID);
      }
      else if (mode==pdCorrectY)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_corY_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_YELLOW,FL_DARKGOLD);
      }
      else if (mode==pdThreshold)
      {
         fl_set_pixmap_data(gf.button[xwIndex][2],prefgui_th_xpm);
         gf.flag[xwIndex][2]=pgPixmap;
         fl_set_object_color(gf.button[xwIndex][1],FL_YELLOW,FL_DARKGOLD);
      }

      else if (mode==pdGammaB)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_COL1,FL_BOTTOM_BCOL);
      }
      else if (mode==pdGammaW)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_COL1,FL_WHITE);
      }
      else if (mode==pdRed)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_RED,FL_INDIANRED);
      }
      else if (mode==pdGreen)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_GREEN,FL_PALEGREEN);
      }
      else if (mode==pdBlue)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_BLUE,FL_SLATEBLUE);
      }
      else if (mode==pdCyan)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_CYAN,FL_DARKCYAN);
      }
      else if (mode==pdMagenta)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_MAGENTA,FL_ORCHID);
      }
      else if (mode==pdYellow)
      {
         fl_set_object_color(gf.button[xwIndex][1],FL_YELLOW,FL_DARKGOLD);
      }
#ifdef xwWhiteInput
      fl_set_object_color(gf.button[xwIndex][0],FL_WHITE,FL_WHITE);
#endif

      /* Set Widget Datas */
      fl_set_input(gf.button[xwIndex][0],xwGetVarDef(xwGetWidgetVariable(xwIdx)));
      fl_set_slider_bounds(gf.button[xwIndex][1],xwGetWidgetMinVal(xwIdx),xwGetWidgetMaxVal(xwIdx));
      fl_set_slider_step(gf.button[xwIndex][1],xwGetWidgetStep(xwIdx));
      fl_set_slider_value(gf.button[xwIndex][1],xwGetFVarDef(xwGetWidgetVariable(xwIdx)));
   }

   return;
}

/* Add Input Widget */
void xwAddInput(void)
{
   int            xx;
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      xx=xwPosX;
      if (xwGetWidgetTab(xwIdx)==0) xx=xx+25;

      /* Draw Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_input(FL_NORMAL_INPUT,xx,xwPosY,pdWidth,20,xwGR(1,strptr,strptr));
/*
      fl_set_object_lstyle(gf.button[xwIndex][0],FL_FIXED_STYLE);
      fl_set_object_lsize(gf.button[xwIndex][0],FL_NORMAL_SIZE);
*/
#ifdef xwWhiteInput
      fl_set_object_color(gf.button[xwIndex][0],FL_WHITE,FL_WHITE);
#endif
      fl_set_input(gf.button[xwIndex][0],xwGetVarDef(xwGetWidgetVariable(xwIdx)));

      xwPosY=xwPosY+22;
   }

   return;
}

/* Add Exec Widget */
void xwAddExec(void)
{
   int            xx;
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      xx=xwPosX;
      if (xwGetWidgetTab(xwIdx)==0) xx=xx+25;

      /* Draw Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_button(FL_NORMAL_BUTTON,xx,xwPosY,pdWidth,20,xwGR(1,strptr,strptr));

      xwPosY=xwPosY+22;
   }

   return;
}

/* Add LP Widget */
void xwAddLP(void)
{
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_browser(FL_HOLD_BROWSER,xwPosXO+2,xwPosY,488,200,xwGR(1,strptr,strptr));
      fl_set_browser_fontstyle(gf.button[xwIndex][0],FL_FIXED_STYLE);
      fl_set_browser_fontsize(gf.button[xwIndex][0],FL_NORMAL_SIZE);

      xwCreateLPWidget(xwGetVarDef(xwGetWidgetVariable(xwIdx)),gf.button[xwIndex][0]);

      xwPosY=xwPosY+202;
   }

   return;
}

/* Add TurboPrint Widget */
void xwAddTPBrowserA(int mo)
{
   char           *strptr;

   xwIndex++;
   if (xwIndex<pdMaxWidget-1)
   {
      /* Create Widget */
      strptr=xwGetWidgetName(xwIdx);
      gf.button[xwIndex][0]=fl_add_browser(FL_HOLD_BROWSER,xwPosXO+2,xwPosY,488,200,xwGR(1,strptr,strptr));
      fl_set_browser_fontstyle(gf.button[xwIndex][0],FL_FIXED_STYLE);
      /*fl_set_browser_fontsize(gf.button[xwIndex][0],FL_NORMAL_SIZE);*/

      xwPosY=xwPosY+202;
   }

   return;
}
/* Add TurboPrint Widget */
void xwAddTPBrowserB(int mo)
{
   if (xwIndex<pdMaxWidget-1)
   {
      /* Printer */
      if (mo==0) tpListPrinter(gf.button[xwIndex][0]);
      /* Quality */
      if (mo==1) tpListQuality(gf.button[xwIndex][0]);
      /* Paper */
      if (mo==2) tpListPaper(gf.button[xwIndex][0]);
      /* Media */
      if (mo==3) tpListMedia(gf.button[xwIndex][0]);
   }

   return;
}



/* ########## Input Routines ########## */

/* Check GUI */
void xwCheckGUI(FL_OBJECT *obj,int guiNr,int prtNr)
{
   int            az,bz,cz;
   int            wNr;
   char           wdType[128];   /* Widget Type */
   char           *strptr;

   if ( (guiNr>0) && (prtNr>-1) )
   {
      xwGuiNr=guiNr;
      xwPrtNr=prtNr;

      /* Get Widget Counts */
      bz=xwGetPrinterWCount(xwGuiNr,xwPrtNr);
      if (bz>-1)
      {
         wNr=-1;

         /* Search Widget */
         for (az=0 ; az<=bz ; az++)
         {
            for (cz=0 ; cz<=9 ; cz++)
            {
               if (obj==gf.button[az][cz])
               {
                  wNr=az;
               }
            }
         }

         /* Widget found */
         if (wNr>-1)
         {
            xwWNr=wNr;
            xwIdx=xwGetPrinterWIndex(xwGuiNr,xwPrtNr,xwWNr);

            if (strlen(xwGetWidgetType(xwIdx))>0)
            {
               strcpy(wdType,xwGetWidgetType(xwIdx));
               strUpper(wdType);

               /* Widget Entrys Check */
               strptr=xwGetPrinterWidgetWEntrys(guiNr,prtNr,xwWNr);
               if (strptr!=NULL)
               {
                  strcpy(xwWEntrys,strptr);
               }
               else
               {
                  strcpy(xwWEntrys,xwGetWidgetWEntrys(xwIdx));
               }
               strptr=xwGetPrinterWidgetEntrys(guiNr,prtNr,xwWNr);
               if (strptr!=NULL)
               {
                  strcpy(xwEntrys,strptr);
               }
               else
               {
                  strcpy(xwEntrys,xwGetWidgetEntrys(xwIdx));
               }

               /* Choice Widget */
               if (strcmp(wdType,"CHOICE") == 0) xwCheckChoice(obj);

               /* Boolean Widget */
               else if (strcmp(wdType,"BOOLEAN") == 0) xwCheckBoolean(obj);

               /* Slider Widget */
               else if (strcmp(wdType,"SLIDER") == 0) xwCheckSlider(obj);

               /* GammaB Widget */
               else if (strcmp(wdType,"GAMMAB") == 0) xwCheckSlider(obj);
               /* GammaW Widget */
               else if (strcmp(wdType,"GAMMAW") == 0) xwCheckSlider(obj);
               /* Red Widget */
               else if (strcmp(wdType,"RED") == 0) xwCheckSlider(obj);
               /* Green Widget */
               else if (strcmp(wdType,"GREEN") == 0) xwCheckSlider(obj);
               /* Blue Widget */
               else if (strcmp(wdType,"BLUE") == 0) xwCheckSlider(obj);
               /* Cyan Widget */
               else if (strcmp(wdType,"CYAN") == 0) xwCheckSlider(obj);
               /* Magenta Widget */
               else if (strcmp(wdType,"MAGENTA") == 0) xwCheckSlider(obj);
               /* Yellow Widget */
               else if (strcmp(wdType,"YELLOW") == 0) xwCheckSlider(obj);
               /* Saturation Widget */
               else if (strcmp(wdType,"SATURATION") == 0) xwCheckSlider(obj);
               /* Contrast Widget */
               else if (strcmp(wdType,"CONTRAST") == 0) xwCheckSlider(obj);
               /* Contrast C Widget */
               else if (strcmp(wdType,"CONTRASTC") == 0) xwCheckSlider(obj);
               /* Contrast M Widget */
               else if (strcmp(wdType,"CONTRASTM") == 0) xwCheckSlider(obj);
               /* Contrast Y Widget */
               else if (strcmp(wdType,"CONTRASTY") == 0) xwCheckSlider(obj);
               /* Correct Widget */
               else if (strcmp(wdType,"CORRECT") == 0) xwCheckSlider(obj);
               /* Correct R Widget */
               else if (strcmp(wdType,"CORRECTR") == 0) xwCheckSlider(obj);
               /* Correct G Widget */
               else if (strcmp(wdType,"CORRECTG") == 0) xwCheckSlider(obj);
               /* Correct B Widget */
               else if (strcmp(wdType,"CORRECTB") == 0) xwCheckSlider(obj);
               /* Correct C Widget */
               else if (strcmp(wdType,"CORRECTC") == 0) xwCheckSlider(obj);
               /* Correct M Widget */
               else if (strcmp(wdType,"CORRECTM") == 0) xwCheckSlider(obj);
               /* Correct Y Widget */
               else if (strcmp(wdType,"CORRECTY") == 0) xwCheckSlider(obj);
               /* Threshold Widget */
               else if (strcmp(wdType,"THRESHOLD") == 0) xwCheckSlider(obj);
               /* Check Exec */
               else if (strcmp(wdType,"EXEC") == 0) xwCheckExec(obj);
               
               /* Input Widget */
               else if (strcmp(wdType,"INPUT") == 0) xwCheckInput(obj);
               /* LP Widget */
               else if (strcmp(wdType,"LP") == 0) xwCheckLP(obj);
               
               /* TurboPrint Printer Browser */
               else if (strcmp(wdType,"TPPRINTER") == 0)
               {
                  tpGetPrinter(obj);
               }
               /* TurboPrint Quality Browser */
               else if (strcmp(wdType,"TPQUALITY") == 0)
               {
                  tpGetQuality(obj);
               }
               /* TurboPrint Paper Browser */
               else if (strcmp(wdType,"TPPAPER") == 0)
               {
                  tpGetPaper(obj);
               }
               /* TurboPrint Media Browser */
               else if (strcmp(wdType,"TPMEDIA") == 0)
               {
                  tpGetMedia(obj);
               }
               
            }

            /* xwListVarDef(); */
         }

         /* Check all Input Fields */
         for (az=0 ; az<=bz ; az++)
         {
            obj=gf.button[az][0];
            xwWNr=az;
            xwIdx=xwGetPrinterWIndex(xwGuiNr,xwPrtNr,xwWNr);

            if ( (strlen(xwGetWidgetType(xwIdx))>0) && (obj!=NULL) )
            {
               strcpy(wdType,xwGetWidgetType(xwIdx));
               strUpper(wdType);
               /* Slider Widget */
               if (strcmp(wdType,"SLIDER") == 0) xwCheckSlider(obj);
               /* Input Widget */
               else if (strcmp(wdType,"INPUT") == 0) xwCheckInput(obj);
            }

         }

      }
   }
   return;
}

/* Check Choice */
void xwCheckChoice(FL_OBJECT *obj)
{
   int            aaz;

   if (obj==gf.button[xwWNr][0])
   {
      aaz=fl_get_choice(obj);
      if (aaz>-1)
      {
         /* Search Widget Entry */
         xwSetVarDef(xwGetWidgetVariable(xwIdx),xwGetWidgetText(aaz,0,xwEntrys));
      }
   }
   return;
}

/* Check Boolean */
void xwCheckBoolean(FL_OBJECT *obj)
{
   int            aaz;

   if (obj==gf.button[xwWNr][0])
   {
      aaz=fl_get_button(obj);
      if (aaz>-1)
      {
         /* Search Widget Entry */
         xwSetVarDef(xwGetWidgetVariable(xwIdx),xwGetWidgetText(aaz,-1,xwEntrys));
      }
   }
   return;
}

/* Check Slider */
void xwCheckSlider(FL_OBJECT *obj)
{
   float          zahl;

   /* Input Fild */
   if (obj==gf.button[xwWNr][0])
   {
      zahl=atof(fl_get_input(obj));
      fl_set_slider_value(gf.button[xwWNr][1],zahl);

      /* Search Widget Entry */
      xwSetFVarDef(xwGetWidgetVariable(xwIdx),zahl);
   }

   /* Slider Widget */
   if (obj==gf.button[xwWNr][1])
   {
      zahl=fl_get_slider_value(obj);

      /* Search Widget Entry */
      xwSetFVarDef(xwGetWidgetVariable(xwIdx),zahl);

     fl_set_input(gf.button[xwWNr][0],xwGetVarDef(xwGetWidgetVariable(xwIdx)));
   }

   return;
}

/* Check Input */
void xwCheckInput(FL_OBJECT *obj)
{
   /* Input Fild */
   if (obj==gf.button[xwWNr][0])
   {
      /* Search Widget Entry */
      xwSetVarDef(xwGetWidgetVariable(xwIdx),(char *) fl_get_input(obj));
   }

   return;
}

/* Check Exec */
void xwCheckExec(FL_OBJECT *obj)
{
   fl_exe_command(xwGetVarDef(xwGetWidgetVariable(xwIdx)),-1);

   return;
}

/* Check LP */
void xwCheckLP(FL_OBJECT *obj)
{
   char           astr[1024];

   int            lNr;
   char           *strptr;

   /* Browser Fild */
   if (obj==gf.button[xwWNr][0])
   {
      /* Search Widget Entry */
      lNr=fl_get_browser(obj);
      if (lNr>0)
      {
         strcpy(astr,fl_get_browser_line(obj,lNr));
         strptr=strchr(astr,':');
         strptr[0]=0x00;
         xwSetVarDef(xwGetWidgetVariable(xwIdx),astr);
      }
   }

   return;
}


/* ########## Misc Routines ########## */

/* Get Widget Entry by Number */
char *xwGetWidgetText(int nr,int init,char *source)
{
   int            az,bz,cz,dz;
   char           astr[1024];
   static char    bstr[1024];

   strcpy(astr,source);
   if (strlen(astr)>0)
   {
      cz=init;   /* Widget Count */
      dz=-1;
      bz=0;
      for (az=0 ; az<strlen(astr) ; az++)
      {
         if (astr[az]!='|')
         {
            bstr[bz]=astr[az];
            bz++;
         }
         else
         {
            bstr[bz]=0x00;

            cz++;
            if (cz==nr) return(bstr);

            bstr[0]=0x00;
            bz=0;
         }
      }
      bstr[bz]=0x00;
      cz++;
      if (cz==nr) return(bstr);
   }
   return("");
}
